/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure.util;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

import eu.qimpress.identifier.util.IdentifierValidator;
import eu.qimpress.samm.staticstructure.*;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EndPoint;
import eu.qimpress.samm.staticstructure.EventPort;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.OperationException;
import eu.qimpress.samm.staticstructure.Parameter;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage
 * @generated
 */
public class StaticstructureValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final StaticstructureValidator INSTANCE = new StaticstructureValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "eu.qimpress.samm.staticstructure";

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'All Sub Component Instances Are Deployed' of 'Service Architecture Model'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int SERVICE_ARCHITECTURE_MODEL__ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED = 1;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'All Assembly Connectors Are On The Same Level' of 'Composite Structure'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int COMPOSITE_STRUCTURE__ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL = 2;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'All Delegation Connectors Reference Only One Level Nested Subcomponents' of 'Composite Structure'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int COMPOSITE_STRUCTURE__ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS = 3;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Has To Provide Or Require Services' of 'Component Type'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int COMPONENT_TYPE__HAS_TO_PROVIDE_OR_REQUIRE_SERVICES = 4;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'No Interface Port Associated Twice' of 'Component Type'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int COMPONENT_TYPE__NO_INTERFACE_PORT_ASSOCIATED_TWICE = 5;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Port Must Be Either ARequired Or AProvided Port' of 'Interface Port'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int INTERFACE_PORT__PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT = 6;

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'One Level Connectors' of 'Connector'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int CONNECTOR__ONE_LEVEL_CONNECTORS = 7;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 7;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StaticstructureValidator() {
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return StaticstructurePackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case StaticstructurePackage.PASSIVE_RESOURCE:
				return validatePassiveResource((PassiveResource)value, diagnostics, context);
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL:
				return validateServiceArchitectureModel((ServiceArchitectureModel)value, diagnostics, context);
			case StaticstructurePackage.COMPOSITE_STRUCTURE:
				return validateCompositeStructure((CompositeStructure)value, diagnostics, context);
			case StaticstructurePackage.SUBCOMPONENT_INSTANCE:
				return validateSubcomponentInstance((SubcomponentInstance)value, diagnostics, context);
			case StaticstructurePackage.COMPONENT_TYPE:
				return validateComponentType((ComponentType)value, diagnostics, context);
			case StaticstructurePackage.PORT_ENABLED_ENTITY:
				return validatePortEnabledEntity((PortEnabledEntity)value, diagnostics, context);
			case StaticstructurePackage.INTERFACE_PORT:
				return validateInterfacePort((InterfacePort)value, diagnostics, context);
			case StaticstructurePackage.PORT:
				return validatePort((Port)value, diagnostics, context);
			case StaticstructurePackage.INTERFACE:
				return validateInterface((Interface)value, diagnostics, context);
			case StaticstructurePackage.OPERATION:
				return validateOperation((Operation)value, diagnostics, context);
			case StaticstructurePackage.MESSAGE_TYPE:
				return validateMessageType((MessageType)value, diagnostics, context);
			case StaticstructurePackage.PARAMETER:
				return validateParameter((Parameter)value, diagnostics, context);
			case StaticstructurePackage.OPERATION_EXCEPTION:
				return validateOperationException((OperationException)value, diagnostics, context);
			case StaticstructurePackage.EVENT_PORT:
				return validateEventPort((EventPort)value, diagnostics, context);
			case StaticstructurePackage.CONNECTOR:
				return validateConnector((Connector)value, diagnostics, context);
			case StaticstructurePackage.END_POINT:
				return validateEndPoint((EndPoint)value, diagnostics, context);
			case StaticstructurePackage.SUBCOMPONENT_ENDPOINT:
				return validateSubcomponentEndpoint((SubcomponentEndpoint)value, diagnostics, context);
			case StaticstructurePackage.REPOSITORY:
				return validateRepository((Repository)value, diagnostics, context);
			case StaticstructurePackage.COMPONENT_ENDPOINT:
				return validateComponentEndpoint((ComponentEndpoint)value, diagnostics, context);
			case StaticstructurePackage.COMPOSITE_COMPONENT:
				return validateCompositeComponent((CompositeComponent)value, diagnostics, context);
			case StaticstructurePackage.PRIMITIVE_COMPONENT:
				return validatePrimitiveComponent((PrimitiveComponent)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePassiveResource(PassiveResource passiveResource, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(passiveResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(passiveResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(passiveResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(passiveResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(passiveResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(passiveResource, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(passiveResource, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(passiveResource, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateServiceArchitectureModel(ServiceArchitectureModel serviceArchitectureModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validateCompositeStructure_AllAssemblyConnectorsAreOnTheSameLevel(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validateCompositeStructure_AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(serviceArchitectureModel, diagnostics, context);
		if (result || diagnostics != null) result &= validateServiceArchitectureModel_AllSubComponentInstancesAreDeployed(serviceArchitectureModel, diagnostics, context);
		return result;
	}

	/**
	 * Validates the AllSubComponentInstancesAreDeployed constraint of '<em>Service Architecture Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateServiceArchitectureModel_AllSubComponentInstancesAreDeployed(ServiceArchitectureModel serviceArchitectureModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return serviceArchitectureModel.AllSubComponentInstancesAreDeployed(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCompositeStructure(CompositeStructure compositeStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= validateCompositeStructure_AllAssemblyConnectorsAreOnTheSameLevel(compositeStructure, diagnostics, context);
		if (result || diagnostics != null) result &= validateCompositeStructure_AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(compositeStructure, diagnostics, context);
		return result;
	}

	/**
	 * Validates the AllAssemblyConnectorsAreOnTheSameLevel constraint of '<em>Composite Structure</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCompositeStructure_AllAssemblyConnectorsAreOnTheSameLevel(CompositeStructure compositeStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return compositeStructure.AllAssemblyConnectorsAreOnTheSameLevel(diagnostics, context);
	}

	/**
	 * Validates the AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents constraint of '<em>Composite Structure</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCompositeStructure_AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(CompositeStructure compositeStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return compositeStructure.AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSubcomponentInstance(SubcomponentInstance subcomponentInstance, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(subcomponentInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(subcomponentInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(subcomponentInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(subcomponentInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(subcomponentInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(subcomponentInstance, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(subcomponentInstance, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(subcomponentInstance, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateComponentType(ComponentType componentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= validateComponentType_HasToProvideOrRequireServices(componentType, diagnostics, context);
		if (result || diagnostics != null) result &= validateComponentType_NoInterfacePortAssociatedTwice(componentType, diagnostics, context);
		return result;
	}

	/**
	 * Validates the HasToProvideOrRequireServices constraint of '<em>Component Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateComponentType_HasToProvideOrRequireServices(ComponentType componentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return componentType.HasToProvideOrRequireServices(diagnostics, context);
	}

	/**
	 * Validates the NoInterfacePortAssociatedTwice constraint of '<em>Component Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateComponentType_NoInterfacePortAssociatedTwice(ComponentType componentType, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return componentType.NoInterfacePortAssociatedTwice(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePortEnabledEntity(PortEnabledEntity portEnabledEntity, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(portEnabledEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(portEnabledEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(portEnabledEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(portEnabledEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(portEnabledEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(portEnabledEntity, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(portEnabledEntity, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(portEnabledEntity, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateInterfacePort(InterfacePort interfacePort, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(interfacePort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(interfacePort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(interfacePort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(interfacePort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(interfacePort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(interfacePort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(interfacePort, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(interfacePort, diagnostics, context);
		if (result || diagnostics != null) result &= validateInterfacePort_PortMustBeEitherARequiredOrAProvidedPort(interfacePort, diagnostics, context);
		return result;
	}

	/**
	 * Validates the PortMustBeEitherARequiredOrAProvidedPort constraint of '<em>Interface Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateInterfacePort_PortMustBeEitherARequiredOrAProvidedPort(InterfacePort interfacePort, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return interfacePort.PortMustBeEitherARequiredOrAProvidedPort(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePort(Port port, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(port, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(port, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(port, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(port, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(port, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(port, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(port, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(port, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateInterface(Interface interface_, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(interface_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(interface_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(interface_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(interface_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(interface_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(interface_, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(interface_, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(interface_, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOperation(Operation operation, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(operation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(operation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(operation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(operation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(operation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(operation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(operation, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(operation, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMessageType(MessageType messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(messageType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(messageType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(messageType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(messageType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(messageType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(messageType, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(messageType, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(messageType, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateParameter(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(parameter, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(parameter, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(parameter, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(parameter, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(parameter, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(parameter, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(parameter, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(parameter, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateOperationException(OperationException operationException, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(operationException, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(operationException, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(operationException, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(operationException, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(operationException, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(operationException, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(operationException, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(operationException, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEventPort(EventPort eventPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(eventPort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(eventPort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(eventPort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(eventPort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(eventPort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(eventPort, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(eventPort, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(eventPort, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateConnector(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(connector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(connector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(connector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(connector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(connector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(connector, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(connector, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(connector, diagnostics, context);
		if (result || diagnostics != null) result &= validateConnector_oneLevelConnectors(connector, diagnostics, context);
		return result;
	}

	/**
	 * Validates the oneLevelConnectors constraint of '<em>Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateConnector_oneLevelConnectors(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return connector.oneLevelConnectors(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateEndPoint(EndPoint endPoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(endPoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(endPoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(endPoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(endPoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(endPoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(endPoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(endPoint, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(endPoint, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateSubcomponentEndpoint(SubcomponentEndpoint subcomponentEndpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(subcomponentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(subcomponentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(subcomponentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(subcomponentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(subcomponentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(subcomponentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(subcomponentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(subcomponentEndpoint, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateRepository(Repository repository, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(repository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(repository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(repository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(repository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(repository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(repository, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(repository, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(repository, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateComponentEndpoint(ComponentEndpoint componentEndpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(componentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(componentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(componentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(componentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(componentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(componentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(componentEndpoint, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(componentEndpoint, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCompositeComponent(CompositeComponent compositeComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateComponentType_HasToProvideOrRequireServices(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateComponentType_NoInterfacePortAssociatedTwice(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateCompositeStructure_AllAssemblyConnectorsAreOnTheSameLevel(compositeComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateCompositeStructure_AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(compositeComponent, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePrimitiveComponent(PrimitiveComponent primitiveComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateComponentType_HasToProvideOrRequireServices(primitiveComponent, diagnostics, context);
		if (result || diagnostics != null) result &= validateComponentType_NoInterfacePortAssociatedTwice(primitiveComponent, diagnostics, context);
		return result;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //StaticstructureValidator
