/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure.impl;

import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

import eu.qimpress.samm.deployment.allocation.Service;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EventPort;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.samm.staticstructure.util.StaticstructureValidator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Service Architecture Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.ServiceArchitectureModelImpl#getSubcomponents <em>Subcomponents</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.ServiceArchitectureModelImpl#getConnector <em>Connector</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.ServiceArchitectureModelImpl#getService <em>Service</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ServiceArchitectureModelImpl extends PortEnabledEntityImpl implements ServiceArchitectureModel {
	/**
	 * The cached value of the '{@link #getSubcomponents() <em>Subcomponents</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubcomponents()
	 * @generated
	 * @ordered
	 */
	protected EList<SubcomponentInstance> subcomponents;
	/**
	 * The cached value of the '{@link #getConnector() <em>Connector</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConnector()
	 * @generated
	 * @ordered
	 */
	protected EList<Connector> connector;
	/**
	 * The cached value of the '{@link #getService() <em>Service</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getService()
	 * @generated
	 * @ordered
	 */
	protected EList<Service> service;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceArchitectureModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return StaticstructurePackage.Literals.SERVICE_ARCHITECTURE_MODEL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<SubcomponentInstance> getSubcomponents() {
		if (subcomponents == null) {
			subcomponents = new EObjectContainmentEList<SubcomponentInstance>(SubcomponentInstance.class, this, StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS);
		}
		return subcomponents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Connector> getConnector() {
		if (connector == null) {
			connector = new EObjectContainmentEList<Connector>(Connector.class, this, StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__CONNECTOR);
		}
		return connector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Service> getService() {
		if (service == null) {
			service = new EObjectContainmentEList<Service>(Service.class, this, StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SERVICE);
		}
		return service;
	}

	/**
	 * The cached OCL expression body for the '{@link #AllAssemblyConnectorsAreOnTheSameLevel(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>All Assembly Connectors Are On The Same Level</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AllAssemblyConnectorsAreOnTheSameLevel(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "-- for all assembly connectors:\n"+"-- check if all referenced subcomponentendpoints reference a subcomponent that is directly nested in the composed structure\n"+"self.connector->select(con|con.isDelegation = false)->forAll(asconnector | asconnector.endpoints->forAll(sce | self.subcomponents->exists(subcomp | subcomp.id =  sce.oclAsType(SubcomponentEndpoint).subcomponent.id)))";
	/**
	 * The cached OCL invariant for the '{@link #AllAssemblyConnectorsAreOnTheSameLevel(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>All Assembly Connectors Are On The Same Level</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AllAssemblyConnectorsAreOnTheSameLevel(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean AllAssemblyConnectorsAreOnTheSameLevel(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(StaticstructurePackage.Literals.COMPOSITE_STRUCTURE);
			try {
				ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 StaticstructureValidator.DIAGNOSTIC_SOURCE,
						 StaticstructureValidator.COMPOSITE_STRUCTURE__ALL_ASSEMBLY_CONNECTORS_ARE_ON_THE_SAME_LEVEL,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "AllAssemblyConnectorsAreOnTheSameLevel", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * The cached OCL expression body for the '{@link #AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>All Delegation Connectors Reference Only One Level Nested Subcomponents</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "-- for all delegation connectors:\n"+"-- check if all referenced subcomponentendpoints reference a subcomponent that is directly nested in the composed structure\n"+"self.connector->select(con|con.isDelegation = true)->forAll(delconnector | delconnector.endpoints->select (endpoint | endpoint.oclIsTypeOf(SubcomponentEndpoint))->forAll(sce | self.subcomponents->exists(subcomp | subcomp.id =  sce.oclAsType(SubcomponentEndpoint).subcomponent.id)))";
	/**
	 * The cached OCL invariant for the '{@link #AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>All Delegation Connectors Reference Only One Level Nested Subcomponents</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(StaticstructurePackage.Literals.COMPOSITE_STRUCTURE);
			try {
				ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 StaticstructureValidator.DIAGNOSTIC_SOURCE,
						 StaticstructureValidator.COMPOSITE_STRUCTURE__ALL_DELEGATION_CONNECTORS_REFERENCE_ONLY_ONE_LEVEL_NESTED_SUBCOMPONENTS,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * The cached OCL expression body for the '{@link #AllSubComponentInstancesAreDeployed(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>All Sub Component Instances Are Deployed</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AllSubComponentInstancesAreDeployed(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "self.subcomponents->forAll(e|self.service->exists(s|s.subcomponentInstance.id = e.id))";
	/**
	 * The cached OCL invariant for the '{@link #AllSubComponentInstancesAreDeployed(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>All Sub Component Instances Are Deployed</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AllSubComponentInstancesAreDeployed(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean AllSubComponentInstancesAreDeployed(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(StaticstructurePackage.Literals.SERVICE_ARCHITECTURE_MODEL);
			try {
				ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 StaticstructureValidator.DIAGNOSTIC_SOURCE,
						 StaticstructureValidator.SERVICE_ARCHITECTURE_MODEL__ALL_SUB_COMPONENT_INSTANCES_ARE_DEPLOYED,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "AllSubComponentInstancesAreDeployed", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS:
				return ((InternalEList<?>)getSubcomponents()).basicRemove(otherEnd, msgs);
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__CONNECTOR:
				return ((InternalEList<?>)getConnector()).basicRemove(otherEnd, msgs);
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SERVICE:
				return ((InternalEList<?>)getService()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS:
				return getSubcomponents();
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__CONNECTOR:
				return getConnector();
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SERVICE:
				return getService();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS:
				getSubcomponents().clear();
				getSubcomponents().addAll((Collection<? extends SubcomponentInstance>)newValue);
				return;
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__CONNECTOR:
				getConnector().clear();
				getConnector().addAll((Collection<? extends Connector>)newValue);
				return;
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SERVICE:
				getService().clear();
				getService().addAll((Collection<? extends Service>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS:
				getSubcomponents().clear();
				return;
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__CONNECTOR:
				getConnector().clear();
				return;
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SERVICE:
				getService().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS:
				return subcomponents != null && !subcomponents.isEmpty();
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__CONNECTOR:
				return connector != null && !connector.isEmpty();
			case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SERVICE:
				return service != null && !service.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == CompositeStructure.class) {
			switch (derivedFeatureID) {
				case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS: return StaticstructurePackage.COMPOSITE_STRUCTURE__SUBCOMPONENTS;
				case StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__CONNECTOR: return StaticstructurePackage.COMPOSITE_STRUCTURE__CONNECTOR;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == CompositeStructure.class) {
			switch (baseFeatureID) {
				case StaticstructurePackage.COMPOSITE_STRUCTURE__SUBCOMPONENTS: return StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS;
				case StaticstructurePackage.COMPOSITE_STRUCTURE__CONNECTOR: return StaticstructurePackage.SERVICE_ARCHITECTURE_MODEL__CONNECTOR;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * The cached environment for evaluating OCL expressions.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //ServiceArchitectureModelImpl
