/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure.impl;

import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.util.StaticstructureValidator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interface Port</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.InterfacePortImpl#isRequired <em>Is Required</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.InterfacePortImpl#getInterfaceType <em>Interface Type</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.InterfacePortImpl#getRequiringComponentType <em>Requiring Component Type</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.InterfacePortImpl#getProvidingComponentType <em>Providing Component Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class InterfacePortImpl extends PortImpl implements InterfacePort {
	/**
	 * The default value of the '{@link #isRequired() <em>Is Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isRequired()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_REQUIRED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #getInterfaceType() <em>Interface Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInterfaceType()
	 * @generated
	 * @ordered
	 */
	protected Interface interfaceType;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfacePortImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return StaticstructurePackage.Literals.INTERFACE_PORT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public boolean isRequired() {
		// The interface port is a required interface port
		// if the PortEnabledEntity it belongs to references the
		// port with the required reference.
		if (eContainer instanceof PortEnabledEntity) {
			if (((PortEnabledEntity)eContainer).getRequired().contains(this)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *  @generated not
	 */
	public boolean isSetIsRequired() {
		//throw new UnsupportedOperationException();
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Interface getInterfaceType() {
		if (interfaceType != null && interfaceType.eIsProxy()) {
			InternalEObject oldInterfaceType = (InternalEObject)interfaceType;
			interfaceType = (Interface)eResolveProxy(oldInterfaceType);
			if (interfaceType != oldInterfaceType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, StaticstructurePackage.INTERFACE_PORT__INTERFACE_TYPE, oldInterfaceType, interfaceType));
			}
		}
		return interfaceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Interface basicGetInterfaceType() {
		return interfaceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterfaceType(Interface newInterfaceType) {
		Interface oldInterfaceType = interfaceType;
		interfaceType = newInterfaceType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StaticstructurePackage.INTERFACE_PORT__INTERFACE_TYPE, oldInterfaceType, interfaceType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PortEnabledEntity getRequiringComponentType() {
		if (eContainerFeatureID() != StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE) return null;
		return (PortEnabledEntity)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRequiringComponentType(PortEnabledEntity newRequiringComponentType, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newRequiringComponentType, StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRequiringComponentType(PortEnabledEntity newRequiringComponentType) {
		if (newRequiringComponentType != eInternalContainer() || (eContainerFeatureID() != StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE && newRequiringComponentType != null)) {
			if (EcoreUtil.isAncestor(this, newRequiringComponentType))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newRequiringComponentType != null)
				msgs = ((InternalEObject)newRequiringComponentType).eInverseAdd(this, StaticstructurePackage.PORT_ENABLED_ENTITY__REQUIRED, PortEnabledEntity.class, msgs);
			msgs = basicSetRequiringComponentType(newRequiringComponentType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE, newRequiringComponentType, newRequiringComponentType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PortEnabledEntity getProvidingComponentType() {
		if (eContainerFeatureID() != StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE) return null;
		return (PortEnabledEntity)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetProvidingComponentType(PortEnabledEntity newProvidingComponentType, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newProvidingComponentType, StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProvidingComponentType(PortEnabledEntity newProvidingComponentType) {
		if (newProvidingComponentType != eInternalContainer() || (eContainerFeatureID() != StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE && newProvidingComponentType != null)) {
			if (EcoreUtil.isAncestor(this, newProvidingComponentType))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProvidingComponentType != null)
				msgs = ((InternalEObject)newProvidingComponentType).eInverseAdd(this, StaticstructurePackage.PORT_ENABLED_ENTITY__PROVIDED, PortEnabledEntity.class, msgs);
			msgs = basicSetProvidingComponentType(newProvidingComponentType, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE, newProvidingComponentType, newProvidingComponentType));
	}

	/**
	 * The cached OCL expression body for the '{@link #PortMustBeEitherARequiredOrAProvidedPort(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Port Must Be Either ARequired Or AProvided Port</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PortMustBeEitherARequiredOrAProvidedPort(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "(not self.providingComponentType.oclIsUndefined()) xor (not self.requiringComponentType.oclIsUndefined())";

	/**
	 * The cached OCL invariant for the '{@link #PortMustBeEitherARequiredOrAProvidedPort(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Port Must Be Either ARequired Or AProvided Port</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PortMustBeEitherARequiredOrAProvidedPort(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean PortMustBeEitherARequiredOrAProvidedPort(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(StaticstructurePackage.Literals.INTERFACE_PORT);
			try {
				PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 StaticstructureValidator.DIAGNOSTIC_SOURCE,
						 StaticstructureValidator.INTERFACE_PORT__PORT_MUST_BE_EITHER_AREQUIRED_OR_APROVIDED_PORT,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "PortMustBeEitherARequiredOrAProvidedPort", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetRequiringComponentType((PortEnabledEntity)otherEnd, msgs);
			case StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetProvidingComponentType((PortEnabledEntity)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE:
				return basicSetRequiringComponentType(null, msgs);
			case StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE:
				return basicSetProvidingComponentType(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE:
				return eInternalContainer().eInverseRemove(this, StaticstructurePackage.PORT_ENABLED_ENTITY__REQUIRED, PortEnabledEntity.class, msgs);
			case StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE:
				return eInternalContainer().eInverseRemove(this, StaticstructurePackage.PORT_ENABLED_ENTITY__PROVIDED, PortEnabledEntity.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case StaticstructurePackage.INTERFACE_PORT__IS_REQUIRED:
				return isRequired();
			case StaticstructurePackage.INTERFACE_PORT__INTERFACE_TYPE:
				if (resolve) return getInterfaceType();
				return basicGetInterfaceType();
			case StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE:
				return getRequiringComponentType();
			case StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE:
				return getProvidingComponentType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case StaticstructurePackage.INTERFACE_PORT__INTERFACE_TYPE:
				setInterfaceType((Interface)newValue);
				return;
			case StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE:
				setRequiringComponentType((PortEnabledEntity)newValue);
				return;
			case StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE:
				setProvidingComponentType((PortEnabledEntity)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case StaticstructurePackage.INTERFACE_PORT__INTERFACE_TYPE:
				setInterfaceType((Interface)null);
				return;
			case StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE:
				setRequiringComponentType((PortEnabledEntity)null);
				return;
			case StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE:
				setProvidingComponentType((PortEnabledEntity)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case StaticstructurePackage.INTERFACE_PORT__IS_REQUIRED:
				return isSetIsRequired();
			case StaticstructurePackage.INTERFACE_PORT__INTERFACE_TYPE:
				return interfaceType != null;
			case StaticstructurePackage.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE:
				return getRequiringComponentType() != null;
			case StaticstructurePackage.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE:
				return getProvidingComponentType() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * The cached environment for evaluating OCL expressions.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //InterfacePortImpl
