/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure.impl;

import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

import eu.qimpress.samm.core.impl.EntityImpl;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EndPoint;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.util.StaticstructureValidator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Connector</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.ConnectorImpl#isDelegation <em>Is Delegation</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.ConnectorImpl#getEndpoints <em>Endpoints</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConnectorImpl extends EntityImpl implements Connector {
	/**
	 * The default value of the '{@link #isDelegation() <em>Is Delegation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDelegation()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_DELEGATION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #getEndpoints() <em>Endpoints</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndpoints()
	 * @generated
	 * @ordered
	 */
	protected EList<EndPoint> endpoints;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return StaticstructurePackage.Literals.CONNECTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public boolean isDelegation() {
		// Check if one of the referenced endpoints
		// is a ComponentEndpoint. In this case,
		// the connector is a delegation connector.
		for (EndPoint e : this.endpoints) {
			if (e instanceof ComponentEndpoint) {
				return true;
			}
			
		}
		return false;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public boolean isSetIsDelegation() {
		//throw new UnsupportedOperationException();
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EndPoint> getEndpoints() {
		if (endpoints == null) {
			endpoints = new EObjectContainmentEList<EndPoint>(EndPoint.class, this, StaticstructurePackage.CONNECTOR__ENDPOINTS);
		}
		return endpoints;
	}

	/**
	 * The cached OCL expression body for the '{@link #oneLevelConnectors(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>One Level Connectors</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #oneLevelConnectors(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String ONE_LEVEL_CONNECTORS__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "true\n"+"--if (self.isDelegation=true) then\n"+"-- self.endpoints->forAll(sce | sce.oclAsType(SubcomponentEndpoint).subcomponent.parent.id = self.oclAsType(SubcomponentEndpoint).subcomponent.parent.id))\n"+"-- else \n"+"--	 (self.endpoints->forAll(sce | sce.oclAsType(SubcomponentEndpoint).subcomponent.id = self.oclAsType(SubcomponentEndpoint).subcomponent.id))\n"+"--endif";

	/**
	 * The cached OCL invariant for the '{@link #oneLevelConnectors(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>One Level Connectors</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #oneLevelConnectors(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint ONE_LEVEL_CONNECTORS__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean oneLevelConnectors(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (ONE_LEVEL_CONNECTORS__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(StaticstructurePackage.Literals.CONNECTOR);
			try {
				ONE_LEVEL_CONNECTORS__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(ONE_LEVEL_CONNECTORS__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(ONE_LEVEL_CONNECTORS__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 StaticstructureValidator.DIAGNOSTIC_SOURCE,
						 StaticstructureValidator.CONNECTOR__ONE_LEVEL_CONNECTORS,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "oneLevelConnectors", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StaticstructurePackage.CONNECTOR__ENDPOINTS:
				return ((InternalEList<?>)getEndpoints()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case StaticstructurePackage.CONNECTOR__IS_DELEGATION:
				return isDelegation();
			case StaticstructurePackage.CONNECTOR__ENDPOINTS:
				return getEndpoints();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case StaticstructurePackage.CONNECTOR__ENDPOINTS:
				getEndpoints().clear();
				getEndpoints().addAll((Collection<? extends EndPoint>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case StaticstructurePackage.CONNECTOR__ENDPOINTS:
				getEndpoints().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case StaticstructurePackage.CONNECTOR__IS_DELEGATION:
				return isSetIsDelegation();
			case StaticstructurePackage.CONNECTOR__ENDPOINTS:
				return endpoints != null && !endpoints.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * The cached environment for evaluating OCL expressions.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //ConnectorImpl
