/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure.impl;

import eu.qimpress.identifier.Identifier;
import eu.qimpress.identifier.IdentifierPackage;
import eu.qimpress.identifier.util.IdentifierValidator;
import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

import eu.qimpress.samm.behaviour.ComponentTypeBehaviour;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.samm.core.CorePackage;
import eu.qimpress.samm.core.Entity;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.core.impl.NamedEntityImpl;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.EventPort;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.util.StaticstructureValidator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Component Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.ComponentTypeImpl#getOperationBehaviour <em>Operation Behaviour</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.impl.ComponentTypeImpl#getComponentTypeBehaviour <em>Component Type Behaviour</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class ComponentTypeImpl extends PortEnabledEntityImpl implements ComponentType {
	/**
	 * The cached value of the '{@link #getOperationBehaviour() <em>Operation Behaviour</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperationBehaviour()
	 * @generated
	 * @ordered
	 */
	protected EList<OperationBehaviour> operationBehaviour;

	/**
	 * The cached value of the '{@link #getComponentTypeBehaviour() <em>Component Type Behaviour</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComponentTypeBehaviour()
	 * @generated
	 * @ordered
	 */
	protected ComponentTypeBehaviour componentTypeBehaviour;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return StaticstructurePackage.Literals.COMPONENT_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<OperationBehaviour> getOperationBehaviour() {
		if (operationBehaviour == null) {
			operationBehaviour = new EObjectContainmentEList<OperationBehaviour>(OperationBehaviour.class, this, StaticstructurePackage.COMPONENT_TYPE__OPERATION_BEHAVIOUR);
		}
		return operationBehaviour;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentTypeBehaviour getComponentTypeBehaviour() {
		return componentTypeBehaviour;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetComponentTypeBehaviour(ComponentTypeBehaviour newComponentTypeBehaviour, NotificationChain msgs) {
		ComponentTypeBehaviour oldComponentTypeBehaviour = componentTypeBehaviour;
		componentTypeBehaviour = newComponentTypeBehaviour;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR, oldComponentTypeBehaviour, newComponentTypeBehaviour);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setComponentTypeBehaviour(ComponentTypeBehaviour newComponentTypeBehaviour) {
		if (newComponentTypeBehaviour != componentTypeBehaviour) {
			NotificationChain msgs = null;
			if (componentTypeBehaviour != null)
				msgs = ((InternalEObject)componentTypeBehaviour).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR, null, msgs);
			if (newComponentTypeBehaviour != null)
				msgs = ((InternalEObject)newComponentTypeBehaviour).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR, null, msgs);
			msgs = basicSetComponentTypeBehaviour(newComponentTypeBehaviour, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR, newComponentTypeBehaviour, newComponentTypeBehaviour));
	}

	/**
	 * The cached OCL expression body for the '{@link #HasToProvideOrRequireServices(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Has To Provide Or Require Services</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HasToProvideOrRequireServices(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String HAS_TO_PROVIDE_OR_REQUIRE_SERVICES__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "provided->size() + required->size() >= 1  ";

	/**
	 * The cached OCL invariant for the '{@link #HasToProvideOrRequireServices(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>Has To Provide Or Require Services</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HasToProvideOrRequireServices(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint HAS_TO_PROVIDE_OR_REQUIRE_SERVICES__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean HasToProvideOrRequireServices(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (HAS_TO_PROVIDE_OR_REQUIRE_SERVICES__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(StaticstructurePackage.Literals.COMPONENT_TYPE);
			try {
				HAS_TO_PROVIDE_OR_REQUIRE_SERVICES__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(HAS_TO_PROVIDE_OR_REQUIRE_SERVICES__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(HAS_TO_PROVIDE_OR_REQUIRE_SERVICES__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 StaticstructureValidator.DIAGNOSTIC_SOURCE,
						 StaticstructureValidator.COMPONENT_TYPE__HAS_TO_PROVIDE_OR_REQUIRE_SERVICES,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "HasToProvideOrRequireServices", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}


	/**
	 * The cached OCL expression body for the '{@link #NoInterfacePortAssociatedTwice(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>No Interface Port Associated Twice</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NoInterfacePortAssociatedTwice(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String NO_INTERFACE_PORT_ASSOCIATED_TWICE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "-- Make sure no InterfacePort is both a required and a provided port. Note that an interface can be both provided and required, but via different ports.\n"+"self.required->intersection(self.provided)->isEmpty()";

	/**
	 * The cached OCL invariant for the '{@link #NoInterfacePortAssociatedTwice(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>No Interface Port Associated Twice</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NoInterfacePortAssociatedTwice(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint NO_INTERFACE_PORT_ASSOCIATED_TWICE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean NoInterfacePortAssociatedTwice(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (NO_INTERFACE_PORT_ASSOCIATED_TWICE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(StaticstructurePackage.Literals.COMPONENT_TYPE);
			try {
				NO_INTERFACE_PORT_ASSOCIATED_TWICE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(NO_INTERFACE_PORT_ASSOCIATED_TWICE__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(NO_INTERFACE_PORT_ASSOCIATED_TWICE__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 StaticstructureValidator.DIAGNOSTIC_SOURCE,
						 StaticstructureValidator.COMPONENT_TYPE__NO_INTERFACE_PORT_ASSOCIATED_TWICE,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "NoInterfacePortAssociatedTwice", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case StaticstructurePackage.COMPONENT_TYPE__OPERATION_BEHAVIOUR:
				return ((InternalEList<?>)getOperationBehaviour()).basicRemove(otherEnd, msgs);
			case StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR:
				return basicSetComponentTypeBehaviour(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case StaticstructurePackage.COMPONENT_TYPE__OPERATION_BEHAVIOUR:
				return getOperationBehaviour();
			case StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR:
				return getComponentTypeBehaviour();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case StaticstructurePackage.COMPONENT_TYPE__OPERATION_BEHAVIOUR:
				getOperationBehaviour().clear();
				getOperationBehaviour().addAll((Collection<? extends OperationBehaviour>)newValue);
				return;
			case StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR:
				setComponentTypeBehaviour((ComponentTypeBehaviour)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case StaticstructurePackage.COMPONENT_TYPE__OPERATION_BEHAVIOUR:
				getOperationBehaviour().clear();
				return;
			case StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR:
				setComponentTypeBehaviour((ComponentTypeBehaviour)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case StaticstructurePackage.COMPONENT_TYPE__OPERATION_BEHAVIOUR:
				return operationBehaviour != null && !operationBehaviour.isEmpty();
			case StaticstructurePackage.COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR:
				return componentTypeBehaviour != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * The cached environment for evaluating OCL expressions.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //ComponentTypeImpl
