/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Subcomponent Instance</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This entity specifies a subcomponent of a composite structure. Note that this is not a run-time instance of a component, it is an instance in the architectural point of view, i.e., an instance of a component type inside of a composite structure.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.SubcomponentInstance#getRealizedBy <em>Realized By</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getSubcomponentInstance()
 * @model
 * @generated
 */
public interface SubcomponentInstance extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Realized By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property specifies the component type of this subcomponent instance.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Realized By</em>' reference.
	 * @see #setRealizedBy(ComponentType)
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getSubcomponentInstance_RealizedBy()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	ComponentType getRealizedBy();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.staticstructure.SubcomponentInstance#getRealizedBy <em>Realized By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Realized By</em>' reference.
	 * @see #getRealizedBy()
	 * @generated
	 */
	void setRealizedBy(ComponentType value);

} // SubcomponentInstance
