/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import eu.qimpress.samm.core.CorePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The staticstructure package aims at modelling of the static service architecture, i.e., types and relations among services, interfaces, and communication links.
 * <!-- end-model-doc -->
 * @see eu.qimpress.samm.staticstructure.StaticstructureFactory
 * @model kind="package"
 * @generated
 */
public interface StaticstructurePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "staticstructure";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://q-impress.eu/samm/staticstructure";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "staticstructure";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	StaticstructurePackage eINSTANCE = eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl.init();

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.PassiveResourceImpl <em>Passive Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.PassiveResourceImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getPassiveResource()
	 * @generated
	 */
	int PASSIVE_RESOURCE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASSIVE_RESOURCE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASSIVE_RESOURCE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASSIVE_RESOURCE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Capacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASSIVE_RESOURCE__CAPACITY = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Passive Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PASSIVE_RESOURCE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.CompositeStructureImpl <em>Composite Structure</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.CompositeStructureImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getCompositeStructure()
	 * @generated
	 */
	int COMPOSITE_STRUCTURE = 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.ServiceArchitectureModelImpl <em>Service Architecture Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.ServiceArchitectureModelImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getServiceArchitectureModel()
	 * @generated
	 */
	int SERVICE_ARCHITECTURE_MODEL = 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.SubcomponentInstanceImpl <em>Subcomponent Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.SubcomponentInstanceImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getSubcomponentInstance()
	 * @generated
	 */
	int SUBCOMPONENT_INSTANCE = 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.PortEnabledEntityImpl <em>Port Enabled Entity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.PortEnabledEntityImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getPortEnabledEntity()
	 * @generated
	 */
	int PORT_ENABLED_ENTITY = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_ENABLED_ENTITY__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_ENABLED_ENTITY__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_ENABLED_ENTITY__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Provided</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_ENABLED_ENTITY__PROVIDED = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Required</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_ENABLED_ENTITY__REQUIRED = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_ENABLED_ENTITY__SOURCE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Sink</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_ENABLED_ENTITY__SINK = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Port Enabled Entity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_ENABLED_ENTITY_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__ID = PORT_ENABLED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__DOCUMENTATION = PORT_ENABLED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__NAME = PORT_ENABLED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Provided</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__PROVIDED = PORT_ENABLED_ENTITY__PROVIDED;

	/**
	 * The feature id for the '<em><b>Required</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__REQUIRED = PORT_ENABLED_ENTITY__REQUIRED;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__SOURCE = PORT_ENABLED_ENTITY__SOURCE;

	/**
	 * The feature id for the '<em><b>Sink</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__SINK = PORT_ENABLED_ENTITY__SINK;

	/**
	 * The feature id for the '<em><b>Subcomponents</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__SUBCOMPONENTS = PORT_ENABLED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connector</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__CONNECTOR = PORT_ENABLED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Service</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL__SERVICE = PORT_ENABLED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Service Architecture Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_ARCHITECTURE_MODEL_FEATURE_COUNT = PORT_ENABLED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Subcomponents</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE__SUBCOMPONENTS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connector</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE__CONNECTOR = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Composite Structure</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_INSTANCE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_INSTANCE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_INSTANCE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Realized By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_INSTANCE__REALIZED_BY = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Subcomponent Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_INSTANCE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.ComponentTypeImpl <em>Component Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.ComponentTypeImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getComponentType()
	 * @generated
	 */
	int COMPONENT_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__ID = PORT_ENABLED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__DOCUMENTATION = PORT_ENABLED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__NAME = PORT_ENABLED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Provided</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__PROVIDED = PORT_ENABLED_ENTITY__PROVIDED;

	/**
	 * The feature id for the '<em><b>Required</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__REQUIRED = PORT_ENABLED_ENTITY__REQUIRED;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__SOURCE = PORT_ENABLED_ENTITY__SOURCE;

	/**
	 * The feature id for the '<em><b>Sink</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__SINK = PORT_ENABLED_ENTITY__SINK;

	/**
	 * The feature id for the '<em><b>Operation Behaviour</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__OPERATION_BEHAVIOUR = PORT_ENABLED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Component Type Behaviour</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR = PORT_ENABLED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Component Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE_FEATURE_COUNT = PORT_ENABLED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.PortImpl <em>Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.PortImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getPort()
	 * @generated
	 */
	int PORT = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The number of structural features of the '<em>Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PORT_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.InterfacePortImpl <em>Interface Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.InterfacePortImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getInterfacePort()
	 * @generated
	 */
	int INTERFACE_PORT = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__ID = PORT__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__DOCUMENTATION = PORT__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__NAME = PORT__NAME;

	/**
	 * The feature id for the '<em><b>Is Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__IS_REQUIRED = PORT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interface Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__INTERFACE_TYPE = PORT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Requiring Component Type</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__REQUIRING_COMPONENT_TYPE = PORT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Providing Component Type</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT__PROVIDING_COMPONENT_TYPE = PORT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Interface Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PORT_FEATURE_COUNT = PORT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.InterfaceImpl <em>Interface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.InterfaceImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getInterface()
	 * @generated
	 */
	int INTERFACE = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Signatures</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE__SIGNATURES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Inheritance</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE__INHERITANCE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERFACE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.OperationImpl <em>Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.OperationImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getOperation()
	 * @generated
	 */
	int OPERATION = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Input</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__INPUT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Output</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__OUTPUT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Throws Exceptions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__THROWS_EXCEPTIONS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.MessageTypeImpl <em>Message Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.MessageTypeImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getMessageType()
	 * @generated
	 */
	int MESSAGE_TYPE = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_TYPE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_TYPE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_TYPE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_TYPE__PARAMETERS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Message Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_TYPE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.ParameterImpl <em>Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.ParameterImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getParameter()
	 * @generated
	 */
	int PARAMETER = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__TYPE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.OperationExceptionImpl <em>Operation Exception</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.OperationExceptionImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getOperationException()
	 * @generated
	 */
	int OPERATION_EXCEPTION = 12;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_EXCEPTION__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_EXCEPTION__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_EXCEPTION__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Exception Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_EXCEPTION__EXCEPTION_MESSAGE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Operation Exception</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_EXCEPTION_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.EventPortImpl <em>Event Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.EventPortImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getEventPort()
	 * @generated
	 */
	int EVENT_PORT = 13;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_PORT__ID = PORT__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_PORT__DOCUMENTATION = PORT__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_PORT__NAME = PORT__NAME;

	/**
	 * The feature id for the '<em><b>Is Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_PORT__IS_SOURCE = PORT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_PORT__MESSAGE = PORT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_PORT_FEATURE_COUNT = PORT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.ConnectorImpl <em>Connector</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.ConnectorImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getConnector()
	 * @generated
	 */
	int CONNECTOR = 14;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__ID = CorePackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__DOCUMENTATION = CorePackage.ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Is Delegation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__IS_DELEGATION = CorePackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Endpoints</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR__ENDPOINTS = CorePackage.ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Connector</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_FEATURE_COUNT = CorePackage.ENTITY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.EndPointImpl <em>End Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.EndPointImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getEndPoint()
	 * @generated
	 */
	int END_POINT = 15;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END_POINT__ID = CorePackage.ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END_POINT__DOCUMENTATION = CorePackage.ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END_POINT__PORT = CorePackage.ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>End Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int END_POINT_FEATURE_COUNT = CorePackage.ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.SubcomponentEndpointImpl <em>Subcomponent Endpoint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.SubcomponentEndpointImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getSubcomponentEndpoint()
	 * @generated
	 */
	int SUBCOMPONENT_ENDPOINT = 16;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_ENDPOINT__ID = END_POINT__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_ENDPOINT__DOCUMENTATION = END_POINT__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_ENDPOINT__PORT = END_POINT__PORT;

	/**
	 * The feature id for the '<em><b>Subcomponent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_ENDPOINT__SUBCOMPONENT = END_POINT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Subcomponent Endpoint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SUBCOMPONENT_ENDPOINT_FEATURE_COUNT = END_POINT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.RepositoryImpl <em>Repository</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.RepositoryImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getRepository()
	 * @generated
	 */
	int REPOSITORY = 17;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPOSITORY__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPOSITORY__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPOSITORY__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Componenttype</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPOSITORY__COMPONENTTYPE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPOSITORY__INTERFACE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Type</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPOSITORY__TYPE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Messagetype</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPOSITORY__MESSAGETYPE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Repository</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REPOSITORY_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.ComponentEndpointImpl <em>Component Endpoint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.ComponentEndpointImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getComponentEndpoint()
	 * @generated
	 */
	int COMPONENT_ENDPOINT = 18;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ENDPOINT__ID = END_POINT__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ENDPOINT__DOCUMENTATION = END_POINT__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ENDPOINT__PORT = END_POINT__PORT;

	/**
	 * The number of structural features of the '<em>Component Endpoint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_ENDPOINT_FEATURE_COUNT = END_POINT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.CompositeComponentImpl <em>Composite Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.CompositeComponentImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getCompositeComponent()
	 * @generated
	 */
	int COMPOSITE_COMPONENT = 19;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__ID = COMPONENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__DOCUMENTATION = COMPONENT_TYPE__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__NAME = COMPONENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Provided</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__PROVIDED = COMPONENT_TYPE__PROVIDED;

	/**
	 * The feature id for the '<em><b>Required</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__REQUIRED = COMPONENT_TYPE__REQUIRED;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__SOURCE = COMPONENT_TYPE__SOURCE;

	/**
	 * The feature id for the '<em><b>Sink</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__SINK = COMPONENT_TYPE__SINK;

	/**
	 * The feature id for the '<em><b>Operation Behaviour</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__OPERATION_BEHAVIOUR = COMPONENT_TYPE__OPERATION_BEHAVIOUR;

	/**
	 * The feature id for the '<em><b>Component Type Behaviour</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__COMPONENT_TYPE_BEHAVIOUR = COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR;

	/**
	 * The feature id for the '<em><b>Subcomponents</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__SUBCOMPONENTS = COMPONENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connector</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT__CONNECTOR = COMPONENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Composite Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_COMPONENT_FEATURE_COUNT = COMPONENT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.staticstructure.impl.PrimitiveComponentImpl <em>Primitive Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.staticstructure.impl.PrimitiveComponentImpl
	 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getPrimitiveComponent()
	 * @generated
	 */
	int PRIMITIVE_COMPONENT = 20;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__ID = COMPONENT_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__DOCUMENTATION = COMPONENT_TYPE__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__NAME = COMPONENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Provided</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__PROVIDED = COMPONENT_TYPE__PROVIDED;

	/**
	 * The feature id for the '<em><b>Required</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__REQUIRED = COMPONENT_TYPE__REQUIRED;

	/**
	 * The feature id for the '<em><b>Source</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__SOURCE = COMPONENT_TYPE__SOURCE;

	/**
	 * The feature id for the '<em><b>Sink</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__SINK = COMPONENT_TYPE__SINK;

	/**
	 * The feature id for the '<em><b>Operation Behaviour</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__OPERATION_BEHAVIOUR = COMPONENT_TYPE__OPERATION_BEHAVIOUR;

	/**
	 * The feature id for the '<em><b>Component Type Behaviour</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__COMPONENT_TYPE_BEHAVIOUR = COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR;

	/**
	 * The feature id for the '<em><b>Passive Resources</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT__PASSIVE_RESOURCES = COMPONENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Primitive Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_COMPONENT_FEATURE_COUNT = COMPONENT_TYPE_FEATURE_COUNT + 1;


	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.PassiveResource <em>Passive Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Passive Resource</em>'.
	 * @see eu.qimpress.samm.staticstructure.PassiveResource
	 * @generated
	 */
	EClass getPassiveResource();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.staticstructure.PassiveResource#getCapacity <em>Capacity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Capacity</em>'.
	 * @see eu.qimpress.samm.staticstructure.PassiveResource#getCapacity()
	 * @see #getPassiveResource()
	 * @generated
	 */
	EAttribute getPassiveResource_Capacity();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.ServiceArchitectureModel <em>Service Architecture Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Architecture Model</em>'.
	 * @see eu.qimpress.samm.staticstructure.ServiceArchitectureModel
	 * @generated
	 */
	EClass getServiceArchitectureModel();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.ServiceArchitectureModel#getService <em>Service</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Service</em>'.
	 * @see eu.qimpress.samm.staticstructure.ServiceArchitectureModel#getService()
	 * @see #getServiceArchitectureModel()
	 * @generated
	 */
	EReference getServiceArchitectureModel_Service();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.CompositeStructure <em>Composite Structure</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Composite Structure</em>'.
	 * @see eu.qimpress.samm.staticstructure.CompositeStructure
	 * @generated
	 */
	EClass getCompositeStructure();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.CompositeStructure#getSubcomponents <em>Subcomponents</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Subcomponents</em>'.
	 * @see eu.qimpress.samm.staticstructure.CompositeStructure#getSubcomponents()
	 * @see #getCompositeStructure()
	 * @generated
	 */
	EReference getCompositeStructure_Subcomponents();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.CompositeStructure#getConnector <em>Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Connector</em>'.
	 * @see eu.qimpress.samm.staticstructure.CompositeStructure#getConnector()
	 * @see #getCompositeStructure()
	 * @generated
	 */
	EReference getCompositeStructure_Connector();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.SubcomponentInstance <em>Subcomponent Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Subcomponent Instance</em>'.
	 * @see eu.qimpress.samm.staticstructure.SubcomponentInstance
	 * @generated
	 */
	EClass getSubcomponentInstance();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.staticstructure.SubcomponentInstance#getRealizedBy <em>Realized By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Realized By</em>'.
	 * @see eu.qimpress.samm.staticstructure.SubcomponentInstance#getRealizedBy()
	 * @see #getSubcomponentInstance()
	 * @generated
	 */
	EReference getSubcomponentInstance_RealizedBy();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.ComponentType <em>Component Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Type</em>'.
	 * @see eu.qimpress.samm.staticstructure.ComponentType
	 * @generated
	 */
	EClass getComponentType();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.ComponentType#getOperationBehaviour <em>Operation Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operation Behaviour</em>'.
	 * @see eu.qimpress.samm.staticstructure.ComponentType#getOperationBehaviour()
	 * @see #getComponentType()
	 * @generated
	 */
	EReference getComponentType_OperationBehaviour();

	/**
	 * Returns the meta object for the containment reference '{@link eu.qimpress.samm.staticstructure.ComponentType#getComponentTypeBehaviour <em>Component Type Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Component Type Behaviour</em>'.
	 * @see eu.qimpress.samm.staticstructure.ComponentType#getComponentTypeBehaviour()
	 * @see #getComponentType()
	 * @generated
	 */
	EReference getComponentType_ComponentTypeBehaviour();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.PortEnabledEntity <em>Port Enabled Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Port Enabled Entity</em>'.
	 * @see eu.qimpress.samm.staticstructure.PortEnabledEntity
	 * @generated
	 */
	EClass getPortEnabledEntity();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.PortEnabledEntity#getProvided <em>Provided</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Provided</em>'.
	 * @see eu.qimpress.samm.staticstructure.PortEnabledEntity#getProvided()
	 * @see #getPortEnabledEntity()
	 * @generated
	 */
	EReference getPortEnabledEntity_Provided();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.PortEnabledEntity#getRequired <em>Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Required</em>'.
	 * @see eu.qimpress.samm.staticstructure.PortEnabledEntity#getRequired()
	 * @see #getPortEnabledEntity()
	 * @generated
	 */
	EReference getPortEnabledEntity_Required();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.PortEnabledEntity#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Source</em>'.
	 * @see eu.qimpress.samm.staticstructure.PortEnabledEntity#getSource()
	 * @see #getPortEnabledEntity()
	 * @generated
	 */
	EReference getPortEnabledEntity_Source();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.PortEnabledEntity#getSink <em>Sink</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Sink</em>'.
	 * @see eu.qimpress.samm.staticstructure.PortEnabledEntity#getSink()
	 * @see #getPortEnabledEntity()
	 * @generated
	 */
	EReference getPortEnabledEntity_Sink();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.InterfacePort <em>Interface Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Interface Port</em>'.
	 * @see eu.qimpress.samm.staticstructure.InterfacePort
	 * @generated
	 */
	EClass getInterfacePort();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.staticstructure.InterfacePort#isRequired <em>Is Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Required</em>'.
	 * @see eu.qimpress.samm.staticstructure.InterfacePort#isRequired()
	 * @see #getInterfacePort()
	 * @generated
	 */
	EAttribute getInterfacePort_IsRequired();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.staticstructure.InterfacePort#getInterfaceType <em>Interface Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Interface Type</em>'.
	 * @see eu.qimpress.samm.staticstructure.InterfacePort#getInterfaceType()
	 * @see #getInterfacePort()
	 * @generated
	 */
	EReference getInterfacePort_InterfaceType();

	/**
	 * Returns the meta object for the container reference '{@link eu.qimpress.samm.staticstructure.InterfacePort#getRequiringComponentType <em>Requiring Component Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Requiring Component Type</em>'.
	 * @see eu.qimpress.samm.staticstructure.InterfacePort#getRequiringComponentType()
	 * @see #getInterfacePort()
	 * @generated
	 */
	EReference getInterfacePort_RequiringComponentType();

	/**
	 * Returns the meta object for the container reference '{@link eu.qimpress.samm.staticstructure.InterfacePort#getProvidingComponentType <em>Providing Component Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Providing Component Type</em>'.
	 * @see eu.qimpress.samm.staticstructure.InterfacePort#getProvidingComponentType()
	 * @see #getInterfacePort()
	 * @generated
	 */
	EReference getInterfacePort_ProvidingComponentType();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.Port <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Port</em>'.
	 * @see eu.qimpress.samm.staticstructure.Port
	 * @generated
	 */
	EClass getPort();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.Interface <em>Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Interface</em>'.
	 * @see eu.qimpress.samm.staticstructure.Interface
	 * @generated
	 */
	EClass getInterface();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.Interface#getSignatures <em>Signatures</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Signatures</em>'.
	 * @see eu.qimpress.samm.staticstructure.Interface#getSignatures()
	 * @see #getInterface()
	 * @generated
	 */
	EReference getInterface_Signatures();

	/**
	 * Returns the meta object for the reference list '{@link eu.qimpress.samm.staticstructure.Interface#getInheritance <em>Inheritance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Inheritance</em>'.
	 * @see eu.qimpress.samm.staticstructure.Interface#getInheritance()
	 * @see #getInterface()
	 * @generated
	 */
	EReference getInterface_Inheritance();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.Operation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operation</em>'.
	 * @see eu.qimpress.samm.staticstructure.Operation
	 * @generated
	 */
	EClass getOperation();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.staticstructure.Operation#getInput <em>Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Input</em>'.
	 * @see eu.qimpress.samm.staticstructure.Operation#getInput()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Input();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.staticstructure.Operation#getOutput <em>Output</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Output</em>'.
	 * @see eu.qimpress.samm.staticstructure.Operation#getOutput()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_Output();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.Operation#getThrowsExceptions <em>Throws Exceptions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Throws Exceptions</em>'.
	 * @see eu.qimpress.samm.staticstructure.Operation#getThrowsExceptions()
	 * @see #getOperation()
	 * @generated
	 */
	EReference getOperation_ThrowsExceptions();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.MessageType <em>Message Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Message Type</em>'.
	 * @see eu.qimpress.samm.staticstructure.MessageType
	 * @generated
	 */
	EClass getMessageType();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.MessageType#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Parameters</em>'.
	 * @see eu.qimpress.samm.staticstructure.MessageType#getParameters()
	 * @see #getMessageType()
	 * @generated
	 */
	EReference getMessageType_Parameters();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.Parameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter</em>'.
	 * @see eu.qimpress.samm.staticstructure.Parameter
	 * @generated
	 */
	EClass getParameter();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.staticstructure.Parameter#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see eu.qimpress.samm.staticstructure.Parameter#getType()
	 * @see #getParameter()
	 * @generated
	 */
	EReference getParameter_Type();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.OperationException <em>Operation Exception</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operation Exception</em>'.
	 * @see eu.qimpress.samm.staticstructure.OperationException
	 * @generated
	 */
	EClass getOperationException();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.staticstructure.OperationException#getExceptionMessage <em>Exception Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Exception Message</em>'.
	 * @see eu.qimpress.samm.staticstructure.OperationException#getExceptionMessage()
	 * @see #getOperationException()
	 * @generated
	 */
	EAttribute getOperationException_ExceptionMessage();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.EventPort <em>Event Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Port</em>'.
	 * @see eu.qimpress.samm.staticstructure.EventPort
	 * @generated
	 */
	EClass getEventPort();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.staticstructure.EventPort#isSource <em>Is Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Source</em>'.
	 * @see eu.qimpress.samm.staticstructure.EventPort#isSource()
	 * @see #getEventPort()
	 * @generated
	 */
	EAttribute getEventPort_IsSource();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.staticstructure.EventPort#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Message</em>'.
	 * @see eu.qimpress.samm.staticstructure.EventPort#getMessage()
	 * @see #getEventPort()
	 * @generated
	 */
	EReference getEventPort_Message();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.Connector <em>Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Connector</em>'.
	 * @see eu.qimpress.samm.staticstructure.Connector
	 * @generated
	 */
	EClass getConnector();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.staticstructure.Connector#isDelegation <em>Is Delegation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Delegation</em>'.
	 * @see eu.qimpress.samm.staticstructure.Connector#isDelegation()
	 * @see #getConnector()
	 * @generated
	 */
	EAttribute getConnector_IsDelegation();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.Connector#getEndpoints <em>Endpoints</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Endpoints</em>'.
	 * @see eu.qimpress.samm.staticstructure.Connector#getEndpoints()
	 * @see #getConnector()
	 * @generated
	 */
	EReference getConnector_Endpoints();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.EndPoint <em>End Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>End Point</em>'.
	 * @see eu.qimpress.samm.staticstructure.EndPoint
	 * @generated
	 */
	EClass getEndPoint();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.staticstructure.EndPoint#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Port</em>'.
	 * @see eu.qimpress.samm.staticstructure.EndPoint#getPort()
	 * @see #getEndPoint()
	 * @generated
	 */
	EReference getEndPoint_Port();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.SubcomponentEndpoint <em>Subcomponent Endpoint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Subcomponent Endpoint</em>'.
	 * @see eu.qimpress.samm.staticstructure.SubcomponentEndpoint
	 * @generated
	 */
	EClass getSubcomponentEndpoint();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.staticstructure.SubcomponentEndpoint#getSubcomponent <em>Subcomponent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Subcomponent</em>'.
	 * @see eu.qimpress.samm.staticstructure.SubcomponentEndpoint#getSubcomponent()
	 * @see #getSubcomponentEndpoint()
	 * @generated
	 */
	EReference getSubcomponentEndpoint_Subcomponent();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.Repository <em>Repository</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Repository</em>'.
	 * @see eu.qimpress.samm.staticstructure.Repository
	 * @generated
	 */
	EClass getRepository();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.Repository#getComponenttype <em>Componenttype</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Componenttype</em>'.
	 * @see eu.qimpress.samm.staticstructure.Repository#getComponenttype()
	 * @see #getRepository()
	 * @generated
	 */
	EReference getRepository_Componenttype();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.Repository#getInterface <em>Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Interface</em>'.
	 * @see eu.qimpress.samm.staticstructure.Repository#getInterface()
	 * @see #getRepository()
	 * @generated
	 */
	EReference getRepository_Interface();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.Repository#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Type</em>'.
	 * @see eu.qimpress.samm.staticstructure.Repository#getType()
	 * @see #getRepository()
	 * @generated
	 */
	EReference getRepository_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.Repository#getMessagetype <em>Messagetype</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Messagetype</em>'.
	 * @see eu.qimpress.samm.staticstructure.Repository#getMessagetype()
	 * @see #getRepository()
	 * @generated
	 */
	EReference getRepository_Messagetype();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.ComponentEndpoint <em>Component Endpoint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Endpoint</em>'.
	 * @see eu.qimpress.samm.staticstructure.ComponentEndpoint
	 * @generated
	 */
	EClass getComponentEndpoint();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.CompositeComponent <em>Composite Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Composite Component</em>'.
	 * @see eu.qimpress.samm.staticstructure.CompositeComponent
	 * @generated
	 */
	EClass getCompositeComponent();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.staticstructure.PrimitiveComponent <em>Primitive Component</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Primitive Component</em>'.
	 * @see eu.qimpress.samm.staticstructure.PrimitiveComponent
	 * @generated
	 */
	EClass getPrimitiveComponent();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.staticstructure.PrimitiveComponent#getPassiveResources <em>Passive Resources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Passive Resources</em>'.
	 * @see eu.qimpress.samm.staticstructure.PrimitiveComponent#getPassiveResources()
	 * @see #getPrimitiveComponent()
	 * @generated
	 */
	EReference getPrimitiveComponent_PassiveResources();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	StaticstructureFactory getStaticstructureFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.PassiveResourceImpl <em>Passive Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.PassiveResourceImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getPassiveResource()
		 * @generated
		 */
		EClass PASSIVE_RESOURCE = eINSTANCE.getPassiveResource();

		/**
		 * The meta object literal for the '<em><b>Capacity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PASSIVE_RESOURCE__CAPACITY = eINSTANCE.getPassiveResource_Capacity();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.ServiceArchitectureModelImpl <em>Service Architecture Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.ServiceArchitectureModelImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getServiceArchitectureModel()
		 * @generated
		 */
		EClass SERVICE_ARCHITECTURE_MODEL = eINSTANCE.getServiceArchitectureModel();

		/**
		 * The meta object literal for the '<em><b>Service</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SERVICE_ARCHITECTURE_MODEL__SERVICE = eINSTANCE.getServiceArchitectureModel_Service();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.CompositeStructureImpl <em>Composite Structure</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.CompositeStructureImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getCompositeStructure()
		 * @generated
		 */
		EClass COMPOSITE_STRUCTURE = eINSTANCE.getCompositeStructure();

		/**
		 * The meta object literal for the '<em><b>Subcomponents</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPOSITE_STRUCTURE__SUBCOMPONENTS = eINSTANCE.getCompositeStructure_Subcomponents();

		/**
		 * The meta object literal for the '<em><b>Connector</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPOSITE_STRUCTURE__CONNECTOR = eINSTANCE.getCompositeStructure_Connector();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.SubcomponentInstanceImpl <em>Subcomponent Instance</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.SubcomponentInstanceImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getSubcomponentInstance()
		 * @generated
		 */
		EClass SUBCOMPONENT_INSTANCE = eINSTANCE.getSubcomponentInstance();

		/**
		 * The meta object literal for the '<em><b>Realized By</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SUBCOMPONENT_INSTANCE__REALIZED_BY = eINSTANCE.getSubcomponentInstance_RealizedBy();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.ComponentTypeImpl <em>Component Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.ComponentTypeImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getComponentType()
		 * @generated
		 */
		EClass COMPONENT_TYPE = eINSTANCE.getComponentType();

		/**
		 * The meta object literal for the '<em><b>Operation Behaviour</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_TYPE__OPERATION_BEHAVIOUR = eINSTANCE.getComponentType_OperationBehaviour();

		/**
		 * The meta object literal for the '<em><b>Component Type Behaviour</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COMPONENT_TYPE__COMPONENT_TYPE_BEHAVIOUR = eINSTANCE.getComponentType_ComponentTypeBehaviour();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.PortEnabledEntityImpl <em>Port Enabled Entity</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.PortEnabledEntityImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getPortEnabledEntity()
		 * @generated
		 */
		EClass PORT_ENABLED_ENTITY = eINSTANCE.getPortEnabledEntity();

		/**
		 * The meta object literal for the '<em><b>Provided</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PORT_ENABLED_ENTITY__PROVIDED = eINSTANCE.getPortEnabledEntity_Provided();

		/**
		 * The meta object literal for the '<em><b>Required</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PORT_ENABLED_ENTITY__REQUIRED = eINSTANCE.getPortEnabledEntity_Required();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PORT_ENABLED_ENTITY__SOURCE = eINSTANCE.getPortEnabledEntity_Source();

		/**
		 * The meta object literal for the '<em><b>Sink</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PORT_ENABLED_ENTITY__SINK = eINSTANCE.getPortEnabledEntity_Sink();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.InterfacePortImpl <em>Interface Port</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.InterfacePortImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getInterfacePort()
		 * @generated
		 */
		EClass INTERFACE_PORT = eINSTANCE.getInterfacePort();

		/**
		 * The meta object literal for the '<em><b>Is Required</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute INTERFACE_PORT__IS_REQUIRED = eINSTANCE.getInterfacePort_IsRequired();

		/**
		 * The meta object literal for the '<em><b>Interface Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERFACE_PORT__INTERFACE_TYPE = eINSTANCE.getInterfacePort_InterfaceType();

		/**
		 * The meta object literal for the '<em><b>Requiring Component Type</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERFACE_PORT__REQUIRING_COMPONENT_TYPE = eINSTANCE.getInterfacePort_RequiringComponentType();

		/**
		 * The meta object literal for the '<em><b>Providing Component Type</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERFACE_PORT__PROVIDING_COMPONENT_TYPE = eINSTANCE.getInterfacePort_ProvidingComponentType();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.PortImpl <em>Port</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.PortImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getPort()
		 * @generated
		 */
		EClass PORT = eINSTANCE.getPort();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.InterfaceImpl <em>Interface</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.InterfaceImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getInterface()
		 * @generated
		 */
		EClass INTERFACE = eINSTANCE.getInterface();

		/**
		 * The meta object literal for the '<em><b>Signatures</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERFACE__SIGNATURES = eINSTANCE.getInterface_Signatures();

		/**
		 * The meta object literal for the '<em><b>Inheritance</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERFACE__INHERITANCE = eINSTANCE.getInterface_Inheritance();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.OperationImpl <em>Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.OperationImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getOperation()
		 * @generated
		 */
		EClass OPERATION = eINSTANCE.getOperation();

		/**
		 * The meta object literal for the '<em><b>Input</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__INPUT = eINSTANCE.getOperation_Input();

		/**
		 * The meta object literal for the '<em><b>Output</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__OUTPUT = eINSTANCE.getOperation_Output();

		/**
		 * The meta object literal for the '<em><b>Throws Exceptions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION__THROWS_EXCEPTIONS = eINSTANCE.getOperation_ThrowsExceptions();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.MessageTypeImpl <em>Message Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.MessageTypeImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getMessageType()
		 * @generated
		 */
		EClass MESSAGE_TYPE = eINSTANCE.getMessageType();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE_TYPE__PARAMETERS = eINSTANCE.getMessageType_Parameters();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.ParameterImpl <em>Parameter</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.ParameterImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getParameter()
		 * @generated
		 */
		EClass PARAMETER = eINSTANCE.getParameter();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PARAMETER__TYPE = eINSTANCE.getParameter_Type();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.OperationExceptionImpl <em>Operation Exception</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.OperationExceptionImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getOperationException()
		 * @generated
		 */
		EClass OPERATION_EXCEPTION = eINSTANCE.getOperationException();

		/**
		 * The meta object literal for the '<em><b>Exception Message</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute OPERATION_EXCEPTION__EXCEPTION_MESSAGE = eINSTANCE.getOperationException_ExceptionMessage();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.EventPortImpl <em>Event Port</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.EventPortImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getEventPort()
		 * @generated
		 */
		EClass EVENT_PORT = eINSTANCE.getEventPort();

		/**
		 * The meta object literal for the '<em><b>Is Source</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EVENT_PORT__IS_SOURCE = eINSTANCE.getEventPort_IsSource();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EVENT_PORT__MESSAGE = eINSTANCE.getEventPort_Message();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.ConnectorImpl <em>Connector</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.ConnectorImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getConnector()
		 * @generated
		 */
		EClass CONNECTOR = eINSTANCE.getConnector();

		/**
		 * The meta object literal for the '<em><b>Is Delegation</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONNECTOR__IS_DELEGATION = eINSTANCE.getConnector_IsDelegation();

		/**
		 * The meta object literal for the '<em><b>Endpoints</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONNECTOR__ENDPOINTS = eINSTANCE.getConnector_Endpoints();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.EndPointImpl <em>End Point</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.EndPointImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getEndPoint()
		 * @generated
		 */
		EClass END_POINT = eINSTANCE.getEndPoint();

		/**
		 * The meta object literal for the '<em><b>Port</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference END_POINT__PORT = eINSTANCE.getEndPoint_Port();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.SubcomponentEndpointImpl <em>Subcomponent Endpoint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.SubcomponentEndpointImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getSubcomponentEndpoint()
		 * @generated
		 */
		EClass SUBCOMPONENT_ENDPOINT = eINSTANCE.getSubcomponentEndpoint();

		/**
		 * The meta object literal for the '<em><b>Subcomponent</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SUBCOMPONENT_ENDPOINT__SUBCOMPONENT = eINSTANCE.getSubcomponentEndpoint_Subcomponent();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.RepositoryImpl <em>Repository</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.RepositoryImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getRepository()
		 * @generated
		 */
		EClass REPOSITORY = eINSTANCE.getRepository();

		/**
		 * The meta object literal for the '<em><b>Componenttype</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPOSITORY__COMPONENTTYPE = eINSTANCE.getRepository_Componenttype();

		/**
		 * The meta object literal for the '<em><b>Interface</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPOSITORY__INTERFACE = eINSTANCE.getRepository_Interface();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPOSITORY__TYPE = eINSTANCE.getRepository_Type();

		/**
		 * The meta object literal for the '<em><b>Messagetype</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REPOSITORY__MESSAGETYPE = eINSTANCE.getRepository_Messagetype();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.ComponentEndpointImpl <em>Component Endpoint</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.ComponentEndpointImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getComponentEndpoint()
		 * @generated
		 */
		EClass COMPONENT_ENDPOINT = eINSTANCE.getComponentEndpoint();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.CompositeComponentImpl <em>Composite Component</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.CompositeComponentImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getCompositeComponent()
		 * @generated
		 */
		EClass COMPOSITE_COMPONENT = eINSTANCE.getCompositeComponent();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.staticstructure.impl.PrimitiveComponentImpl <em>Primitive Component</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.staticstructure.impl.PrimitiveComponentImpl
		 * @see eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl#getPrimitiveComponent()
		 * @generated
		 */
		EClass PRIMITIVE_COMPONENT = eINSTANCE.getPrimitiveComponent();

		/**
		 * The meta object literal for the '<em><b>Passive Resources</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PRIMITIVE_COMPONENT__PASSIVE_RESOURCES = eINSTANCE.getPrimitiveComponent_PassiveResources();

	}

} //StaticstructurePackage
