/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.deployment.allocation.Service;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Service Architecture Model</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This entity is a composite structure representing a service-oriented architecture model. A ServiceArchitectureModel is a set of services connected to form a service architecture (SA). A SA provides and requires services through interfaces. It provides an abstraction level for modelling services and reasoning about their behaviour. Therefore, all constituents on the first nesting level have to be of the service type.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.ServiceArchitectureModel#getService <em>Service</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getServiceArchitectureModel()
 * @model
 * @generated
 */
public interface ServiceArchitectureModel extends PortEnabledEntity, CompositeStructure {
	/**
	 * Returns the value of the '<em><b>Service</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.allocation.Service}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The property represents the services that form the service architecture model.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Service</em>' containment reference list.
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getServiceArchitectureModel_Service()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<Service> getService();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * self.subcomponents->forAll(e|self.service->exists(s|s.subcomponentInstance.id = e.id))
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='self.subcomponents->forAll(e|self.service->exists(s|s.subcomponentInstance.id = e.id))'"
	 * @generated
	 */
	boolean AllSubComponentInstancesAreDeployed(DiagnosticChain diagnostics, Map<Object, Object> context);

} // ServiceArchitectureModel
