/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Operation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents an operation signature, i.e., types of input and output messages and exceptions that can be thrown by an operation. It is similar to the WSDL Operation.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.Operation#getInput <em>Input</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.Operation#getOutput <em>Output</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.Operation#getThrowsExceptions <em>Throws Exceptions</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getOperation()
 * @model
 * @generated
 */
public interface Operation extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Input</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property defines the input of the operation.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Input</em>' reference.
	 * @see #setInput(MessageType)
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getOperation_Input()
	 * @model ordered="false"
	 * @generated
	 */
	MessageType getInput();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.staticstructure.Operation#getInput <em>Input</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Input</em>' reference.
	 * @see #getInput()
	 * @generated
	 */
	void setInput(MessageType value);

	/**
	 * Returns the value of the '<em><b>Output</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The property defines the return or output values of the operation.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Output</em>' reference.
	 * @see #setOutput(MessageType)
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getOperation_Output()
	 * @model ordered="false"
	 * @generated
	 */
	MessageType getOutput();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.staticstructure.Operation#getOutput <em>Output</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Output</em>' reference.
	 * @see #getOutput()
	 * @generated
	 */
	void setOutput(MessageType value);

	/**
	 * Returns the value of the '<em><b>Throws Exceptions</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.staticstructure.OperationException}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The property specifies the exceptions that can be thrown during the operation processing.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Throws Exceptions</em>' containment reference list.
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getOperation_ThrowsExceptions()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<OperationException> getThrowsExceptions();

} // Operation
