/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Interface Port</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * An InterfacePort represents an instance of an interface which allows exploiting the functionality of a component via method calls.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.InterfacePort#isRequired <em>Is Required</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.InterfacePort#getInterfaceType <em>Interface Type</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.InterfacePort#getRequiringComponentType <em>Requiring Component Type</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.InterfacePort#getProvidingComponentType <em>Providing Component Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getInterfacePort()
 * @model
 * @generated
 */
public interface InterfacePort extends Port {
	/**
	 * Returns the value of the '<em><b>Is Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attributes specifies the role of the port---whether it is a required (isRequired set to true) or provided (isRequired set to false) port.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Is Required</em>' attribute.
	 * @see #isSetIsRequired()
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getInterfacePort_IsRequired()
	 * @model unsettable="true" required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	boolean isRequired();

	/**
	 * Returns whether the value of the '{@link eu.qimpress.samm.staticstructure.InterfacePort#isRequired <em>Is Required</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Is Required</em>' attribute is set.
	 * @see #isRequired()
	 * @generated
	 */
	boolean isSetIsRequired();

	/**
	 * Returns the value of the '<em><b>Interface Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property specifies the type of the InterfacePort.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Interface Type</em>' reference.
	 * @see #setInterfaceType(Interface)
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getInterfacePort_InterfaceType()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Interface getInterfaceType();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.staticstructure.InterfacePort#getInterfaceType <em>Interface Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interface Type</em>' reference.
	 * @see #getInterfaceType()
	 * @generated
	 */
	void setInterfaceType(Interface value);

	/**
	 * Returns the value of the '<em><b>Requiring Component Type</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link eu.qimpress.samm.staticstructure.PortEnabledEntity#getRequired <em>Required</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Requiring Component Type</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Requiring Component Type</em>' container reference.
	 * @see #setRequiringComponentType(PortEnabledEntity)
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getInterfacePort_RequiringComponentType()
	 * @see eu.qimpress.samm.staticstructure.PortEnabledEntity#getRequired
	 * @model opposite="required" transient="false" ordered="false"
	 * @generated
	 */
	PortEnabledEntity getRequiringComponentType();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.staticstructure.InterfacePort#getRequiringComponentType <em>Requiring Component Type</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Requiring Component Type</em>' container reference.
	 * @see #getRequiringComponentType()
	 * @generated
	 */
	void setRequiringComponentType(PortEnabledEntity value);

	/**
	 * Returns the value of the '<em><b>Providing Component Type</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link eu.qimpress.samm.staticstructure.PortEnabledEntity#getProvided <em>Provided</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Providing Component Type</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Providing Component Type</em>' container reference.
	 * @see #setProvidingComponentType(PortEnabledEntity)
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getInterfacePort_ProvidingComponentType()
	 * @see eu.qimpress.samm.staticstructure.PortEnabledEntity#getProvided
	 * @model opposite="provided" transient="false" ordered="false"
	 * @generated
	 */
	PortEnabledEntity getProvidingComponentType();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.staticstructure.InterfacePort#getProvidingComponentType <em>Providing Component Type</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Providing Component Type</em>' container reference.
	 * @see #getProvidingComponentType()
	 * @generated
	 */
	void setProvidingComponentType(PortEnabledEntity value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * (not self.providingComponentType.oclIsUndefined()) xor (not self.requiringComponentType.oclIsUndefined())
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='(not self.providingComponentType.oclIsUndefined()) xor (not self.requiringComponentType.oclIsUndefined())'"
	 * @generated
	 */
	boolean PortMustBeEitherARequiredOrAProvidedPort(DiagnosticChain diagnostics, Map<Object, Object> context);

} // InterfacePort
