/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Interface</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The Interface class represents the interface concept of the SOA. It is the visible part of a component to which connector endpoints can be attached and which represents the access point to the component's functionality.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.Interface#getSignatures <em>Signatures</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.Interface#getInheritance <em>Inheritance</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getInterface()
 * @model
 * @generated
 */
public interface Interface extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Signatures</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.staticstructure.Operation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the set of operations the interface consists of.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Signatures</em>' containment reference list.
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getInterface_Signatures()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<Operation> getSignatures();

	/**
	 * Returns the value of the '<em><b>Inheritance</b></em>' reference list.
	 * The list contents are of type {@link eu.qimpress.samm.staticstructure.Interface}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property contains references to interfaces from which this interface is derived.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inheritance</em>' reference list.
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getInterface_Inheritance()
	 * @model ordered="false"
	 * @generated
	 */
	EList<Interface> getInheritance();

} // Interface
