/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.Entity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Connector</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The Connector entity represents a binding between ports of components to enable communication between components. The actual kind of the port (EventPort or InterfacePort) determine the communication style, i.e., either message passing or method invocations.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.Connector#isDelegation <em>Is Delegation</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.Connector#getEndpoints <em>Endpoints</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getConnector()
 * @model
 * @generated
 */
public interface Connector extends Entity {
	/**
	 * Returns the value of the '<em><b>Is Delegation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This derived attribute differentiates between two kinds of connectors---assembly connectors and delegation connectors. An assembly connector (for which the attribute is set to false) is used for connecting ports of components on the same hierarchy level, while a delegation connector (for which the attribute is set to true) connects ports on adjacent hierarchy levels, i.e., connecting a port of a CompositeStructure with a port of its subcomponent.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Is Delegation</em>' attribute.
	 * @see #isSetIsDelegation()
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getConnector_IsDelegation()
	 * @model unique="false" unsettable="true" required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	boolean isDelegation();

	/**
	 * Returns whether the value of the '{@link eu.qimpress.samm.staticstructure.Connector#isDelegation <em>Is Delegation</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Is Delegation</em>' attribute is set.
	 * @see #isDelegation()
	 * @generated
	 */
	boolean isSetIsDelegation();

	/**
	 * Returns the value of the '<em><b>Endpoints</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.staticstructure.EndPoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the endpoints of the connector, i.e., entities to be attached to component ports.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Endpoints</em>' containment reference list.
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getConnector_Endpoints()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<EndPoint> getEndpoints();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * true
	 * --if (self.isDelegation=true) then
	 * -- self.endpoints->forAll(sce | sce.oclAsType(SubcomponentEndpoint).subcomponent.parent.id = self.oclAsType(SubcomponentEndpoint).subcomponent.parent.id))
	 * -- else 
	 * --	 (self.endpoints->forAll(sce | sce.oclAsType(SubcomponentEndpoint).subcomponent.id = self.oclAsType(SubcomponentEndpoint).subcomponent.id))
	 * --endif
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='true\r\n--if (self.isDelegation=true) then\r\n-- self.endpoints->forAll(sce | sce.oclAsType(SubcomponentEndpoint).subcomponent.parent.id = self.oclAsType(SubcomponentEndpoint).subcomponent.parent.id))\r\n-- else \r\n--\t (self.endpoints->forAll(sce | sce.oclAsType(SubcomponentEndpoint).subcomponent.id = self.oclAsType(SubcomponentEndpoint).subcomponent.id))\r\n--endif'"
	 * @generated
	 */
	boolean oneLevelConnectors(DiagnosticChain diagnostics, Map<Object, Object> context);

} // Connector
