/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Composite Structure</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This abstract entity represents an entity composed of subcomponents. The ports of a composite structure are on the inner side connected to ports of its subcomponents using delegation connectors. The ports of subcomponents may be, in addition, connected via assembly connectors to each other. CompositeStructure is a superclass for both CompositeComponent and ServiceArchitecturesModel.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.CompositeStructure#getSubcomponents <em>Subcomponents</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.CompositeStructure#getConnector <em>Connector</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getCompositeStructure()
 * @model abstract="true"
 * @generated
 */
public interface CompositeStructure extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Subcomponents</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.staticstructure.SubcomponentInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the subcomponents forming this CompositeStructure.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Subcomponents</em>' containment reference list.
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getCompositeStructure_Subcomponents()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<SubcomponentInstance> getSubcomponents();

	/**
	 * Returns the value of the '<em><b>Connector</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.staticstructure.Connector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the set of connectors connecting both ports of subcomponents to each other and ports of subcomponents to ports of this CompositeStructure.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Connector</em>' containment reference list.
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getCompositeStructure_Connector()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<Connector> getConnector();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * -- for all assembly connectors:
	 * -- check if all referenced subcomponentendpoints reference a subcomponent that is directly nested in the composed structure
	 * self.connector->select(con|con.isDelegation = false)->forAll(asconnector | asconnector.endpoints->forAll(sce | self.subcomponents->exists(subcomp | subcomp.id =  sce.oclAsType(SubcomponentEndpoint).subcomponent.id)))
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='-- for all assembly connectors:\r\n-- check if all referenced subcomponentendpoints reference a subcomponent that is directly nested in the composed structure\r\nself.connector->select(con|con.isDelegation = false)->forAll(asconnector | asconnector.endpoints->forAll(sce | self.subcomponents->exists(subcomp | subcomp.id =  sce.oclAsType(SubcomponentEndpoint).subcomponent.id)))'"
	 * @generated
	 */
	boolean AllAssemblyConnectorsAreOnTheSameLevel(DiagnosticChain diagnostics, Map<Object, Object> context);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * -- for all delegation connectors:
	 * -- check if all referenced subcomponentendpoints reference a subcomponent that is directly nested in the composed structure
	 * self.connector->select(con|con.isDelegation = true)->forAll(delconnector | delconnector.endpoints->select (endpoint | endpoint.oclIsTypeOf(SubcomponentEndpoint))->forAll(sce | self.subcomponents->exists(subcomp | subcomp.id =  sce.oclAsType(SubcomponentEndpoint).subcomponent.id)))
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='-- for all delegation connectors:\r\n-- check if all referenced subcomponentendpoints reference a subcomponent that is directly nested in the composed structure\r\nself.connector->select(con|con.isDelegation = true)->forAll(delconnector | delconnector.endpoints->select (endpoint | endpoint.oclIsTypeOf(SubcomponentEndpoint))->forAll(sce | self.subcomponents->exists(subcomp | subcomp.id =  sce.oclAsType(SubcomponentEndpoint).subcomponent.id)))'"
	 * @generated
	 */
	boolean AllDelegationConnectorsReferenceOnlyOneLevelNestedSubcomponents(DiagnosticChain diagnostics, Map<Object, Object> context);

} // CompositeStructure
