/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.behaviour.ComponentTypeBehaviour;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Component Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This abstract class represents a type of a component. ComponentType is determined by two sets of ports---a set of ports provided and a set of ports required by components of this type. It forms also a common superclass for PrimitiveComponent and CompositeComponent.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.staticstructure.ComponentType#getOperationBehaviour <em>Operation Behaviour</em>}</li>
 *   <li>{@link eu.qimpress.samm.staticstructure.ComponentType#getComponentTypeBehaviour <em>Component Type Behaviour</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getComponentType()
 * @model abstract="true"
 * @generated
 */
public interface ComponentType extends PortEnabledEntity, NamedEntity {
	/**
	 * Returns the value of the '<em><b>Operation Behaviour</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.behaviour.OperationBehaviour}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property defines the operation-specific behaviour of the ComponentType.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Operation Behaviour</em>' containment reference list.
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getComponentType_OperationBehaviour()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<OperationBehaviour> getOperationBehaviour();

	/**
	 * Returns the value of the '<em><b>Component Type Behaviour</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property defines the behaviour of the ComponentType, which is not operation-specific.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Component Type Behaviour</em>' containment reference.
	 * @see #setComponentTypeBehaviour(ComponentTypeBehaviour)
	 * @see eu.qimpress.samm.staticstructure.StaticstructurePackage#getComponentType_ComponentTypeBehaviour()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	ComponentTypeBehaviour getComponentTypeBehaviour();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.staticstructure.ComponentType#getComponentTypeBehaviour <em>Component Type Behaviour</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Component Type Behaviour</em>' containment reference.
	 * @see #getComponentTypeBehaviour()
	 * @generated
	 */
	void setComponentTypeBehaviour(ComponentTypeBehaviour value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * provided->size() + required->size() >= 1  
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='provided->size() + required->size() >= 1  '"
	 * @generated
	 */
	boolean HasToProvideOrRequireServices(DiagnosticChain diagnostics, Map<Object, Object> context);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * -- Make sure no InterfacePort is both a required and a provided port. Note that an interface can be both provided and required, but via different ports.
	 * self.required->intersection(self.provided)->isEmpty()
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='-- Make sure no InterfacePort is both a required and a provided port. Note that an interface can be both provided and required, but via different ports.\r\nself.required->intersection(self.provided)->isEmpty()'"
	 * @generated
	 */
	boolean NoInterfacePortAssociatedTwice(DiagnosticChain diagnostics, Map<Object, Object> context);

} // ComponentType
