/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.qosannotation.impl;

import eu.qimpress.samm.qosannotation.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import eu.qimpress.samm.qosannotation.AnnotationType;
import eu.qimpress.samm.qosannotation.ConstantNumber;
import eu.qimpress.samm.qosannotation.DistType;
import eu.qimpress.samm.qosannotation.Distribution;
import eu.qimpress.samm.qosannotation.Formula;
import eu.qimpress.samm.qosannotation.ParametricFormula;
import eu.qimpress.samm.qosannotation.QosAnnotations;
import eu.qimpress.samm.qosannotation.QosannotationFactory;
import eu.qimpress.samm.qosannotation.QosannotationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class QosannotationFactoryImpl extends EFactoryImpl implements QosannotationFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static QosannotationFactory init() {
		try {
			QosannotationFactory theQosannotationFactory = (QosannotationFactory)EPackage.Registry.INSTANCE.getEFactory("http://q-impress.eu/samm/qosannotation"); 
			if (theQosannotationFactory != null) {
				return theQosannotationFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new QosannotationFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QosannotationFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case QosannotationPackage.QOS_ANNOTATIONS: return createQosAnnotations();
			case QosannotationPackage.CONSTANT_NUMBER: return createConstantNumber();
			case QosannotationPackage.DISTRIBUTION: return createDistribution();
			case QosannotationPackage.FORMULA: return createFormula();
			case QosannotationPackage.PARAMETRIC_FORMULA: return createParametricFormula();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case QosannotationPackage.ANNOTATION_TYPE:
				return createAnnotationTypeFromString(eDataType, initialValue);
			case QosannotationPackage.DIST_TYPE:
				return createDistTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case QosannotationPackage.ANNOTATION_TYPE:
				return convertAnnotationTypeToString(eDataType, instanceValue);
			case QosannotationPackage.DIST_TYPE:
				return convertDistTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QosAnnotations createQosAnnotations() {
		QosAnnotationsImpl qosAnnotations = new QosAnnotationsImpl();
		return qosAnnotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConstantNumber createConstantNumber() {
		ConstantNumberImpl constantNumber = new ConstantNumberImpl();
		return constantNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Distribution createDistribution() {
		DistributionImpl distribution = new DistributionImpl();
		return distribution;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Formula createFormula() {
		FormulaImpl formula = new FormulaImpl();
		return formula;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ParametricFormula createParametricFormula() {
		ParametricFormulaImpl parametricFormula = new ParametricFormulaImpl();
		return parametricFormula;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AnnotationType createAnnotationTypeFromString(EDataType eDataType, String initialValue) {
		AnnotationType result = AnnotationType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertAnnotationTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DistType createDistTypeFromString(EDataType eDataType, String initialValue) {
		DistType result = DistType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertDistTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QosannotationPackage getQosannotationPackage() {
		return (QosannotationPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static QosannotationPackage getPackage() {
		return QosannotationPackage.eINSTANCE;
	}

} //QosannotationFactoryImpl
