/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.qosannotation;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.uka.ipd.sdq.stoex.StoexPackage;
import eu.qimpress.samm.core.CorePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see eu.qimpress.samm.qosannotation.QosannotationFactory
 * @model kind="package"
 * @generated
 */
public interface QosannotationPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "qosannotation";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://q-impress.eu/samm/qosannotation";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "qosannotation";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	QosannotationPackage eINSTANCE = eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl.init();

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.qosannotation.impl.QosAnnotationsImpl <em>Qos Annotations</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.qosannotation.impl.QosAnnotationsImpl
	 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getQosAnnotations()
	 * @generated
	 */
	int QOS_ANNOTATIONS = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QOS_ANNOTATIONS__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QOS_ANNOTATIONS__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QOS_ANNOTATIONS__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Annotation</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QOS_ANNOTATIONS__ANNOTATION = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Qos Annotations</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QOS_ANNOTATIONS_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.qosannotation.impl.AnnotationImpl <em>Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.qosannotation.impl.AnnotationImpl
	 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getAnnotation()
	 * @generated
	 */
	int ANNOTATION = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Annotation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__ANNOTATION_TYPE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Constant Number</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__CONSTANT_NUMBER = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__DISTRIBUTION = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Formula</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__FORMULA = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parametric Formula</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__PARAMETRIC_FORMULA = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Qos Annotations</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION__QOS_ANNOTATIONS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANNOTATION_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.qosannotation.impl.ConstantNumberImpl <em>Constant Number</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.qosannotation.impl.ConstantNumberImpl
	 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getConstantNumber()
	 * @generated
	 */
	int CONSTANT_NUMBER = 2;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_NUMBER__VALUE = 0;

	/**
	 * The number of structural features of the '<em>Constant Number</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONSTANT_NUMBER_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.qosannotation.impl.DistributionImpl <em>Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.qosannotation.impl.DistributionImpl
	 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getDistribution()
	 * @generated
	 */
	int DISTRIBUTION = 3;

	/**
	 * The feature id for the '<em><b>Dist Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTRIBUTION__DIST_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTRIBUTION__PARAMETER = 1;

	/**
	 * The number of structural features of the '<em>Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DISTRIBUTION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.qosannotation.impl.FormulaImpl <em>Formula</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.qosannotation.impl.FormulaImpl
	 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getFormula()
	 * @generated
	 */
	int FORMULA = 4;

	/**
	 * The feature id for the '<em><b>Specification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA__SPECIFICATION = StoexPackage.RANDOM_VARIABLE__SPECIFICATION;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA__EXPRESSION = StoexPackage.RANDOM_VARIABLE__EXPRESSION;

	/**
	 * The number of structural features of the '<em>Formula</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FORMULA_FEATURE_COUNT = StoexPackage.RANDOM_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.qosannotation.impl.ParametricFormulaImpl <em>Parametric Formula</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.qosannotation.impl.ParametricFormulaImpl
	 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getParametricFormula()
	 * @generated
	 */
	int PARAMETRIC_FORMULA = 5;

	/**
	 * The feature id for the '<em><b>Specification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETRIC_FORMULA__SPECIFICATION = StoexPackage.RANDOM_VARIABLE__SPECIFICATION;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETRIC_FORMULA__EXPRESSION = StoexPackage.RANDOM_VARIABLE__EXPRESSION;

	/**
	 * The number of structural features of the '<em>Parametric Formula</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETRIC_FORMULA_FEATURE_COUNT = StoexPackage.RANDOM_VARIABLE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.qosannotation.AnnotationType <em>Annotation Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.qosannotation.AnnotationType
	 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getAnnotationType()
	 * @generated
	 */
	int ANNOTATION_TYPE = 6;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.qosannotation.DistType <em>Dist Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.qosannotation.DistType
	 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getDistType()
	 * @generated
	 */
	int DIST_TYPE = 7;


	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.qosannotation.QosAnnotations <em>Qos Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Qos Annotations</em>'.
	 * @see eu.qimpress.samm.qosannotation.QosAnnotations
	 * @generated
	 */
	EClass getQosAnnotations();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.qosannotation.QosAnnotations#getAnnotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Annotation</em>'.
	 * @see eu.qimpress.samm.qosannotation.QosAnnotations#getAnnotation()
	 * @see #getQosAnnotations()
	 * @generated
	 */
	EReference getQosAnnotations_Annotation();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.qosannotation.Annotation <em>Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Annotation</em>'.
	 * @see eu.qimpress.samm.qosannotation.Annotation
	 * @generated
	 */
	EClass getAnnotation();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.qosannotation.Annotation#getAnnotationType <em>Annotation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Annotation Type</em>'.
	 * @see eu.qimpress.samm.qosannotation.Annotation#getAnnotationType()
	 * @see #getAnnotation()
	 * @generated
	 */
	EAttribute getAnnotation_AnnotationType();

	/**
	 * Returns the meta object for the containment reference '{@link eu.qimpress.samm.qosannotation.Annotation#getConstantNumber <em>Constant Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Constant Number</em>'.
	 * @see eu.qimpress.samm.qosannotation.Annotation#getConstantNumber()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_ConstantNumber();

	/**
	 * Returns the meta object for the containment reference '{@link eu.qimpress.samm.qosannotation.Annotation#getDistribution <em>Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Distribution</em>'.
	 * @see eu.qimpress.samm.qosannotation.Annotation#getDistribution()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_Distribution();

	/**
	 * Returns the meta object for the containment reference '{@link eu.qimpress.samm.qosannotation.Annotation#getFormula <em>Formula</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Formula</em>'.
	 * @see eu.qimpress.samm.qosannotation.Annotation#getFormula()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_Formula();

	/**
	 * Returns the meta object for the containment reference '{@link eu.qimpress.samm.qosannotation.Annotation#getParametricFormula <em>Parametric Formula</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Parametric Formula</em>'.
	 * @see eu.qimpress.samm.qosannotation.Annotation#getParametricFormula()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_ParametricFormula();

	/**
	 * Returns the meta object for the container reference '{@link eu.qimpress.samm.qosannotation.Annotation#getQosAnnotations <em>Qos Annotations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Qos Annotations</em>'.
	 * @see eu.qimpress.samm.qosannotation.Annotation#getQosAnnotations()
	 * @see #getAnnotation()
	 * @generated
	 */
	EReference getAnnotation_QosAnnotations();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.qosannotation.ConstantNumber <em>Constant Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Constant Number</em>'.
	 * @see eu.qimpress.samm.qosannotation.ConstantNumber
	 * @generated
	 */
	EClass getConstantNumber();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.qosannotation.ConstantNumber#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see eu.qimpress.samm.qosannotation.ConstantNumber#getValue()
	 * @see #getConstantNumber()
	 * @generated
	 */
	EAttribute getConstantNumber_Value();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.qosannotation.Distribution <em>Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Distribution</em>'.
	 * @see eu.qimpress.samm.qosannotation.Distribution
	 * @generated
	 */
	EClass getDistribution();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.qosannotation.Distribution#getDistType <em>Dist Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dist Type</em>'.
	 * @see eu.qimpress.samm.qosannotation.Distribution#getDistType()
	 * @see #getDistribution()
	 * @generated
	 */
	EAttribute getDistribution_DistType();

	/**
	 * Returns the meta object for the attribute list '{@link eu.qimpress.samm.qosannotation.Distribution#getParameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Parameter</em>'.
	 * @see eu.qimpress.samm.qosannotation.Distribution#getParameter()
	 * @see #getDistribution()
	 * @generated
	 */
	EAttribute getDistribution_Parameter();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.qosannotation.Formula <em>Formula</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Formula</em>'.
	 * @see eu.qimpress.samm.qosannotation.Formula
	 * @generated
	 */
	EClass getFormula();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.qosannotation.ParametricFormula <em>Parametric Formula</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parametric Formula</em>'.
	 * @see eu.qimpress.samm.qosannotation.ParametricFormula
	 * @generated
	 */
	EClass getParametricFormula();

	/**
	 * Returns the meta object for enum '{@link eu.qimpress.samm.qosannotation.AnnotationType <em>Annotation Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Annotation Type</em>'.
	 * @see eu.qimpress.samm.qosannotation.AnnotationType
	 * @generated
	 */
	EEnum getAnnotationType();

	/**
	 * Returns the meta object for enum '{@link eu.qimpress.samm.qosannotation.DistType <em>Dist Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Dist Type</em>'.
	 * @see eu.qimpress.samm.qosannotation.DistType
	 * @generated
	 */
	EEnum getDistType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	QosannotationFactory getQosannotationFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.qosannotation.impl.QosAnnotationsImpl <em>Qos Annotations</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.qosannotation.impl.QosAnnotationsImpl
		 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getQosAnnotations()
		 * @generated
		 */
		EClass QOS_ANNOTATIONS = eINSTANCE.getQosAnnotations();

		/**
		 * The meta object literal for the '<em><b>Annotation</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference QOS_ANNOTATIONS__ANNOTATION = eINSTANCE.getQosAnnotations_Annotation();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.qosannotation.impl.AnnotationImpl <em>Annotation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.qosannotation.impl.AnnotationImpl
		 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getAnnotation()
		 * @generated
		 */
		EClass ANNOTATION = eINSTANCE.getAnnotation();

		/**
		 * The meta object literal for the '<em><b>Annotation Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ANNOTATION__ANNOTATION_TYPE = eINSTANCE.getAnnotation_AnnotationType();

		/**
		 * The meta object literal for the '<em><b>Constant Number</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__CONSTANT_NUMBER = eINSTANCE.getAnnotation_ConstantNumber();

		/**
		 * The meta object literal for the '<em><b>Distribution</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__DISTRIBUTION = eINSTANCE.getAnnotation_Distribution();

		/**
		 * The meta object literal for the '<em><b>Formula</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__FORMULA = eINSTANCE.getAnnotation_Formula();

		/**
		 * The meta object literal for the '<em><b>Parametric Formula</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__PARAMETRIC_FORMULA = eINSTANCE.getAnnotation_ParametricFormula();

		/**
		 * The meta object literal for the '<em><b>Qos Annotations</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANNOTATION__QOS_ANNOTATIONS = eINSTANCE.getAnnotation_QosAnnotations();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.qosannotation.impl.ConstantNumberImpl <em>Constant Number</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.qosannotation.impl.ConstantNumberImpl
		 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getConstantNumber()
		 * @generated
		 */
		EClass CONSTANT_NUMBER = eINSTANCE.getConstantNumber();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONSTANT_NUMBER__VALUE = eINSTANCE.getConstantNumber_Value();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.qosannotation.impl.DistributionImpl <em>Distribution</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.qosannotation.impl.DistributionImpl
		 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getDistribution()
		 * @generated
		 */
		EClass DISTRIBUTION = eINSTANCE.getDistribution();

		/**
		 * The meta object literal for the '<em><b>Dist Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DISTRIBUTION__DIST_TYPE = eINSTANCE.getDistribution_DistType();

		/**
		 * The meta object literal for the '<em><b>Parameter</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DISTRIBUTION__PARAMETER = eINSTANCE.getDistribution_Parameter();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.qosannotation.impl.FormulaImpl <em>Formula</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.qosannotation.impl.FormulaImpl
		 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getFormula()
		 * @generated
		 */
		EClass FORMULA = eINSTANCE.getFormula();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.qosannotation.impl.ParametricFormulaImpl <em>Parametric Formula</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.qosannotation.impl.ParametricFormulaImpl
		 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getParametricFormula()
		 * @generated
		 */
		EClass PARAMETRIC_FORMULA = eINSTANCE.getParametricFormula();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.qosannotation.AnnotationType <em>Annotation Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.qosannotation.AnnotationType
		 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getAnnotationType()
		 * @generated
		 */
		EEnum ANNOTATION_TYPE = eINSTANCE.getAnnotationType();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.qosannotation.DistType <em>Dist Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.qosannotation.DistType
		 * @see eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl#getDistType()
		 * @generated
		 */
		EEnum DIST_TYPE = eINSTANCE.getDistType();

	}

} //QosannotationPackage
