/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import eu.qimpress.identifier.Identifier;
import eu.qimpress.samm.annotation.Annotation;
import eu.qimpress.samm.core.Entity;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.deployment.targetenvironment.*;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.ExecutionResource;
import eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile;
import eu.qimpress.samm.deployment.targetenvironment.Memory;
import eu.qimpress.samm.deployment.targetenvironment.MemoryResource;
import eu.qimpress.samm.deployment.targetenvironment.NetworkElement;
import eu.qimpress.samm.deployment.targetenvironment.NetworkInterface;
import eu.qimpress.samm.deployment.targetenvironment.NetworkResource;
import eu.qimpress.samm.deployment.targetenvironment.Node;
import eu.qimpress.samm.deployment.targetenvironment.Processor;
import eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile;
import eu.qimpress.samm.deployment.targetenvironment.StorageDevice;
import eu.qimpress.samm.deployment.targetenvironment.StorageResource;
import eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage
 * @generated
 */
public class TargetenvironmentSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static TargetenvironmentPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TargetenvironmentSwitch() {
		if (modelPackage == null) {
			modelPackage = TargetenvironmentPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case TargetenvironmentPackage.NETWORK_ELEMENT: {
				NetworkElement networkElement = (NetworkElement)theEObject;
				T result = caseNetworkElement(networkElement);
				if (result == null) result = caseNamedEntity(networkElement);
				if (result == null) result = caseEntity(networkElement);
				if (result == null) result = caseIdentifier(networkElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.NETWORK_INTERFACE: {
				NetworkInterface networkInterface = (NetworkInterface)theEObject;
				T result = caseNetworkInterface(networkInterface);
				if (result == null) result = caseNamedEntity(networkInterface);
				if (result == null) result = caseEntity(networkInterface);
				if (result == null) result = caseIdentifier(networkInterface);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.NODE: {
				Node node = (Node)theEObject;
				T result = caseNode(node);
				if (result == null) result = caseNamedEntity(node);
				if (result == null) result = caseEntity(node);
				if (result == null) result = caseIdentifier(node);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.CONTAINER: {
				Container container = (Container)theEObject;
				T result = caseContainer(container);
				if (result == null) result = caseNamedEntity(container);
				if (result == null) result = caseEntity(container);
				if (result == null) result = caseIdentifier(container);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.STORAGE_RESOURCE: {
				StorageResource storageResource = (StorageResource)theEObject;
				T result = caseStorageResource(storageResource);
				if (result == null) result = caseNamedEntity(storageResource);
				if (result == null) result = caseEntity(storageResource);
				if (result == null) result = caseIdentifier(storageResource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.STORAGE_DEVICE: {
				StorageDevice storageDevice = (StorageDevice)theEObject;
				T result = caseStorageDevice(storageDevice);
				if (result == null) result = caseNamedEntity(storageDevice);
				if (result == null) result = caseEntity(storageDevice);
				if (result == null) result = caseIdentifier(storageDevice);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.MEMORY_RESOURCE: {
				MemoryResource memoryResource = (MemoryResource)theEObject;
				T result = caseMemoryResource(memoryResource);
				if (result == null) result = caseNamedEntity(memoryResource);
				if (result == null) result = caseEntity(memoryResource);
				if (result == null) result = caseIdentifier(memoryResource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.MEMORY: {
				Memory memory = (Memory)theEObject;
				T result = caseMemory(memory);
				if (result == null) result = caseNamedEntity(memory);
				if (result == null) result = caseEntity(memory);
				if (result == null) result = caseIdentifier(memory);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.EXECUTION_RESOURCE: {
				ExecutionResource executionResource = (ExecutionResource)theEObject;
				T result = caseExecutionResource(executionResource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.PROCESSOR: {
				Processor processor = (Processor)theEObject;
				T result = caseProcessor(processor);
				if (result == null) result = caseNamedEntity(processor);
				if (result == null) result = caseEntity(processor);
				if (result == null) result = caseIdentifier(processor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.NETWORK_RESOURCE: {
				NetworkResource networkResource = (NetworkResource)theEObject;
				T result = caseNetworkResource(networkResource);
				if (result == null) result = caseNamedEntity(networkResource);
				if (result == null) result = caseEntity(networkResource);
				if (result == null) result = caseIdentifier(networkResource);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.TARGET_ENVIRONMENT: {
				TargetEnvironment targetEnvironment = (TargetEnvironment)theEObject;
				T result = caseTargetEnvironment(targetEnvironment);
				if (result == null) result = caseNamedEntity(targetEnvironment);
				if (result == null) result = caseEntity(targetEnvironment);
				if (result == null) result = caseIdentifier(targetEnvironment);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE: {
				SoftwarePerformanceProfile softwarePerformanceProfile = (SoftwarePerformanceProfile)theEObject;
				T result = caseSoftwarePerformanceProfile(softwarePerformanceProfile);
				if (result == null) result = caseAnnotation(softwarePerformanceProfile);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TargetenvironmentPackage.FILE_SYSTEM_PERFORMANCE_PROFILE: {
				FileSystemPerformanceProfile fileSystemPerformanceProfile = (FileSystemPerformanceProfile)theEObject;
				T result = caseFileSystemPerformanceProfile(fileSystemPerformanceProfile);
				if (result == null) result = caseAnnotation(fileSystemPerformanceProfile);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Network Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Network Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNetworkElement(NetworkElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Network Interface</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Network Interface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNetworkInterface(NetworkInterface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Node</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Node</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNode(Node object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContainer(Container object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Storage Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Storage Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStorageResource(StorageResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Storage Device</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Storage Device</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStorageDevice(StorageDevice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Memory Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Memory Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMemoryResource(MemoryResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Memory</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Memory</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMemory(Memory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Execution Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Execution Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExecutionResource(ExecutionResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Processor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Processor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessor(Processor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Network Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Network Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNetworkResource(NetworkResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Target Environment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Target Environment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTargetEnvironment(TargetEnvironment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Software Performance Profile</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Software Performance Profile</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSoftwarePerformanceProfile(SoftwarePerformanceProfile object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>File System Performance Profile</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>File System Performance Profile</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFileSystemPerformanceProfile(FileSystemPerformanceProfile object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntity(Entity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedEntity(NamedEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Annotation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Annotation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnnotation(Annotation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //TargetenvironmentSwitch
