/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment.impl;

import static eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage.CONTAINER;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import de.uka.ipd.sdq.stoex.StoexPackage;
import eu.qimpress.identifier.IdentifierPackage;
import eu.qimpress.samm.annotation.AnnotationPackage;
import eu.qimpress.samm.annotation.impl.AnnotationPackageImpl;
import eu.qimpress.samm.behaviour.BehaviourPackage;
import eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl;
import eu.qimpress.samm.core.CorePackage;
import eu.qimpress.samm.core.impl.CorePackageImpl;
import eu.qimpress.samm.datatypes.DatatypesPackage;
import eu.qimpress.samm.datatypes.impl.DatatypesPackageImpl;
import eu.qimpress.samm.deployment.allocation.AllocationPackage;
import eu.qimpress.samm.deployment.allocation.impl.AllocationPackageImpl;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl;
import eu.qimpress.samm.deployment.targetenvironment.ExecutionResource;
import eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile;
import eu.qimpress.samm.deployment.targetenvironment.Memory;
import eu.qimpress.samm.deployment.targetenvironment.MemoryResource;
import eu.qimpress.samm.deployment.targetenvironment.NetworkElement;
import eu.qimpress.samm.deployment.targetenvironment.NetworkInterface;
import eu.qimpress.samm.deployment.targetenvironment.NetworkResource;
import eu.qimpress.samm.deployment.targetenvironment.Node;
import eu.qimpress.samm.deployment.targetenvironment.Processor;
import eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind;
import eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile;
import eu.qimpress.samm.deployment.targetenvironment.StorageDevice;
import eu.qimpress.samm.deployment.targetenvironment.StorageResource;
import eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentFactory;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;
import eu.qimpress.samm.qosannotation.QosannotationPackage;
import eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl;
import eu.qimpress.samm.usagemodel.UsagemodelPackage;
import eu.qimpress.samm.usagemodel.impl.UsagemodelPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class TargetenvironmentPackageImpl extends EPackageImpl implements TargetenvironmentPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass networkElementEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass networkInterfaceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass nodeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass containerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass storageResourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass storageDeviceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass memoryResourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass memoryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass executionResourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass networkResourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass targetEnvironmentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass softwarePerformanceProfileEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass fileSystemPerformanceProfileEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum schedulingPolicyKindEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private TargetenvironmentPackageImpl() {
		super(eNS_URI, TargetenvironmentFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link TargetenvironmentPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static TargetenvironmentPackage init() {
		if (isInited) return (TargetenvironmentPackage)EPackage.Registry.INSTANCE.getEPackage(TargetenvironmentPackage.eNS_URI);

		// Obtain or create and register package
		TargetenvironmentPackageImpl theTargetenvironmentPackage = (TargetenvironmentPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof TargetenvironmentPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new TargetenvironmentPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		IdentifierPackage.eINSTANCE.eClass();
		StoexPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		StaticstructurePackageImpl theStaticstructurePackage = (StaticstructurePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(StaticstructurePackage.eNS_URI) instanceof StaticstructurePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(StaticstructurePackage.eNS_URI) : StaticstructurePackage.eINSTANCE);
		CorePackageImpl theCorePackage = (CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) instanceof CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) : CorePackage.eINSTANCE);
		DatatypesPackageImpl theDatatypesPackage = (DatatypesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(DatatypesPackage.eNS_URI) instanceof DatatypesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(DatatypesPackage.eNS_URI) : DatatypesPackage.eINSTANCE);
		BehaviourPackageImpl theBehaviourPackage = (BehaviourPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(BehaviourPackage.eNS_URI) instanceof BehaviourPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(BehaviourPackage.eNS_URI) : BehaviourPackage.eINSTANCE);
		HardwarePackageImpl theHardwarePackage = (HardwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) instanceof HardwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) : HardwarePackage.eINSTANCE);
		AllocationPackageImpl theAllocationPackage = (AllocationPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AllocationPackage.eNS_URI) instanceof AllocationPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AllocationPackage.eNS_URI) : AllocationPackage.eINSTANCE);
		AnnotationPackageImpl theAnnotationPackage = (AnnotationPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AnnotationPackage.eNS_URI) instanceof AnnotationPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AnnotationPackage.eNS_URI) : AnnotationPackage.eINSTANCE);
		UsagemodelPackageImpl theUsagemodelPackage = (UsagemodelPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(UsagemodelPackage.eNS_URI) instanceof UsagemodelPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(UsagemodelPackage.eNS_URI) : UsagemodelPackage.eINSTANCE);
		QosannotationPackageImpl theQosannotationPackage = (QosannotationPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(QosannotationPackage.eNS_URI) instanceof QosannotationPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(QosannotationPackage.eNS_URI) : QosannotationPackage.eINSTANCE);

		// Create package meta-data objects
		theTargetenvironmentPackage.createPackageContents();
		theStaticstructurePackage.createPackageContents();
		theCorePackage.createPackageContents();
		theDatatypesPackage.createPackageContents();
		theBehaviourPackage.createPackageContents();
		theHardwarePackage.createPackageContents();
		theAllocationPackage.createPackageContents();
		theAnnotationPackage.createPackageContents();
		theUsagemodelPackage.createPackageContents();
		theQosannotationPackage.createPackageContents();

		// Initialize created meta-data
		theTargetenvironmentPackage.initializePackageContents();
		theStaticstructurePackage.initializePackageContents();
		theCorePackage.initializePackageContents();
		theDatatypesPackage.initializePackageContents();
		theBehaviourPackage.initializePackageContents();
		theHardwarePackage.initializePackageContents();
		theAllocationPackage.initializePackageContents();
		theAnnotationPackage.initializePackageContents();
		theUsagemodelPackage.initializePackageContents();
		theQosannotationPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theTargetenvironmentPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(TargetenvironmentPackage.eNS_URI, theTargetenvironmentPackage);
		return theTargetenvironmentPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNetworkElement() {
		return networkElementEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetworkElement_NodeConnections() {
		return (EReference)networkElementEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetworkElement_Descriptor() {
		return (EReference)networkElementEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetworkElement_Downlinks() {
		return (EReference)networkElementEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetworkElement_Siblings() {
		return (EReference)networkElementEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNetworkInterface() {
		return networkInterfaceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNetworkInterface_Bandwidth() {
		return (EAttribute)networkInterfaceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetworkInterface_Descriptor() {
		return (EReference)networkInterfaceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetworkInterface_Connection() {
		return (EReference)networkInterfaceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNode() {
		return nodeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNode_Description() {
		return (EAttribute)nodeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNode_Containers() {
		return (EReference)nodeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNode_Processors() {
		return (EReference)nodeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNode_Memories() {
		return (EReference)nodeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNode_StorageDevices() {
		return (EReference)nodeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNode_NetworkInterfaces() {
		return (EReference)nodeEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContainer() {
		return containerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContainer_Description() {
		return (EAttribute)containerEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContainer_StorageResources() {
		return (EReference)containerEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContainer_MemoryResources() {
		return (EReference)containerEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContainer_ExecutionResources() {
		return (EReference)containerEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContainer_SchedulingPolicy() {
		return (EAttribute)containerEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContainer_NetworkResources() {
		return (EReference)containerEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStorageResource() {
		return storageResourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStorageResource_Description() {
		return (EAttribute)storageResourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getStorageResource_StorageDevices() {
		return (EReference)storageResourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStorageResource_Size() {
		return (EAttribute)storageResourceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStorageDevice() {
		return storageDeviceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getStorageDevice_Descriptor() {
		return (EReference)storageDeviceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStorageDevice_Size() {
		return (EAttribute)storageDeviceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMemoryResource() {
		return memoryResourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMemoryResource_Description() {
		return (EAttribute)memoryResourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMemoryResource_Size() {
		return (EAttribute)memoryResourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMemoryResource_Memory() {
		return (EReference)memoryResourceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMemory() {
		return memoryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMemory_Size() {
		return (EAttribute)memoryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getMemory_Descriptor() {
		return (EReference)memoryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getExecutionResource() {
		return executionResourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExecutionResource_CoreId() {
		return (EAttribute)executionResourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getExecutionResource_Fraction() {
		return (EAttribute)executionResourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getExecutionResource_Processor() {
		return (EReference)executionResourceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessor() {
		return processorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessor_Descriptor() {
		return (EReference)processorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessor_ClockFrequency() {
		return (EAttribute)processorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNetworkResource() {
		return networkResourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNetworkResource_Bandwidth() {
		return (EAttribute)networkResourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getNetworkResource_NetworkInterface() {
		return (EReference)networkResourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTargetEnvironment() {
		return targetEnvironmentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTargetEnvironment_Description() {
		return (EAttribute)targetEnvironmentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTargetEnvironment_Nodes() {
		return (EReference)targetEnvironmentEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTargetEnvironment_NetworkElements() {
		return (EReference)targetEnvironmentEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSoftwarePerformanceProfile() {
		return softwarePerformanceProfileEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSoftwarePerformanceProfile_SoftwareKind() {
		return (EAttribute)softwarePerformanceProfileEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSoftwarePerformanceProfile_ClocksPerInstructionAverage() {
		return (EAttribute)softwarePerformanceProfileEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSoftwarePerformanceProfile_ClocksPerInstructionDistribution() {
		return (EAttribute)softwarePerformanceProfileEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSoftwarePerformanceProfile_TlbMissProbability() {
		return (EAttribute)softwarePerformanceProfileEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getSoftwarePerformanceProfile_Processor() {
		return (EReference)softwarePerformanceProfileEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFileSystemPerformanceProfile() {
		return fileSystemPerformanceProfileEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFileSystemPerformanceProfile_StorageResource() {
		return (EReference)fileSystemPerformanceProfileEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFileSystemPerformanceProfile_FileSystem() {
		return (EAttribute)fileSystemPerformanceProfileEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getSchedulingPolicyKind() {
		return schedulingPolicyKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TargetenvironmentFactory getTargetenvironmentFactory() {
		return (TargetenvironmentFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		networkElementEClass = createEClass(NETWORK_ELEMENT);
		createEReference(networkElementEClass, NETWORK_ELEMENT__NODE_CONNECTIONS);
		createEReference(networkElementEClass, NETWORK_ELEMENT__DESCRIPTOR);
		createEReference(networkElementEClass, NETWORK_ELEMENT__DOWNLINKS);
		createEReference(networkElementEClass, NETWORK_ELEMENT__SIBLINGS);

		networkInterfaceEClass = createEClass(NETWORK_INTERFACE);
		createEAttribute(networkInterfaceEClass, NETWORK_INTERFACE__BANDWIDTH);
		createEReference(networkInterfaceEClass, NETWORK_INTERFACE__DESCRIPTOR);
		createEReference(networkInterfaceEClass, NETWORK_INTERFACE__CONNECTION);

		nodeEClass = createEClass(NODE);
		createEAttribute(nodeEClass, NODE__DESCRIPTION);
		createEReference(nodeEClass, NODE__CONTAINERS);
		createEReference(nodeEClass, NODE__PROCESSORS);
		createEReference(nodeEClass, NODE__MEMORIES);
		createEReference(nodeEClass, NODE__STORAGE_DEVICES);
		createEReference(nodeEClass, NODE__NETWORK_INTERFACES);

		containerEClass = createEClass(CONTAINER);
		createEAttribute(containerEClass, CONTAINER__SCHEDULING_POLICY);
		createEAttribute(containerEClass, CONTAINER__DESCRIPTION);
		createEReference(containerEClass, CONTAINER__STORAGE_RESOURCES);
		createEReference(containerEClass, CONTAINER__MEMORY_RESOURCES);
		createEReference(containerEClass, CONTAINER__EXECUTION_RESOURCES);
		createEReference(containerEClass, CONTAINER__NETWORK_RESOURCES);

		storageResourceEClass = createEClass(STORAGE_RESOURCE);
		createEAttribute(storageResourceEClass, STORAGE_RESOURCE__DESCRIPTION);
		createEReference(storageResourceEClass, STORAGE_RESOURCE__STORAGE_DEVICES);
		createEAttribute(storageResourceEClass, STORAGE_RESOURCE__SIZE);

		storageDeviceEClass = createEClass(STORAGE_DEVICE);
		createEReference(storageDeviceEClass, STORAGE_DEVICE__DESCRIPTOR);
		createEAttribute(storageDeviceEClass, STORAGE_DEVICE__SIZE);

		memoryResourceEClass = createEClass(MEMORY_RESOURCE);
		createEAttribute(memoryResourceEClass, MEMORY_RESOURCE__DESCRIPTION);
		createEAttribute(memoryResourceEClass, MEMORY_RESOURCE__SIZE);
		createEReference(memoryResourceEClass, MEMORY_RESOURCE__MEMORY);

		memoryEClass = createEClass(MEMORY);
		createEAttribute(memoryEClass, MEMORY__SIZE);
		createEReference(memoryEClass, MEMORY__DESCRIPTOR);

		executionResourceEClass = createEClass(EXECUTION_RESOURCE);
		createEAttribute(executionResourceEClass, EXECUTION_RESOURCE__CORE_ID);
		createEAttribute(executionResourceEClass, EXECUTION_RESOURCE__FRACTION);
		createEReference(executionResourceEClass, EXECUTION_RESOURCE__PROCESSOR);

		processorEClass = createEClass(PROCESSOR);
		createEReference(processorEClass, PROCESSOR__DESCRIPTOR);
		createEAttribute(processorEClass, PROCESSOR__CLOCK_FREQUENCY);

		networkResourceEClass = createEClass(NETWORK_RESOURCE);
		createEAttribute(networkResourceEClass, NETWORK_RESOURCE__BANDWIDTH);
		createEReference(networkResourceEClass, NETWORK_RESOURCE__NETWORK_INTERFACE);

		targetEnvironmentEClass = createEClass(TARGET_ENVIRONMENT);
		createEAttribute(targetEnvironmentEClass, TARGET_ENVIRONMENT__DESCRIPTION);
		createEReference(targetEnvironmentEClass, TARGET_ENVIRONMENT__NODES);
		createEReference(targetEnvironmentEClass, TARGET_ENVIRONMENT__NETWORK_ELEMENTS);

		softwarePerformanceProfileEClass = createEClass(SOFTWARE_PERFORMANCE_PROFILE);
		createEAttribute(softwarePerformanceProfileEClass, SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND);
		createEAttribute(softwarePerformanceProfileEClass, SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE);
		createEAttribute(softwarePerformanceProfileEClass, SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION);
		createEAttribute(softwarePerformanceProfileEClass, SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY);
		createEReference(softwarePerformanceProfileEClass, SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR);

		fileSystemPerformanceProfileEClass = createEClass(FILE_SYSTEM_PERFORMANCE_PROFILE);
		createEReference(fileSystemPerformanceProfileEClass, FILE_SYSTEM_PERFORMANCE_PROFILE__STORAGE_RESOURCE);
		createEAttribute(fileSystemPerformanceProfileEClass, FILE_SYSTEM_PERFORMANCE_PROFILE__FILE_SYSTEM);

		// Create enums
		schedulingPolicyKindEEnum = createEEnum(SCHEDULING_POLICY_KIND);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		CorePackage theCorePackage = (CorePackage)EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI);
		HardwarePackage theHardwarePackage = (HardwarePackage)EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI);
		AnnotationPackage theAnnotationPackage = (AnnotationPackage)EPackage.Registry.INSTANCE.getEPackage(AnnotationPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		networkElementEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		networkInterfaceEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		nodeEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		containerEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		storageResourceEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		storageDeviceEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		memoryResourceEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		memoryEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		processorEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		networkResourceEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		targetEnvironmentEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		softwarePerformanceProfileEClass.getESuperTypes().add(theAnnotationPackage.getAnnotation());
		fileSystemPerformanceProfileEClass.getESuperTypes().add(theAnnotationPackage.getAnnotation());

		// Initialize classes and features; add operations and parameters
		initEClass(networkElementEClass, NetworkElement.class, "NetworkElement", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getNetworkElement_NodeConnections(), this.getNetworkInterface(), this.getNetworkInterface_Connection(), "nodeConnections", null, 0, -1, NetworkElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNetworkElement_Descriptor(), theHardwarePackage.getNetworkElementDescriptor(), null, "descriptor", null, 1, 1, NetworkElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNetworkElement_Downlinks(), this.getNetworkElement(), null, "downlinks", null, 0, -1, NetworkElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNetworkElement_Siblings(), this.getNetworkElement(), null, "siblings", null, 0, -1, NetworkElement.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(networkInterfaceEClass, NetworkInterface.class, "NetworkInterface", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNetworkInterface_Bandwidth(), ecorePackage.getEInt(), "bandwidth", null, 1, 1, NetworkInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNetworkInterface_Descriptor(), theHardwarePackage.getNetworkInterfaceDescriptor(), null, "descriptor", null, 1, 1, NetworkInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNetworkInterface_Connection(), this.getNetworkElement(), this.getNetworkElement_NodeConnections(), "connection", null, 1, 1, NetworkInterface.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(nodeEClass, Node.class, "Node", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNode_Description(), ecorePackage.getEString(), "description", null, 0, 1, Node.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNode_Containers(), this.getContainer(), null, "containers", null, 1, -1, Node.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNode_Processors(), this.getProcessor(), null, "processors", null, 1, -1, Node.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNode_Memories(), this.getMemory(), null, "memories", null, 1, -1, Node.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNode_StorageDevices(), this.getStorageDevice(), null, "storageDevices", null, 0, -1, Node.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNode_NetworkInterfaces(), this.getNetworkInterface(), null, "networkInterfaces", null, 0, -1, Node.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(containerEClass, eu.qimpress.samm.deployment.targetenvironment.Container.class, "Container", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContainer_SchedulingPolicy(), this.getSchedulingPolicyKind(), "schedulingPolicy", null, 0, 1, eu.qimpress.samm.deployment.targetenvironment.Container.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getContainer_Description(), ecorePackage.getEString(), "description", null, 0, 1, eu.qimpress.samm.deployment.targetenvironment.Container.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getContainer_StorageResources(), this.getStorageResource(), null, "storageResources", null, 0, -1, eu.qimpress.samm.deployment.targetenvironment.Container.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getContainer_MemoryResources(), this.getMemoryResource(), null, "memoryResources", null, 1, -1, eu.qimpress.samm.deployment.targetenvironment.Container.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getContainer_ExecutionResources(), this.getExecutionResource(), null, "executionResources", null, 1, -1, eu.qimpress.samm.deployment.targetenvironment.Container.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getContainer_NetworkResources(), this.getNetworkResource(), null, "networkResources", null, 0, -1, eu.qimpress.samm.deployment.targetenvironment.Container.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(storageResourceEClass, StorageResource.class, "StorageResource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStorageResource_Description(), ecorePackage.getEString(), "description", null, 0, 1, StorageResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getStorageResource_StorageDevices(), this.getStorageDevice(), null, "storageDevices", null, 1, -1, StorageResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getStorageResource_Size(), ecorePackage.getEInt(), "size", null, 1, 1, StorageResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(storageDeviceEClass, StorageDevice.class, "StorageDevice", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getStorageDevice_Descriptor(), theHardwarePackage.getStorageDeviceDescriptor(), null, "descriptor", null, 1, 1, StorageDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getStorageDevice_Size(), ecorePackage.getEInt(), "size", null, 1, 1, StorageDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(memoryResourceEClass, MemoryResource.class, "MemoryResource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMemoryResource_Description(), ecorePackage.getEString(), "description", null, 0, 1, MemoryResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getMemoryResource_Size(), ecorePackage.getEInt(), "size", null, 1, 1, MemoryResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getMemoryResource_Memory(), this.getMemory(), null, "memory", null, 1, 1, MemoryResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(memoryEClass, Memory.class, "Memory", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMemory_Size(), ecorePackage.getEInt(), "size", null, 1, 1, Memory.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getMemory_Descriptor(), theHardwarePackage.getMemoryDescriptor(), null, "descriptor", null, 1, 1, Memory.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(executionResourceEClass, ExecutionResource.class, "ExecutionResource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getExecutionResource_CoreId(), ecorePackage.getEInt(), "coreId", null, 1, 1, ExecutionResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getExecutionResource_Fraction(), ecorePackage.getEDouble(), "fraction", null, 1, 1, ExecutionResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getExecutionResource_Processor(), this.getProcessor(), null, "processor", null, 1, 1, ExecutionResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(processorEClass, Processor.class, "Processor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProcessor_Descriptor(), theHardwarePackage.getProcessorDescriptor(), null, "descriptor", null, 1, 1, Processor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getProcessor_ClockFrequency(), ecorePackage.getEDouble(), "clockFrequency", null, 0, 1, Processor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(networkResourceEClass, NetworkResource.class, "NetworkResource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNetworkResource_Bandwidth(), ecorePackage.getEInt(), "bandwidth", null, 1, 1, NetworkResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getNetworkResource_NetworkInterface(), this.getNetworkInterface(), null, "networkInterface", null, 1, 1, NetworkResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(targetEnvironmentEClass, TargetEnvironment.class, "TargetEnvironment", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTargetEnvironment_Description(), ecorePackage.getEString(), "description", null, 0, 1, TargetEnvironment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getTargetEnvironment_Nodes(), this.getNode(), null, "nodes", null, 0, -1, TargetEnvironment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getTargetEnvironment_NetworkElements(), this.getNetworkElement(), null, "networkElements", null, 0, -1, TargetEnvironment.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(softwarePerformanceProfileEClass, SoftwarePerformanceProfile.class, "SoftwarePerformanceProfile", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSoftwarePerformanceProfile_SoftwareKind(), ecorePackage.getEString(), "softwareKind", null, 1, 1, SoftwarePerformanceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getSoftwarePerformanceProfile_ClocksPerInstructionAverage(), ecorePackage.getEDouble(), "clocksPerInstructionAverage", "0", 0, 1, SoftwarePerformanceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getSoftwarePerformanceProfile_ClocksPerInstructionDistribution(), ecorePackage.getEString(), "clocksPerInstructionDistribution", null, 0, 1, SoftwarePerformanceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getSoftwarePerformanceProfile_TlbMissProbability(), ecorePackage.getEDouble(), "tlbMissProbability", "0", 0, 1, SoftwarePerformanceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getSoftwarePerformanceProfile_Processor(), theHardwarePackage.getProcessorDescriptor(), null, "processor", null, 1, 1, SoftwarePerformanceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(fileSystemPerformanceProfileEClass, FileSystemPerformanceProfile.class, "FileSystemPerformanceProfile", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getFileSystemPerformanceProfile_StorageResource(), this.getStorageResource(), null, "storageResource", null, 1, 1, FileSystemPerformanceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getFileSystemPerformanceProfile_FileSystem(), ecorePackage.getEString(), "fileSystem", null, 0, 1, FileSystemPerformanceProfile.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(schedulingPolicyKindEEnum, SchedulingPolicyKind.class, "SchedulingPolicyKind");
		addEEnumLiteral(schedulingPolicyKindEEnum, SchedulingPolicyKind.FIRST_COME_FIRST_SERVED);
		addEEnumLiteral(schedulingPolicyKindEEnum, SchedulingPolicyKind.PROCESSOR_SHARING);
		addEEnumLiteral(schedulingPolicyKindEEnum, SchedulingPolicyKind.DELAY);

		// Create resource
		createResource(eNS_URI);
	}

} //TargetenvironmentPackageImpl
