/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.qimpress.samm.annotation.impl.AnnotationImpl;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Software Performance Profile</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl#getSoftwareKind <em>Software Kind</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl#getClocksPerInstructionAverage <em>Clocks Per Instruction Average</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl#getClocksPerInstructionDistribution <em>Clocks Per Instruction Distribution</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl#getTlbMissProbability <em>Tlb Miss Probability</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl#getProcessor <em>Processor</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SoftwarePerformanceProfileImpl extends AnnotationImpl implements SoftwarePerformanceProfile {
	/**
	 * The default value of the '{@link #getSoftwareKind() <em>Software Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSoftwareKind()
	 * @generated
	 * @ordered
	 */
	protected static final String SOFTWARE_KIND_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSoftwareKind() <em>Software Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSoftwareKind()
	 * @generated
	 * @ordered
	 */
	protected String softwareKind = SOFTWARE_KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #getClocksPerInstructionAverage() <em>Clocks Per Instruction Average</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClocksPerInstructionAverage()
	 * @generated
	 * @ordered
	 */
	protected static final double CLOCKS_PER_INSTRUCTION_AVERAGE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getClocksPerInstructionAverage() <em>Clocks Per Instruction Average</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClocksPerInstructionAverage()
	 * @generated
	 * @ordered
	 */
	protected double clocksPerInstructionAverage = CLOCKS_PER_INSTRUCTION_AVERAGE_EDEFAULT;

	/**
	 * The default value of the '{@link #getClocksPerInstructionDistribution() <em>Clocks Per Instruction Distribution</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClocksPerInstructionDistribution()
	 * @generated
	 * @ordered
	 */
	protected static final String CLOCKS_PER_INSTRUCTION_DISTRIBUTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getClocksPerInstructionDistribution() <em>Clocks Per Instruction Distribution</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClocksPerInstructionDistribution()
	 * @generated
	 * @ordered
	 */
	protected String clocksPerInstructionDistribution = CLOCKS_PER_INSTRUCTION_DISTRIBUTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getTlbMissProbability() <em>Tlb Miss Probability</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTlbMissProbability()
	 * @generated
	 * @ordered
	 */
	protected static final double TLB_MISS_PROBABILITY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTlbMissProbability() <em>Tlb Miss Probability</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTlbMissProbability()
	 * @generated
	 * @ordered
	 */
	protected double tlbMissProbability = TLB_MISS_PROBABILITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getProcessor() <em>Processor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessor()
	 * @generated
	 * @ordered
	 */
	protected ProcessorDescriptor processor;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SoftwarePerformanceProfileImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TargetenvironmentPackage.Literals.SOFTWARE_PERFORMANCE_PROFILE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSoftwareKind() {
		return softwareKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSoftwareKind(String newSoftwareKind) {
		String oldSoftwareKind = softwareKind;
		softwareKind = newSoftwareKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND, oldSoftwareKind, softwareKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getClocksPerInstructionAverage() {
		return clocksPerInstructionAverage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClocksPerInstructionAverage(double newClocksPerInstructionAverage) {
		double oldClocksPerInstructionAverage = clocksPerInstructionAverage;
		clocksPerInstructionAverage = newClocksPerInstructionAverage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE, oldClocksPerInstructionAverage, clocksPerInstructionAverage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getClocksPerInstructionDistribution() {
		return clocksPerInstructionDistribution;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClocksPerInstructionDistribution(String newClocksPerInstructionDistribution) {
		String oldClocksPerInstructionDistribution = clocksPerInstructionDistribution;
		clocksPerInstructionDistribution = newClocksPerInstructionDistribution;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION, oldClocksPerInstructionDistribution, clocksPerInstructionDistribution));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTlbMissProbability() {
		return tlbMissProbability;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTlbMissProbability(double newTlbMissProbability) {
		double oldTlbMissProbability = tlbMissProbability;
		tlbMissProbability = newTlbMissProbability;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY, oldTlbMissProbability, tlbMissProbability));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessorDescriptor getProcessor() {
		if (processor != null && processor.eIsProxy()) {
			InternalEObject oldProcessor = (InternalEObject)processor;
			processor = (ProcessorDescriptor)eResolveProxy(oldProcessor);
			if (processor != oldProcessor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR, oldProcessor, processor));
			}
		}
		return processor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessorDescriptor basicGetProcessor() {
		return processor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcessor(ProcessorDescriptor newProcessor) {
		ProcessorDescriptor oldProcessor = processor;
		processor = newProcessor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR, oldProcessor, processor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND:
				return getSoftwareKind();
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE:
				return getClocksPerInstructionAverage();
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION:
				return getClocksPerInstructionDistribution();
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY:
				return getTlbMissProbability();
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR:
				if (resolve) return getProcessor();
				return basicGetProcessor();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND:
				setSoftwareKind((String)newValue);
				return;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE:
				setClocksPerInstructionAverage((Double)newValue);
				return;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION:
				setClocksPerInstructionDistribution((String)newValue);
				return;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY:
				setTlbMissProbability((Double)newValue);
				return;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR:
				setProcessor((ProcessorDescriptor)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND:
				setSoftwareKind(SOFTWARE_KIND_EDEFAULT);
				return;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE:
				setClocksPerInstructionAverage(CLOCKS_PER_INSTRUCTION_AVERAGE_EDEFAULT);
				return;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION:
				setClocksPerInstructionDistribution(CLOCKS_PER_INSTRUCTION_DISTRIBUTION_EDEFAULT);
				return;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY:
				setTlbMissProbability(TLB_MISS_PROBABILITY_EDEFAULT);
				return;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR:
				setProcessor((ProcessorDescriptor)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND:
				return SOFTWARE_KIND_EDEFAULT == null ? softwareKind != null : !SOFTWARE_KIND_EDEFAULT.equals(softwareKind);
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE:
				return clocksPerInstructionAverage != CLOCKS_PER_INSTRUCTION_AVERAGE_EDEFAULT;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION:
				return CLOCKS_PER_INSTRUCTION_DISTRIBUTION_EDEFAULT == null ? clocksPerInstructionDistribution != null : !CLOCKS_PER_INSTRUCTION_DISTRIBUTION_EDEFAULT.equals(clocksPerInstructionDistribution);
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY:
				return tlbMissProbability != TLB_MISS_PROBABILITY_EDEFAULT;
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR:
				return processor != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (softwareKind: ");
		result.append(softwareKind);
		result.append(", clocksPerInstructionAverage: ");
		result.append(clocksPerInstructionAverage);
		result.append(", clocksPerInstructionDistribution: ");
		result.append(clocksPerInstructionDistribution);
		result.append(", tlbMissProbability: ");
		result.append(tlbMissProbability);
		result.append(')');
		return result.toString();
	}

} //SoftwarePerformanceProfileImpl
