/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.qimpress.samm.core.impl.NamedEntityImpl;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.Memory;
import eu.qimpress.samm.deployment.targetenvironment.NetworkInterface;
import eu.qimpress.samm.deployment.targetenvironment.Node;
import eu.qimpress.samm.deployment.targetenvironment.Processor;
import eu.qimpress.samm.deployment.targetenvironment.StorageDevice;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl#getContainers <em>Containers</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl#getProcessors <em>Processors</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl#getMemories <em>Memories</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl#getStorageDevices <em>Storage Devices</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl#getNetworkInterfaces <em>Network Interfaces</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NodeImpl extends NamedEntityImpl implements Node {
	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContainers() <em>Containers</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContainers()
	 * @generated
	 * @ordered
	 */
	protected EList<Container> containers;

	/**
	 * The cached value of the '{@link #getProcessors() <em>Processors</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessors()
	 * @generated
	 * @ordered
	 */
	protected EList<Processor> processors;

	/**
	 * The cached value of the '{@link #getMemories() <em>Memories</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMemories()
	 * @generated
	 * @ordered
	 */
	protected EList<Memory> memories;

	/**
	 * The cached value of the '{@link #getStorageDevices() <em>Storage Devices</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStorageDevices()
	 * @generated
	 * @ordered
	 */
	protected EList<StorageDevice> storageDevices;

	/**
	 * The cached value of the '{@link #getNetworkInterfaces() <em>Network Interfaces</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNetworkInterfaces()
	 * @generated
	 * @ordered
	 */
	protected EList<NetworkInterface> networkInterfaces;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NodeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TargetenvironmentPackage.Literals.NODE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.NODE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Container> getContainers() {
		if (containers == null) {
			containers = new EObjectContainmentEList<Container>(Container.class, this, TargetenvironmentPackage.NODE__CONTAINERS);
		}
		return containers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Processor> getProcessors() {
		if (processors == null) {
			processors = new EObjectContainmentEList<Processor>(Processor.class, this, TargetenvironmentPackage.NODE__PROCESSORS);
		}
		return processors;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Memory> getMemories() {
		if (memories == null) {
			memories = new EObjectContainmentEList<Memory>(Memory.class, this, TargetenvironmentPackage.NODE__MEMORIES);
		}
		return memories;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<StorageDevice> getStorageDevices() {
		if (storageDevices == null) {
			storageDevices = new EObjectContainmentEList<StorageDevice>(StorageDevice.class, this, TargetenvironmentPackage.NODE__STORAGE_DEVICES);
		}
		return storageDevices;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<NetworkInterface> getNetworkInterfaces() {
		if (networkInterfaces == null) {
			networkInterfaces = new EObjectContainmentEList<NetworkInterface>(NetworkInterface.class, this, TargetenvironmentPackage.NODE__NETWORK_INTERFACES);
		}
		return networkInterfaces;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TargetenvironmentPackage.NODE__CONTAINERS:
				return ((InternalEList<?>)getContainers()).basicRemove(otherEnd, msgs);
			case TargetenvironmentPackage.NODE__PROCESSORS:
				return ((InternalEList<?>)getProcessors()).basicRemove(otherEnd, msgs);
			case TargetenvironmentPackage.NODE__MEMORIES:
				return ((InternalEList<?>)getMemories()).basicRemove(otherEnd, msgs);
			case TargetenvironmentPackage.NODE__STORAGE_DEVICES:
				return ((InternalEList<?>)getStorageDevices()).basicRemove(otherEnd, msgs);
			case TargetenvironmentPackage.NODE__NETWORK_INTERFACES:
				return ((InternalEList<?>)getNetworkInterfaces()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TargetenvironmentPackage.NODE__DESCRIPTION:
				return getDescription();
			case TargetenvironmentPackage.NODE__CONTAINERS:
				return getContainers();
			case TargetenvironmentPackage.NODE__PROCESSORS:
				return getProcessors();
			case TargetenvironmentPackage.NODE__MEMORIES:
				return getMemories();
			case TargetenvironmentPackage.NODE__STORAGE_DEVICES:
				return getStorageDevices();
			case TargetenvironmentPackage.NODE__NETWORK_INTERFACES:
				return getNetworkInterfaces();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TargetenvironmentPackage.NODE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case TargetenvironmentPackage.NODE__CONTAINERS:
				getContainers().clear();
				getContainers().addAll((Collection<? extends Container>)newValue);
				return;
			case TargetenvironmentPackage.NODE__PROCESSORS:
				getProcessors().clear();
				getProcessors().addAll((Collection<? extends Processor>)newValue);
				return;
			case TargetenvironmentPackage.NODE__MEMORIES:
				getMemories().clear();
				getMemories().addAll((Collection<? extends Memory>)newValue);
				return;
			case TargetenvironmentPackage.NODE__STORAGE_DEVICES:
				getStorageDevices().clear();
				getStorageDevices().addAll((Collection<? extends StorageDevice>)newValue);
				return;
			case TargetenvironmentPackage.NODE__NETWORK_INTERFACES:
				getNetworkInterfaces().clear();
				getNetworkInterfaces().addAll((Collection<? extends NetworkInterface>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TargetenvironmentPackage.NODE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case TargetenvironmentPackage.NODE__CONTAINERS:
				getContainers().clear();
				return;
			case TargetenvironmentPackage.NODE__PROCESSORS:
				getProcessors().clear();
				return;
			case TargetenvironmentPackage.NODE__MEMORIES:
				getMemories().clear();
				return;
			case TargetenvironmentPackage.NODE__STORAGE_DEVICES:
				getStorageDevices().clear();
				return;
			case TargetenvironmentPackage.NODE__NETWORK_INTERFACES:
				getNetworkInterfaces().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TargetenvironmentPackage.NODE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case TargetenvironmentPackage.NODE__CONTAINERS:
				return containers != null && !containers.isEmpty();
			case TargetenvironmentPackage.NODE__PROCESSORS:
				return processors != null && !processors.isEmpty();
			case TargetenvironmentPackage.NODE__MEMORIES:
				return memories != null && !memories.isEmpty();
			case TargetenvironmentPackage.NODE__STORAGE_DEVICES:
				return storageDevices != null && !storageDevices.isEmpty();
			case TargetenvironmentPackage.NODE__NETWORK_INTERFACES:
				return networkInterfaces != null && !networkInterfaces.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (description: ");
		result.append(description);
		result.append(')');
		return result.toString();
	}

} //NodeImpl
