/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.qimpress.samm.core.impl.NamedEntityImpl;
import eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor;
import eu.qimpress.samm.deployment.targetenvironment.NetworkElement;
import eu.qimpress.samm.deployment.targetenvironment.NetworkInterface;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Network Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkElementImpl#getNodeConnections <em>Node Connections</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkElementImpl#getDescriptor <em>Descriptor</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkElementImpl#getDownlinks <em>Downlinks</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkElementImpl#getSiblings <em>Siblings</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NetworkElementImpl extends NamedEntityImpl implements NetworkElement {
	/**
	 * The cached value of the '{@link #getNodeConnections() <em>Node Connections</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNodeConnections()
	 * @generated
	 * @ordered
	 */
	protected EList<NetworkInterface> nodeConnections;

	/**
	 * The cached value of the '{@link #getDescriptor() <em>Descriptor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescriptor()
	 * @generated
	 * @ordered
	 */
	protected NetworkElementDescriptor descriptor;

	/**
	 * The cached value of the '{@link #getDownlinks() <em>Downlinks</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDownlinks()
	 * @generated
	 * @ordered
	 */
	protected EList<NetworkElement> downlinks;

	/**
	 * The cached value of the '{@link #getSiblings() <em>Siblings</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSiblings()
	 * @generated
	 * @ordered
	 */
	protected EList<NetworkElement> siblings;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkElementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TargetenvironmentPackage.Literals.NETWORK_ELEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<NetworkInterface> getNodeConnections() {
		if (nodeConnections == null) {
			nodeConnections = new EObjectWithInverseResolvingEList<NetworkInterface>(NetworkInterface.class, this, TargetenvironmentPackage.NETWORK_ELEMENT__NODE_CONNECTIONS, TargetenvironmentPackage.NETWORK_INTERFACE__CONNECTION);
		}
		return nodeConnections;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NetworkElementDescriptor getDescriptor() {
		if (descriptor != null && descriptor.eIsProxy()) {
			InternalEObject oldDescriptor = (InternalEObject)descriptor;
			descriptor = (NetworkElementDescriptor)eResolveProxy(oldDescriptor);
			if (descriptor != oldDescriptor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TargetenvironmentPackage.NETWORK_ELEMENT__DESCRIPTOR, oldDescriptor, descriptor));
			}
		}
		return descriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NetworkElementDescriptor basicGetDescriptor() {
		return descriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescriptor(NetworkElementDescriptor newDescriptor) {
		NetworkElementDescriptor oldDescriptor = descriptor;
		descriptor = newDescriptor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.NETWORK_ELEMENT__DESCRIPTOR, oldDescriptor, descriptor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<NetworkElement> getDownlinks() {
		if (downlinks == null) {
			downlinks = new EObjectResolvingEList<NetworkElement>(NetworkElement.class, this, TargetenvironmentPackage.NETWORK_ELEMENT__DOWNLINKS);
		}
		return downlinks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<NetworkElement> getSiblings() {
		if (siblings == null) {
			siblings = new EObjectResolvingEList<NetworkElement>(NetworkElement.class, this, TargetenvironmentPackage.NETWORK_ELEMENT__SIBLINGS);
		}
		return siblings;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TargetenvironmentPackage.NETWORK_ELEMENT__NODE_CONNECTIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getNodeConnections()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TargetenvironmentPackage.NETWORK_ELEMENT__NODE_CONNECTIONS:
				return ((InternalEList<?>)getNodeConnections()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TargetenvironmentPackage.NETWORK_ELEMENT__NODE_CONNECTIONS:
				return getNodeConnections();
			case TargetenvironmentPackage.NETWORK_ELEMENT__DESCRIPTOR:
				if (resolve) return getDescriptor();
				return basicGetDescriptor();
			case TargetenvironmentPackage.NETWORK_ELEMENT__DOWNLINKS:
				return getDownlinks();
			case TargetenvironmentPackage.NETWORK_ELEMENT__SIBLINGS:
				return getSiblings();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TargetenvironmentPackage.NETWORK_ELEMENT__NODE_CONNECTIONS:
				getNodeConnections().clear();
				getNodeConnections().addAll((Collection<? extends NetworkInterface>)newValue);
				return;
			case TargetenvironmentPackage.NETWORK_ELEMENT__DESCRIPTOR:
				setDescriptor((NetworkElementDescriptor)newValue);
				return;
			case TargetenvironmentPackage.NETWORK_ELEMENT__DOWNLINKS:
				getDownlinks().clear();
				getDownlinks().addAll((Collection<? extends NetworkElement>)newValue);
				return;
			case TargetenvironmentPackage.NETWORK_ELEMENT__SIBLINGS:
				getSiblings().clear();
				getSiblings().addAll((Collection<? extends NetworkElement>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TargetenvironmentPackage.NETWORK_ELEMENT__NODE_CONNECTIONS:
				getNodeConnections().clear();
				return;
			case TargetenvironmentPackage.NETWORK_ELEMENT__DESCRIPTOR:
				setDescriptor((NetworkElementDescriptor)null);
				return;
			case TargetenvironmentPackage.NETWORK_ELEMENT__DOWNLINKS:
				getDownlinks().clear();
				return;
			case TargetenvironmentPackage.NETWORK_ELEMENT__SIBLINGS:
				getSiblings().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TargetenvironmentPackage.NETWORK_ELEMENT__NODE_CONNECTIONS:
				return nodeConnections != null && !nodeConnections.isEmpty();
			case TargetenvironmentPackage.NETWORK_ELEMENT__DESCRIPTOR:
				return descriptor != null;
			case TargetenvironmentPackage.NETWORK_ELEMENT__DOWNLINKS:
				return downlinks != null && !downlinks.isEmpty();
			case TargetenvironmentPackage.NETWORK_ELEMENT__SIBLINGS:
				return siblings != null && !siblings.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //NetworkElementImpl
