/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.qimpress.samm.core.impl.NamedEntityImpl;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.ExecutionResource;
import eu.qimpress.samm.deployment.targetenvironment.MemoryResource;
import eu.qimpress.samm.deployment.targetenvironment.NetworkResource;
import eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind;
import eu.qimpress.samm.deployment.targetenvironment.StorageResource;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Container</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl#getSchedulingPolicy <em>Scheduling Policy</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl#getStorageResources <em>Storage Resources</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl#getMemoryResources <em>Memory Resources</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl#getExecutionResources <em>Execution Resources</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl#getNetworkResources <em>Network Resources</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ContainerImpl extends NamedEntityImpl implements Container {
	/**
	 * The default value of the '{@link #getSchedulingPolicy() <em>Scheduling Policy</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSchedulingPolicy()
	 * @generated
	 * @ordered
	 */
	protected static final SchedulingPolicyKind SCHEDULING_POLICY_EDEFAULT = SchedulingPolicyKind.FIRST_COME_FIRST_SERVED;

	/**
	 * The cached value of the '{@link #getSchedulingPolicy() <em>Scheduling Policy</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSchedulingPolicy()
	 * @generated
	 * @ordered
	 */
	protected SchedulingPolicyKind schedulingPolicy = SCHEDULING_POLICY_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getStorageResources() <em>Storage Resources</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStorageResources()
	 * @generated
	 * @ordered
	 */
	protected EList<StorageResource> storageResources;

	/**
	 * The cached value of the '{@link #getMemoryResources() <em>Memory Resources</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMemoryResources()
	 * @generated
	 * @ordered
	 */
	protected EList<MemoryResource> memoryResources;

	/**
	 * The cached value of the '{@link #getExecutionResources() <em>Execution Resources</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExecutionResources()
	 * @generated
	 * @ordered
	 */
	protected EList<ExecutionResource> executionResources;

	/**
	 * The cached value of the '{@link #getNetworkResources() <em>Network Resources</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNetworkResources()
	 * @generated
	 * @ordered
	 */
	protected EList<NetworkResource> networkResources;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContainerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TargetenvironmentPackage.Literals.CONTAINER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.CONTAINER__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<StorageResource> getStorageResources() {
		if (storageResources == null) {
			storageResources = new EObjectContainmentEList<StorageResource>(StorageResource.class, this, TargetenvironmentPackage.CONTAINER__STORAGE_RESOURCES);
		}
		return storageResources;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MemoryResource> getMemoryResources() {
		if (memoryResources == null) {
			memoryResources = new EObjectContainmentEList<MemoryResource>(MemoryResource.class, this, TargetenvironmentPackage.CONTAINER__MEMORY_RESOURCES);
		}
		return memoryResources;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ExecutionResource> getExecutionResources() {
		if (executionResources == null) {
			executionResources = new EObjectContainmentEList<ExecutionResource>(ExecutionResource.class, this, TargetenvironmentPackage.CONTAINER__EXECUTION_RESOURCES);
		}
		return executionResources;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SchedulingPolicyKind getSchedulingPolicy() {
		return schedulingPolicy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSchedulingPolicy(SchedulingPolicyKind newSchedulingPolicy) {
		SchedulingPolicyKind oldSchedulingPolicy = schedulingPolicy;
		schedulingPolicy = newSchedulingPolicy == null ? SCHEDULING_POLICY_EDEFAULT : newSchedulingPolicy;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TargetenvironmentPackage.CONTAINER__SCHEDULING_POLICY, oldSchedulingPolicy, schedulingPolicy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<NetworkResource> getNetworkResources() {
		if (networkResources == null) {
			networkResources = new EObjectContainmentEList<NetworkResource>(NetworkResource.class, this, TargetenvironmentPackage.CONTAINER__NETWORK_RESOURCES);
		}
		return networkResources;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case TargetenvironmentPackage.CONTAINER__STORAGE_RESOURCES:
				return ((InternalEList<?>)getStorageResources()).basicRemove(otherEnd, msgs);
			case TargetenvironmentPackage.CONTAINER__MEMORY_RESOURCES:
				return ((InternalEList<?>)getMemoryResources()).basicRemove(otherEnd, msgs);
			case TargetenvironmentPackage.CONTAINER__EXECUTION_RESOURCES:
				return ((InternalEList<?>)getExecutionResources()).basicRemove(otherEnd, msgs);
			case TargetenvironmentPackage.CONTAINER__NETWORK_RESOURCES:
				return ((InternalEList<?>)getNetworkResources()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TargetenvironmentPackage.CONTAINER__SCHEDULING_POLICY:
				return getSchedulingPolicy();
			case TargetenvironmentPackage.CONTAINER__DESCRIPTION:
				return getDescription();
			case TargetenvironmentPackage.CONTAINER__STORAGE_RESOURCES:
				return getStorageResources();
			case TargetenvironmentPackage.CONTAINER__MEMORY_RESOURCES:
				return getMemoryResources();
			case TargetenvironmentPackage.CONTAINER__EXECUTION_RESOURCES:
				return getExecutionResources();
			case TargetenvironmentPackage.CONTAINER__NETWORK_RESOURCES:
				return getNetworkResources();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TargetenvironmentPackage.CONTAINER__SCHEDULING_POLICY:
				setSchedulingPolicy((SchedulingPolicyKind)newValue);
				return;
			case TargetenvironmentPackage.CONTAINER__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case TargetenvironmentPackage.CONTAINER__STORAGE_RESOURCES:
				getStorageResources().clear();
				getStorageResources().addAll((Collection<? extends StorageResource>)newValue);
				return;
			case TargetenvironmentPackage.CONTAINER__MEMORY_RESOURCES:
				getMemoryResources().clear();
				getMemoryResources().addAll((Collection<? extends MemoryResource>)newValue);
				return;
			case TargetenvironmentPackage.CONTAINER__EXECUTION_RESOURCES:
				getExecutionResources().clear();
				getExecutionResources().addAll((Collection<? extends ExecutionResource>)newValue);
				return;
			case TargetenvironmentPackage.CONTAINER__NETWORK_RESOURCES:
				getNetworkResources().clear();
				getNetworkResources().addAll((Collection<? extends NetworkResource>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TargetenvironmentPackage.CONTAINER__SCHEDULING_POLICY:
				setSchedulingPolicy(SCHEDULING_POLICY_EDEFAULT);
				return;
			case TargetenvironmentPackage.CONTAINER__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case TargetenvironmentPackage.CONTAINER__STORAGE_RESOURCES:
				getStorageResources().clear();
				return;
			case TargetenvironmentPackage.CONTAINER__MEMORY_RESOURCES:
				getMemoryResources().clear();
				return;
			case TargetenvironmentPackage.CONTAINER__EXECUTION_RESOURCES:
				getExecutionResources().clear();
				return;
			case TargetenvironmentPackage.CONTAINER__NETWORK_RESOURCES:
				getNetworkResources().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TargetenvironmentPackage.CONTAINER__SCHEDULING_POLICY:
				return schedulingPolicy != SCHEDULING_POLICY_EDEFAULT;
			case TargetenvironmentPackage.CONTAINER__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case TargetenvironmentPackage.CONTAINER__STORAGE_RESOURCES:
				return storageResources != null && !storageResources.isEmpty();
			case TargetenvironmentPackage.CONTAINER__MEMORY_RESOURCES:
				return memoryResources != null && !memoryResources.isEmpty();
			case TargetenvironmentPackage.CONTAINER__EXECUTION_RESOURCES:
				return executionResources != null && !executionResources.isEmpty();
			case TargetenvironmentPackage.CONTAINER__NETWORK_RESOURCES:
				return networkResources != null && !networkResources.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (schedulingPolicy: ");
		result.append(schedulingPolicy);
		result.append(", description: ");
		result.append(description);
		result.append(')');
		return result.toString();
	}

} //ContainerImpl
