/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import eu.qimpress.samm.annotation.AnnotationPackage;
import eu.qimpress.samm.core.CorePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The TargetEnvironment package specifies hardware and software resources of nodes used as allocation target for Services. It supports modelling of processors, storage devices, network links, and main memory.
 * <!-- end-model-doc -->
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentFactory
 * @model kind="package"
 * @generated
 */
public interface TargetenvironmentPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "targetenvironment";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://q-impress.eu/samm/deployment/targetenvironment";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "targetenvironment";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	TargetenvironmentPackage eINSTANCE = eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl.init();

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkElementImpl <em>Network Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.NetworkElementImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getNetworkElement()
	 * @generated
	 */
	int NETWORK_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Node Connections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT__NODE_CONNECTIONS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT__DESCRIPTOR = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Downlinks</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT__DOWNLINKS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Siblings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT__SIBLINGS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Network Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkInterfaceImpl <em>Network Interface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.NetworkInterfaceImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getNetworkInterface()
	 * @generated
	 */
	int NETWORK_INTERFACE = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Bandwidth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE__BANDWIDTH = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE__DESCRIPTOR = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Connection</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE__CONNECTION = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Network Interface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl <em>Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getNode()
	 * @generated
	 */
	int NODE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__DESCRIPTION = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Containers</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__CONTAINERS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Processors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__PROCESSORS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Memories</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__MEMORIES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Storage Devices</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__STORAGE_DEVICES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Network Interfaces</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE__NETWORK_INTERFACES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NODE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl <em>Container</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getContainer()
	 * @generated
	 */
	int CONTAINER = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Scheduling Policy</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__SCHEDULING_POLICY = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__DESCRIPTION = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Storage Resources</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__STORAGE_RESOURCES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Memory Resources</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__MEMORY_RESOURCES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Execution Resources</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__EXECUTION_RESOURCES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Network Resources</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER__NETWORK_RESOURCES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Container</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTAINER_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.StorageResourceImpl <em>Storage Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.StorageResourceImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getStorageResource()
	 * @generated
	 */
	int STORAGE_RESOURCE = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_RESOURCE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_RESOURCE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_RESOURCE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_RESOURCE__DESCRIPTION = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Storage Devices</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_RESOURCE__STORAGE_DEVICES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_RESOURCE__SIZE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Storage Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_RESOURCE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.StorageDeviceImpl <em>Storage Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.StorageDeviceImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getStorageDevice()
	 * @generated
	 */
	int STORAGE_DEVICE = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE__DESCRIPTOR = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE__SIZE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Storage Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.MemoryResourceImpl <em>Memory Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.MemoryResourceImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getMemoryResource()
	 * @generated
	 */
	int MEMORY_RESOURCE = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_RESOURCE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_RESOURCE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_RESOURCE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_RESOURCE__DESCRIPTION = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_RESOURCE__SIZE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Memory</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_RESOURCE__MEMORY = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Memory Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_RESOURCE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.MemoryImpl <em>Memory</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.MemoryImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getMemory()
	 * @generated
	 */
	int MEMORY = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__SIZE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY__DESCRIPTOR = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Memory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.ExecutionResourceImpl <em>Execution Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.ExecutionResourceImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getExecutionResource()
	 * @generated
	 */
	int EXECUTION_RESOURCE = 8;

	/**
	 * The feature id for the '<em><b>Core Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_RESOURCE__CORE_ID = 0;

	/**
	 * The feature id for the '<em><b>Fraction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_RESOURCE__FRACTION = 1;

	/**
	 * The feature id for the '<em><b>Processor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_RESOURCE__PROCESSOR = 2;

	/**
	 * The number of structural features of the '<em>Execution Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXECUTION_RESOURCE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.ProcessorImpl <em>Processor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.ProcessorImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getProcessor()
	 * @generated
	 */
	int PROCESSOR = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR__DESCRIPTOR = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clock Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR__CLOCK_FREQUENCY = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Processor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkResourceImpl <em>Network Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.NetworkResourceImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getNetworkResource()
	 * @generated
	 */
	int NETWORK_RESOURCE = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_RESOURCE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_RESOURCE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_RESOURCE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Bandwidth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_RESOURCE__BANDWIDTH = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Network Interface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_RESOURCE__NETWORK_INTERFACE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Network Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_RESOURCE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.TargetEnvironmentImpl <em>Target Environment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetEnvironmentImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getTargetEnvironment()
	 * @generated
	 */
	int TARGET_ENVIRONMENT = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_ENVIRONMENT__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_ENVIRONMENT__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_ENVIRONMENT__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_ENVIRONMENT__DESCRIPTION = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Nodes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_ENVIRONMENT__NODES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Network Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_ENVIRONMENT__NETWORK_ELEMENTS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Target Environment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_ENVIRONMENT_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl <em>Software Performance Profile</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getSoftwarePerformanceProfile()
	 * @generated
	 */
	int SOFTWARE_PERFORMANCE_PROFILE = 12;

	/**
	 * The feature id for the '<em><b>Software Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Clocks Per Instruction Average</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Clocks Per Instruction Distribution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Tlb Miss Probability</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Processor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Software Performance Profile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SOFTWARE_PERFORMANCE_PROFILE_FEATURE_COUNT = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.FileSystemPerformanceProfileImpl <em>File System Performance Profile</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.FileSystemPerformanceProfileImpl
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getFileSystemPerformanceProfile()
	 * @generated
	 */
	int FILE_SYSTEM_PERFORMANCE_PROFILE = 13;

	/**
	 * The feature id for the '<em><b>Storage Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_SYSTEM_PERFORMANCE_PROFILE__STORAGE_RESOURCE = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>File System</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_SYSTEM_PERFORMANCE_PROFILE__FILE_SYSTEM = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>File System Performance Profile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILE_SYSTEM_PERFORMANCE_PROFILE_FEATURE_COUNT = AnnotationPackage.ANNOTATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind <em>Scheduling Policy Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind
	 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getSchedulingPolicyKind()
	 * @generated
	 */
	int SCHEDULING_POLICY_KIND = 14;


	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement <em>Network Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Network Element</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkElement
	 * @generated
	 */
	EClass getNetworkElement();

	/**
	 * Returns the meta object for the reference list '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getNodeConnections <em>Node Connections</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Node Connections</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getNodeConnections()
	 * @see #getNetworkElement()
	 * @generated
	 */
	EReference getNetworkElement_NodeConnections();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getDescriptor()
	 * @see #getNetworkElement()
	 * @generated
	 */
	EReference getNetworkElement_Descriptor();

	/**
	 * Returns the meta object for the reference list '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getDownlinks <em>Downlinks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Downlinks</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getDownlinks()
	 * @see #getNetworkElement()
	 * @generated
	 */
	EReference getNetworkElement_Downlinks();

	/**
	 * Returns the meta object for the reference list '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getSiblings <em>Siblings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Siblings</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getSiblings()
	 * @see #getNetworkElement()
	 * @generated
	 */
	EReference getNetworkElement_Siblings();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface <em>Network Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Network Interface</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkInterface
	 * @generated
	 */
	EClass getNetworkInterface();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getBandwidth <em>Bandwidth</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bandwidth</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getBandwidth()
	 * @see #getNetworkInterface()
	 * @generated
	 */
	EAttribute getNetworkInterface_Bandwidth();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getDescriptor()
	 * @see #getNetworkInterface()
	 * @generated
	 */
	EReference getNetworkInterface_Descriptor();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getConnection <em>Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Connection</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getConnection()
	 * @see #getNetworkInterface()
	 * @generated
	 */
	EReference getNetworkInterface_Connection();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.Node <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Node</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Node
	 * @generated
	 */
	EClass getNode();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.Node#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Node#getDescription()
	 * @see #getNode()
	 * @generated
	 */
	EAttribute getNode_Description();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Node#getContainers <em>Containers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Containers</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Node#getContainers()
	 * @see #getNode()
	 * @generated
	 */
	EReference getNode_Containers();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Node#getProcessors <em>Processors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Processors</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Node#getProcessors()
	 * @see #getNode()
	 * @generated
	 */
	EReference getNode_Processors();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Node#getMemories <em>Memories</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Memories</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Node#getMemories()
	 * @see #getNode()
	 * @generated
	 */
	EReference getNode_Memories();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Node#getStorageDevices <em>Storage Devices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Storage Devices</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Node#getStorageDevices()
	 * @see #getNode()
	 * @generated
	 */
	EReference getNode_StorageDevices();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Node#getNetworkInterfaces <em>Network Interfaces</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Network Interfaces</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Node#getNetworkInterfaces()
	 * @see #getNode()
	 * @generated
	 */
	EReference getNode_NetworkInterfaces();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.Container <em>Container</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Container</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Container
	 * @generated
	 */
	EClass getContainer();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.Container#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Container#getDescription()
	 * @see #getContainer()
	 * @generated
	 */
	EAttribute getContainer_Description();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Container#getStorageResources <em>Storage Resources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Storage Resources</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Container#getStorageResources()
	 * @see #getContainer()
	 * @generated
	 */
	EReference getContainer_StorageResources();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Container#getMemoryResources <em>Memory Resources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Memory Resources</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Container#getMemoryResources()
	 * @see #getContainer()
	 * @generated
	 */
	EReference getContainer_MemoryResources();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Container#getExecutionResources <em>Execution Resources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Execution Resources</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Container#getExecutionResources()
	 * @see #getContainer()
	 * @generated
	 */
	EReference getContainer_ExecutionResources();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.Container#getSchedulingPolicy <em>Scheduling Policy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Scheduling Policy</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Container#getSchedulingPolicy()
	 * @see #getContainer()
	 * @generated
	 */
	EAttribute getContainer_SchedulingPolicy();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.Container#getNetworkResources <em>Network Resources</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Network Resources</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Container#getNetworkResources()
	 * @see #getContainer()
	 * @generated
	 */
	EReference getContainer_NetworkResources();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource <em>Storage Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Storage Resource</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.StorageResource
	 * @generated
	 */
	EClass getStorageResource();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.StorageResource#getDescription()
	 * @see #getStorageResource()
	 * @generated
	 */
	EAttribute getStorageResource_Description();

	/**
	 * Returns the meta object for the reference list '{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource#getStorageDevices <em>Storage Devices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Storage Devices</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.StorageResource#getStorageDevices()
	 * @see #getStorageResource()
	 * @generated
	 */
	EReference getStorageResource_StorageDevices();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.StorageResource#getSize()
	 * @see #getStorageResource()
	 * @generated
	 */
	EAttribute getStorageResource_Size();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice <em>Storage Device</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Storage Device</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.StorageDevice
	 * @generated
	 */
	EClass getStorageDevice();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice#getDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.StorageDevice#getDescriptor()
	 * @see #getStorageDevice()
	 * @generated
	 */
	EReference getStorageDevice_Descriptor();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.StorageDevice#getSize()
	 * @see #getStorageDevice()
	 * @generated
	 */
	EAttribute getStorageDevice_Size();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource <em>Memory Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Memory Resource</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.MemoryResource
	 * @generated
	 */
	EClass getMemoryResource();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getDescription()
	 * @see #getMemoryResource()
	 * @generated
	 */
	EAttribute getMemoryResource_Description();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getSize()
	 * @see #getMemoryResource()
	 * @generated
	 */
	EAttribute getMemoryResource_Size();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getMemory <em>Memory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Memory</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getMemory()
	 * @see #getMemoryResource()
	 * @generated
	 */
	EReference getMemoryResource_Memory();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.Memory <em>Memory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Memory</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Memory
	 * @generated
	 */
	EClass getMemory();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.Memory#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Memory#getSize()
	 * @see #getMemory()
	 * @generated
	 */
	EAttribute getMemory_Size();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.Memory#getDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Memory#getDescriptor()
	 * @see #getMemory()
	 * @generated
	 */
	EReference getMemory_Descriptor();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource <em>Execution Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Execution Resource</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.ExecutionResource
	 * @generated
	 */
	EClass getExecutionResource();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getCoreId <em>Core Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Core Id</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getCoreId()
	 * @see #getExecutionResource()
	 * @generated
	 */
	EAttribute getExecutionResource_CoreId();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getFraction <em>Fraction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fraction</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getFraction()
	 * @see #getExecutionResource()
	 * @generated
	 */
	EAttribute getExecutionResource_Fraction();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getProcessor <em>Processor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Processor</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getProcessor()
	 * @see #getExecutionResource()
	 * @generated
	 */
	EReference getExecutionResource_Processor();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.Processor <em>Processor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Processor</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Processor
	 * @generated
	 */
	EClass getProcessor();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.Processor#getDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Processor#getDescriptor()
	 * @see #getProcessor()
	 * @generated
	 */
	EReference getProcessor_Descriptor();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.Processor#getClockFrequency <em>Clock Frequency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Clock Frequency</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.Processor#getClockFrequency()
	 * @see #getProcessor()
	 * @generated
	 */
	EAttribute getProcessor_ClockFrequency();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource <em>Network Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Network Resource</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkResource
	 * @generated
	 */
	EClass getNetworkResource();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource#getBandwidth <em>Bandwidth</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bandwidth</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkResource#getBandwidth()
	 * @see #getNetworkResource()
	 * @generated
	 */
	EAttribute getNetworkResource_Bandwidth();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource#getNetworkInterface <em>Network Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Network Interface</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkResource#getNetworkInterface()
	 * @see #getNetworkResource()
	 * @generated
	 */
	EReference getNetworkResource_NetworkInterface();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment <em>Target Environment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Target Environment</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment
	 * @generated
	 */
	EClass getTargetEnvironment();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getDescription()
	 * @see #getTargetEnvironment()
	 * @generated
	 */
	EAttribute getTargetEnvironment_Description();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getNodes <em>Nodes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Nodes</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getNodes()
	 * @see #getTargetEnvironment()
	 * @generated
	 */
	EReference getTargetEnvironment_Nodes();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getNetworkElements <em>Network Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Network Elements</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getNetworkElements()
	 * @see #getTargetEnvironment()
	 * @generated
	 */
	EReference getTargetEnvironment_NetworkElements();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile <em>Software Performance Profile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Software Performance Profile</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile
	 * @generated
	 */
	EClass getSoftwarePerformanceProfile();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getSoftwareKind <em>Software Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Software Kind</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getSoftwareKind()
	 * @see #getSoftwarePerformanceProfile()
	 * @generated
	 */
	EAttribute getSoftwarePerformanceProfile_SoftwareKind();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getClocksPerInstructionAverage <em>Clocks Per Instruction Average</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Clocks Per Instruction Average</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getClocksPerInstructionAverage()
	 * @see #getSoftwarePerformanceProfile()
	 * @generated
	 */
	EAttribute getSoftwarePerformanceProfile_ClocksPerInstructionAverage();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getClocksPerInstructionDistribution <em>Clocks Per Instruction Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Clocks Per Instruction Distribution</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getClocksPerInstructionDistribution()
	 * @see #getSoftwarePerformanceProfile()
	 * @generated
	 */
	EAttribute getSoftwarePerformanceProfile_ClocksPerInstructionDistribution();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getTlbMissProbability <em>Tlb Miss Probability</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tlb Miss Probability</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getTlbMissProbability()
	 * @see #getSoftwarePerformanceProfile()
	 * @generated
	 */
	EAttribute getSoftwarePerformanceProfile_TlbMissProbability();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getProcessor <em>Processor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Processor</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getProcessor()
	 * @see #getSoftwarePerformanceProfile()
	 * @generated
	 */
	EReference getSoftwarePerformanceProfile_Processor();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile <em>File System Performance Profile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>File System Performance Profile</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile
	 * @generated
	 */
	EClass getFileSystemPerformanceProfile();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile#getStorageResource <em>Storage Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Storage Resource</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile#getStorageResource()
	 * @see #getFileSystemPerformanceProfile()
	 * @generated
	 */
	EReference getFileSystemPerformanceProfile_StorageResource();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile#getFileSystem <em>File System</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>File System</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile#getFileSystem()
	 * @see #getFileSystemPerformanceProfile()
	 * @generated
	 */
	EAttribute getFileSystemPerformanceProfile_FileSystem();

	/**
	 * Returns the meta object for enum '{@link eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind <em>Scheduling Policy Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Scheduling Policy Kind</em>'.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind
	 * @generated
	 */
	EEnum getSchedulingPolicyKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	TargetenvironmentFactory getTargetenvironmentFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkElementImpl <em>Network Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.NetworkElementImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getNetworkElement()
		 * @generated
		 */
		EClass NETWORK_ELEMENT = eINSTANCE.getNetworkElement();

		/**
		 * The meta object literal for the '<em><b>Node Connections</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK_ELEMENT__NODE_CONNECTIONS = eINSTANCE.getNetworkElement_NodeConnections();

		/**
		 * The meta object literal for the '<em><b>Descriptor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK_ELEMENT__DESCRIPTOR = eINSTANCE.getNetworkElement_Descriptor();

		/**
		 * The meta object literal for the '<em><b>Downlinks</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK_ELEMENT__DOWNLINKS = eINSTANCE.getNetworkElement_Downlinks();

		/**
		 * The meta object literal for the '<em><b>Siblings</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK_ELEMENT__SIBLINGS = eINSTANCE.getNetworkElement_Siblings();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkInterfaceImpl <em>Network Interface</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.NetworkInterfaceImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getNetworkInterface()
		 * @generated
		 */
		EClass NETWORK_INTERFACE = eINSTANCE.getNetworkInterface();

		/**
		 * The meta object literal for the '<em><b>Bandwidth</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NETWORK_INTERFACE__BANDWIDTH = eINSTANCE.getNetworkInterface_Bandwidth();

		/**
		 * The meta object literal for the '<em><b>Descriptor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK_INTERFACE__DESCRIPTOR = eINSTANCE.getNetworkInterface_Descriptor();

		/**
		 * The meta object literal for the '<em><b>Connection</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK_INTERFACE__CONNECTION = eINSTANCE.getNetworkInterface_Connection();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl <em>Node</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.NodeImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getNode()
		 * @generated
		 */
		EClass NODE = eINSTANCE.getNode();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NODE__DESCRIPTION = eINSTANCE.getNode_Description();

		/**
		 * The meta object literal for the '<em><b>Containers</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NODE__CONTAINERS = eINSTANCE.getNode_Containers();

		/**
		 * The meta object literal for the '<em><b>Processors</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NODE__PROCESSORS = eINSTANCE.getNode_Processors();

		/**
		 * The meta object literal for the '<em><b>Memories</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NODE__MEMORIES = eINSTANCE.getNode_Memories();

		/**
		 * The meta object literal for the '<em><b>Storage Devices</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NODE__STORAGE_DEVICES = eINSTANCE.getNode_StorageDevices();

		/**
		 * The meta object literal for the '<em><b>Network Interfaces</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NODE__NETWORK_INTERFACES = eINSTANCE.getNode_NetworkInterfaces();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl <em>Container</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.ContainerImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getContainer()
		 * @generated
		 */
		EClass CONTAINER = eINSTANCE.getContainer();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTAINER__DESCRIPTION = eINSTANCE.getContainer_Description();

		/**
		 * The meta object literal for the '<em><b>Storage Resources</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTAINER__STORAGE_RESOURCES = eINSTANCE.getContainer_StorageResources();

		/**
		 * The meta object literal for the '<em><b>Memory Resources</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTAINER__MEMORY_RESOURCES = eINSTANCE.getContainer_MemoryResources();

		/**
		 * The meta object literal for the '<em><b>Execution Resources</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTAINER__EXECUTION_RESOURCES = eINSTANCE.getContainer_ExecutionResources();

		/**
		 * The meta object literal for the '<em><b>Scheduling Policy</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTAINER__SCHEDULING_POLICY = eINSTANCE.getContainer_SchedulingPolicy();

		/**
		 * The meta object literal for the '<em><b>Network Resources</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CONTAINER__NETWORK_RESOURCES = eINSTANCE.getContainer_NetworkResources();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.StorageResourceImpl <em>Storage Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.StorageResourceImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getStorageResource()
		 * @generated
		 */
		EClass STORAGE_RESOURCE = eINSTANCE.getStorageResource();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STORAGE_RESOURCE__DESCRIPTION = eINSTANCE.getStorageResource_Description();

		/**
		 * The meta object literal for the '<em><b>Storage Devices</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STORAGE_RESOURCE__STORAGE_DEVICES = eINSTANCE.getStorageResource_StorageDevices();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STORAGE_RESOURCE__SIZE = eINSTANCE.getStorageResource_Size();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.StorageDeviceImpl <em>Storage Device</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.StorageDeviceImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getStorageDevice()
		 * @generated
		 */
		EClass STORAGE_DEVICE = eINSTANCE.getStorageDevice();

		/**
		 * The meta object literal for the '<em><b>Descriptor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STORAGE_DEVICE__DESCRIPTOR = eINSTANCE.getStorageDevice_Descriptor();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STORAGE_DEVICE__SIZE = eINSTANCE.getStorageDevice_Size();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.MemoryResourceImpl <em>Memory Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.MemoryResourceImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getMemoryResource()
		 * @generated
		 */
		EClass MEMORY_RESOURCE = eINSTANCE.getMemoryResource();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMORY_RESOURCE__DESCRIPTION = eINSTANCE.getMemoryResource_Description();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMORY_RESOURCE__SIZE = eINSTANCE.getMemoryResource_Size();

		/**
		 * The meta object literal for the '<em><b>Memory</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMORY_RESOURCE__MEMORY = eINSTANCE.getMemoryResource_Memory();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.MemoryImpl <em>Memory</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.MemoryImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getMemory()
		 * @generated
		 */
		EClass MEMORY = eINSTANCE.getMemory();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMORY__SIZE = eINSTANCE.getMemory_Size();

		/**
		 * The meta object literal for the '<em><b>Descriptor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMORY__DESCRIPTOR = eINSTANCE.getMemory_Descriptor();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.ExecutionResourceImpl <em>Execution Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.ExecutionResourceImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getExecutionResource()
		 * @generated
		 */
		EClass EXECUTION_RESOURCE = eINSTANCE.getExecutionResource();

		/**
		 * The meta object literal for the '<em><b>Core Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXECUTION_RESOURCE__CORE_ID = eINSTANCE.getExecutionResource_CoreId();

		/**
		 * The meta object literal for the '<em><b>Fraction</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EXECUTION_RESOURCE__FRACTION = eINSTANCE.getExecutionResource_Fraction();

		/**
		 * The meta object literal for the '<em><b>Processor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXECUTION_RESOURCE__PROCESSOR = eINSTANCE.getExecutionResource_Processor();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.ProcessorImpl <em>Processor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.ProcessorImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getProcessor()
		 * @generated
		 */
		EClass PROCESSOR = eINSTANCE.getProcessor();

		/**
		 * The meta object literal for the '<em><b>Descriptor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESSOR__DESCRIPTOR = eINSTANCE.getProcessor_Descriptor();

		/**
		 * The meta object literal for the '<em><b>Clock Frequency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR__CLOCK_FREQUENCY = eINSTANCE.getProcessor_ClockFrequency();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.NetworkResourceImpl <em>Network Resource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.NetworkResourceImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getNetworkResource()
		 * @generated
		 */
		EClass NETWORK_RESOURCE = eINSTANCE.getNetworkResource();

		/**
		 * The meta object literal for the '<em><b>Bandwidth</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NETWORK_RESOURCE__BANDWIDTH = eINSTANCE.getNetworkResource_Bandwidth();

		/**
		 * The meta object literal for the '<em><b>Network Interface</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference NETWORK_RESOURCE__NETWORK_INTERFACE = eINSTANCE.getNetworkResource_NetworkInterface();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.TargetEnvironmentImpl <em>Target Environment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetEnvironmentImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getTargetEnvironment()
		 * @generated
		 */
		EClass TARGET_ENVIRONMENT = eINSTANCE.getTargetEnvironment();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TARGET_ENVIRONMENT__DESCRIPTION = eINSTANCE.getTargetEnvironment_Description();

		/**
		 * The meta object literal for the '<em><b>Nodes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TARGET_ENVIRONMENT__NODES = eINSTANCE.getTargetEnvironment_Nodes();

		/**
		 * The meta object literal for the '<em><b>Network Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TARGET_ENVIRONMENT__NETWORK_ELEMENTS = eINSTANCE.getTargetEnvironment_NetworkElements();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl <em>Software Performance Profile</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.SoftwarePerformanceProfileImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getSoftwarePerformanceProfile()
		 * @generated
		 */
		EClass SOFTWARE_PERFORMANCE_PROFILE = eINSTANCE.getSoftwarePerformanceProfile();

		/**
		 * The meta object literal for the '<em><b>Software Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND = eINSTANCE.getSoftwarePerformanceProfile_SoftwareKind();

		/**
		 * The meta object literal for the '<em><b>Clocks Per Instruction Average</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE = eINSTANCE.getSoftwarePerformanceProfile_ClocksPerInstructionAverage();

		/**
		 * The meta object literal for the '<em><b>Clocks Per Instruction Distribution</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION = eINSTANCE.getSoftwarePerformanceProfile_ClocksPerInstructionDistribution();

		/**
		 * The meta object literal for the '<em><b>Tlb Miss Probability</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY = eINSTANCE.getSoftwarePerformanceProfile_TlbMissProbability();

		/**
		 * The meta object literal for the '<em><b>Processor</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR = eINSTANCE.getSoftwarePerformanceProfile_Processor();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.impl.FileSystemPerformanceProfileImpl <em>File System Performance Profile</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.FileSystemPerformanceProfileImpl
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getFileSystemPerformanceProfile()
		 * @generated
		 */
		EClass FILE_SYSTEM_PERFORMANCE_PROFILE = eINSTANCE.getFileSystemPerformanceProfile();

		/**
		 * The meta object literal for the '<em><b>Storage Resource</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FILE_SYSTEM_PERFORMANCE_PROFILE__STORAGE_RESOURCE = eINSTANCE.getFileSystemPerformanceProfile_StorageResource();

		/**
		 * The meta object literal for the '<em><b>File System</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FILE_SYSTEM_PERFORMANCE_PROFILE__FILE_SYSTEM = eINSTANCE.getFileSystemPerformanceProfile_FileSystem();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind <em>Scheduling Policy Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind
		 * @see eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl#getSchedulingPolicyKind()
		 * @generated
		 */
		EEnum SCHEDULING_POLICY_KIND = eINSTANCE.getSchedulingPolicyKind();

	}

} //TargetenvironmentPackage
