/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Target Environment</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The TargetEnvironment represents execution environment containing resources that can be used for executing Services. Each TargetEnvironment consists of multiple Nodes, which contain hardware resources than can be shared among multiple Containers, which define logical resources available to Services. A TargetEnvironment may also contain multiple network elements corresponding to routers and switches.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getDescription <em>Description</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getNodes <em>Nodes</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getNetworkElements <em>Network Elements</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getTargetEnvironment()
 * @model
 * @generated
 */
public interface TargetEnvironment extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional, human-readable description of the target environment.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getTargetEnvironment_Description()
	 * @model ordered="false"
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Nodes</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.Node}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Hardware Nodes in a particular TargetEnvironment. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Nodes</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getTargetEnvironment_Nodes()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<Node> getNodes();

	/**
	 * Returns the value of the '<em><b>Network Elements</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Network elements found in a target environment.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Network Elements</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getTargetEnvironment_NetworkElements()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<NetworkElement> getNetworkElements();

} // TargetEnvironment
