/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Storage Resource</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The StorageResource entity represents a portion of physical persistent storage provided by storage devices. Conceptually it corresponds to a logical volume, which provides contiguous addressable persistent storage area.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource#getDescription <em>Description</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource#getStorageDevices <em>Storage Devices</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource#getSize <em>Size</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getStorageResource()
 * @model
 * @generated
 */
public interface StorageResource extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional description of the storage resource.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getStorageResource_Description()
	 * @model ordered="false"
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Storage Devices</b></em>' reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Storage devices backing the storage resource.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Storage Devices</em>' reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getStorageResource_StorageDevices()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	EList<StorageDevice> getStorageDevices();

	/**
	 * Returns the value of the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Size of the storage resource, in bytes.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Size</em>' attribute.
	 * @see #setSize(int)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getStorageResource_Size()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getSize();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.StorageResource#getSize <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Size</em>' attribute.
	 * @see #getSize()
	 * @generated
	 */
	void setSize(int value);

} // StorageResource
