/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Storage Device</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The StorageDevice entity represents a physical instance of a storage device. The instance references StorageDeviceDescriptor, which captures common physical properties of the device, such as access latency or read speed. Size of the storage device is not considered common attribute and is defined by the StorageDevice entity, because it is reasonable to expect that devices of various sizes may share physical properties.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice#getDescriptor <em>Descriptor</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice#getSize <em>Size</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getStorageDevice()
 * @model
 * @generated
 */
public interface StorageDevice extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to descriptor capturing the physical properties of the storage device.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Descriptor</em>' reference.
	 * @see #setDescriptor(StorageDeviceDescriptor)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getStorageDevice_Descriptor()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	StorageDeviceDescriptor getDescriptor();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice#getDescriptor <em>Descriptor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Descriptor</em>' reference.
	 * @see #getDescriptor()
	 * @generated
	 */
	void setDescriptor(StorageDeviceDescriptor value);

	/**
	 * Returns the value of the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Storage capacity of the installed storage device, in bytes.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Size</em>' attribute.
	 * @see #setSize(int)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getStorageDevice_Size()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getSize();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice#getSize <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Size</em>' attribute.
	 * @see #getSize()
	 * @generated
	 */
	void setSize(int value);

} // StorageDevice
