/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import eu.qimpress.samm.annotation.Annotation;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Software Performance Profile</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The SoftwarePerformanceProfile entity represents performance of a specific kind of software on a particular processor. Since different kinds of software may yield different performance on different processors, this allows associating a number of performance profiles for different kinds of software with a particular processor type. Besides simple identification of software kind, each profile contains a number of attributes expressing how well the software runs on a particular processor. All the attributes are optional, because obtaining such information is non-trivial and not all tools may be interested in it.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getSoftwareKind <em>Software Kind</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getClocksPerInstructionAverage <em>Clocks Per Instruction Average</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getClocksPerInstructionDistribution <em>Clocks Per Instruction Distribution</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getTlbMissProbability <em>Tlb Miss Probability</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getProcessor <em>Processor</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getSoftwarePerformanceProfile()
 * @model
 * @generated
 */
public interface SoftwarePerformanceProfile extends Annotation {
	/**
	 * Returns the value of the '<em><b>Software Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The kind of software for which the profile is valid. This is a free-form string.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Software Kind</em>' attribute.
	 * @see #setSoftwareKind(String)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getSoftwarePerformanceProfile_SoftwareKind()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	String getSoftwareKind();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getSoftwareKind <em>Software Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Software Kind</em>' attribute.
	 * @see #getSoftwareKind()
	 * @generated
	 */
	void setSoftwareKind(String value);

	/**
	 * Returns the value of the '<em><b>Clocks Per Instruction Average</b></em>' attribute.
	 * The default value is <code>"0"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Average number of clocks per instruction.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Clocks Per Instruction Average</em>' attribute.
	 * @see #setClocksPerInstructionAverage(double)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getSoftwarePerformanceProfile_ClocksPerInstructionAverage()
	 * @model default="0" ordered="false"
	 * @generated
	 */
	double getClocksPerInstructionAverage();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getClocksPerInstructionAverage <em>Clocks Per Instruction Average</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Clocks Per Instruction Average</em>' attribute.
	 * @see #getClocksPerInstructionAverage()
	 * @generated
	 */
	void setClocksPerInstructionAverage(double value);

	/**
	 * Returns the value of the '<em><b>Clocks Per Instruction Distribution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * String specification of distribution function of the clocks per instruction metric.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Clocks Per Instruction Distribution</em>' attribute.
	 * @see #setClocksPerInstructionDistribution(String)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getSoftwarePerformanceProfile_ClocksPerInstructionDistribution()
	 * @model ordered="false"
	 * @generated
	 */
	String getClocksPerInstructionDistribution();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getClocksPerInstructionDistribution <em>Clocks Per Instruction Distribution</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Clocks Per Instruction Distribution</em>' attribute.
	 * @see #getClocksPerInstructionDistribution()
	 * @generated
	 */
	void setClocksPerInstructionDistribution(String value);

	/**
	 * Returns the value of the '<em><b>Tlb Miss Probability</b></em>' attribute.
	 * The default value is <code>"0"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The probability of TLB miss, which results in extra memory accesses due to page walk.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Tlb Miss Probability</em>' attribute.
	 * @see #setTlbMissProbability(double)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getSoftwarePerformanceProfile_TlbMissProbability()
	 * @model default="0" ordered="false"
	 * @generated
	 */
	double getTlbMissProbability();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getTlbMissProbability <em>Tlb Miss Probability</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Tlb Miss Probability</em>' attribute.
	 * @see #getTlbMissProbability()
	 * @generated
	 */
	void setTlbMissProbability(double value);

	/**
	 * Returns the value of the '<em><b>Processor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Processor associated with a particular software performance profile.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Processor</em>' reference.
	 * @see #setProcessor(ProcessorDescriptor)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getSoftwarePerformanceProfile_Processor()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	ProcessorDescriptor getProcessor();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile#getProcessor <em>Processor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Processor</em>' reference.
	 * @see #getProcessor()
	 * @generated
	 */
	void setProcessor(ProcessorDescriptor value);

} // SoftwarePerformanceProfile
