/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Scheduling Policy Kind</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Represents the kind of scheduling policy.
 * <!-- end-model-doc -->
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getSchedulingPolicyKind()
 * @model
 * @generated
 */
public enum SchedulingPolicyKind implements Enumerator {
	/**
	 * The '<em><b>First Come First Served</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FIRST_COME_FIRST_SERVED_VALUE
	 * @generated
	 * @ordered
	 */
	FIRST_COME_FIRST_SERVED(0, "FirstComeFirstServed", "FirstComeFirstServed"),

	/**
	 * The '<em><b>Processor Sharing</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROCESSOR_SHARING_VALUE
	 * @generated
	 * @ordered
	 */
	PROCESSOR_SHARING(1, "ProcessorSharing", "ProcessorSharing"),

	/**
	 * The '<em><b>Delay</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DELAY_VALUE
	 * @generated
	 * @ordered
	 */
	DELAY(2, "Delay", "Delay");

	/**
	 * The '<em><b>First Come First Served</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Corresponds to First Come First Served scheduling policy.
	 * <!-- end-model-doc -->
	 * @see #FIRST_COME_FIRST_SERVED
	 * @model name="FirstComeFirstServed"
	 * @generated
	 * @ordered
	 */
	public static final int FIRST_COME_FIRST_SERVED_VALUE = 0;

	/**
	 * The '<em><b>Processor Sharing</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Corresponds to the Processor Sharing scheduling policy.
	 * <!-- end-model-doc -->
	 * @see #PROCESSOR_SHARING
	 * @model name="ProcessorSharing"
	 * @generated
	 * @ordered
	 */
	public static final int PROCESSOR_SHARING_VALUE = 1;

	/**
	 * The '<em><b>Delay</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Corresponds to the Delay scheduling policy.
	 * <!-- end-model-doc -->
	 * @see #DELAY
	 * @model name="Delay"
	 * @generated
	 * @ordered
	 */
	public static final int DELAY_VALUE = 2;

	/**
	 * An array of all the '<em><b>Scheduling Policy Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final SchedulingPolicyKind[] VALUES_ARRAY =
		new SchedulingPolicyKind[] {
			FIRST_COME_FIRST_SERVED,
			PROCESSOR_SHARING,
			DELAY,
		};

	/**
	 * A public read-only list of all the '<em><b>Scheduling Policy Kind</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<SchedulingPolicyKind> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Scheduling Policy Kind</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static SchedulingPolicyKind get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			SchedulingPolicyKind result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Scheduling Policy Kind</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static SchedulingPolicyKind getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			SchedulingPolicyKind result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Scheduling Policy Kind</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static SchedulingPolicyKind get(int value) {
		switch (value) {
			case FIRST_COME_FIRST_SERVED_VALUE: return FIRST_COME_FIRST_SERVED;
			case PROCESSOR_SHARING_VALUE: return PROCESSOR_SHARING;
			case DELAY_VALUE: return DELAY;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private SchedulingPolicyKind(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //SchedulingPolicyKind
