/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Processor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The Processor entity represents an instance of physical processor package installed on a particular Node. Each physical processor instance must have a name and must refer to the descriptor of processor features. A physical processor instance should also specify the maximum clock frequency.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Processor#getDescriptor <em>Descriptor</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Processor#getClockFrequency <em>Clock Frequency</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getProcessor()
 * @model
 * @generated
 */
public interface Processor extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * References a ProcessorDescriptor entity capturing the architectural properties of the processor.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Descriptor</em>' reference.
	 * @see #setDescriptor(ProcessorDescriptor)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getProcessor_Descriptor()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	ProcessorDescriptor getDescriptor();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.Processor#getDescriptor <em>Descriptor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Descriptor</em>' reference.
	 * @see #getDescriptor()
	 * @generated
	 */
	void setDescriptor(ProcessorDescriptor value);

	/**
	 * Returns the value of the '<em><b>Clock Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The maximum clock frequency of the installed processor, in Hertz. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Clock Frequency</em>' attribute.
	 * @see #setClockFrequency(double)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getProcessor_ClockFrequency()
	 * @model ordered="false"
	 * @generated
	 */
	double getClockFrequency();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.Processor#getClockFrequency <em>Clock Frequency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Clock Frequency</em>' attribute.
	 * @see #getClockFrequency()
	 * @generated
	 */
	void setClockFrequency(double value);

} // Processor
