/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Node</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The Node entity represents a physical node in the target environment. It contains hardware resources such as processor, memory, disk, etc, and hosts execution environments in form of Containers. Each Node must have at least one Processor instance, one Memory instance, and one Container instance. A Node may also have network interfaces and storage devices.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Node#getDescription <em>Description</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Node#getContainers <em>Containers</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Node#getProcessors <em>Processors</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Node#getMemories <em>Memories</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Node#getStorageDevices <em>Storage Devices</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Node#getNetworkInterfaces <em>Network Interfaces</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNode()
 * @model
 * @generated
 */
public interface Node extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional human-readable description of the node.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNode_Description()
	 * @model ordered="false"
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.Node#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Containers</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.Container}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Containers running on a Node to provide execution environment into which services may be deployed.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Containers</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNode_Containers()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<Container> getContainers();

	/**
	 * Returns the value of the '<em><b>Processors</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.Processor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Processors installed on a Node to provide computational capabilities.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Processors</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNode_Processors()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<Processor> getProcessors();

	/**
	 * Returns the value of the '<em><b>Memories</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.Memory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Memories installed on a Node to provide transient storage for executing containers and tasks within containers.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Memories</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNode_Memories()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<Memory> getMemories();

	/**
	 * Returns the value of the '<em><b>Storage Devices</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Physical StorageDevices connected to/installed on a Node.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Storage Devices</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNode_StorageDevices()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<StorageDevice> getStorageDevices();

	/**
	 * Returns the value of the '<em><b>Network Interfaces</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Physical NetworkInterfaces installed on a node.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Network Interfaces</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNode_NetworkInterfaces()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<NetworkInterface> getNetworkInterfaces();

} // Node
