/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Network Resource</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The NetworkResource entity represents a slice of bandwidth available to a specific NetworkInterface backing the particular NetworkResource. In case of operating systems, this may correspond to a network interface, while in case of an application server, this may correspond to a particular network connection.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource#getBandwidth <em>Bandwidth</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource#getNetworkInterface <em>Network Interface</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkResource()
 * @model
 * @generated
 */
public interface NetworkResource extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Bandwidth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bandwidth available to this NetworkResource, in bits per second.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Bandwidth</em>' attribute.
	 * @see #setBandwidth(int)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkResource_Bandwidth()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getBandwidth();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource#getBandwidth <em>Bandwidth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Bandwidth</em>' attribute.
	 * @see #getBandwidth()
	 * @generated
	 */
	void setBandwidth(int value);

	/**
	 * Returns the value of the '<em><b>Network Interface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * NetworkInterface backing this NetworkResource.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Network Interface</em>' reference.
	 * @see #setNetworkInterface(NetworkInterface)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkResource_NetworkInterface()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	NetworkInterface getNetworkInterface();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource#getNetworkInterface <em>Network Interface</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Network Interface</em>' reference.
	 * @see #getNetworkInterface()
	 * @generated
	 */
	void setNetworkInterface(NetworkInterface value);

} // NetworkResource
