/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Network Interface</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The NetworkInterface represents an instance of physical network interface installed on a node. It references a NetworkInterfaceDescriptor, which provides common physical attributes of the network link. The bandwidth of the interface is associated with the instance, since it may differ from the maximal physical bandwidth determined by link speed.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getBandwidth <em>Bandwidth</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getDescriptor <em>Descriptor</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getConnection <em>Connection</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkInterface()
 * @model
 * @generated
 */
public interface NetworkInterface extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Bandwidth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The bandwidth of the network interface. The available bandwdith may be lower than the bandwidth determined by link speed.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Bandwidth</em>' attribute.
	 * @see #setBandwidth(int)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkInterface_Bandwidth()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getBandwidth();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getBandwidth <em>Bandwidth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Bandwidth</em>' attribute.
	 * @see #getBandwidth()
	 * @generated
	 */
	void setBandwidth(int value);

	/**
	 * Returns the value of the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to NetworkInterfaceDescriptor capturing the common attributes of this NetworkInterface.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Descriptor</em>' reference.
	 * @see #setDescriptor(NetworkInterfaceDescriptor)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkInterface_Descriptor()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	NetworkInterfaceDescriptor getDescriptor();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getDescriptor <em>Descriptor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Descriptor</em>' reference.
	 * @see #getDescriptor()
	 * @generated
	 */
	void setDescriptor(NetworkInterfaceDescriptor value);

	/**
	 * Returns the value of the '<em><b>Connection</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getNodeConnections <em>Node Connections</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Connection to a network serviced by a particular NetworkElement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Connection</em>' reference.
	 * @see #setConnection(NetworkElement)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkInterface_Connection()
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getNodeConnections
	 * @model opposite="nodeConnections" required="true" ordered="false"
	 * @generated
	 */
	NetworkElement getConnection();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getConnection <em>Connection</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Connection</em>' reference.
	 * @see #getConnection()
	 * @generated
	 */
	void setConnection(NetworkElement value);

} // NetworkInterface
