/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Network Element</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The NetworkElement entity represents a physical instance of an active network element such as switch or router in the target environment. Each element may have zero or more downlinks, with all elements within the downlink hierarchy representing a single network. Each element can also have multiple siblings, with sibling links corresponding to routed links. The combination of downlinks and siblings allows creating network topologies consisting of connected local networks. The NetworkElement entity is not expected to represent network devices such as hubs, which are considered obsolete in modern local networks.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getNodeConnections <em>Node Connections</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getDescriptor <em>Descriptor</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getDownlinks <em>Downlinks</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getSiblings <em>Siblings</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkElement()
 * @model
 * @generated
 */
public interface NetworkElement extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Node Connections</b></em>' reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface}.
	 * It is bidirectional and its opposite is '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getConnection <em>Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Connections to computational Nodes, through their NetworkInterfaces.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Node Connections</em>' reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkElement_NodeConnections()
	 * @see eu.qimpress.samm.deployment.targetenvironment.NetworkInterface#getConnection
	 * @model opposite="connection" ordered="false"
	 * @generated
	 */
	EList<NetworkInterface> getNodeConnections();

	/**
	 * Returns the value of the '<em><b>Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to NetworkElementDescriptor capturing the common attributes of this NetworkElement.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Descriptor</em>' reference.
	 * @see #setDescriptor(NetworkElementDescriptor)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkElement_Descriptor()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	NetworkElementDescriptor getDescriptor();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement#getDescriptor <em>Descriptor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Descriptor</em>' reference.
	 * @see #getDescriptor()
	 * @generated
	 */
	void setDescriptor(NetworkElementDescriptor value);

	/**
	 * Returns the value of the '<em><b>Downlinks</b></em>' reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Downlink network elements, typically switches. Such elements allow creating local networks where each connected node is directly visible to other nodes.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Downlinks</em>' reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkElement_Downlinks()
	 * @model ordered="false"
	 * @generated
	 */
	EList<NetworkElement> getDownlinks();

	/**
	 * Returns the value of the '<em><b>Siblings</b></em>' reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sibling network elements, typically routers. Such elements allow connecting local networks represented by the hierarchy of network elements connected by downlink elements.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Siblings</em>' reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getNetworkElement_Siblings()
	 * @model ordered="false"
	 * @generated
	 */
	EList<NetworkElement> getSiblings();

} // NetworkElement
