/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Memory Resource</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The MemoryResource entity represents a portion of physical memory made available to tasks running within a Container. Each MemoryResource must be backed by a specific instance of physical Memory. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getDescription <em>Description</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getSize <em>Size</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getMemory <em>Memory</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getMemoryResource()
 * @model
 * @generated
 */
public interface MemoryResource extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional description of the memory resource.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getMemoryResource_Description()
	 * @model ordered="false"
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Size of the memory resource, in bytes. Represents the amount of memory available to user tasks. The overhead of the container itself is not included.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Size</em>' attribute.
	 * @see #setSize(int)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getMemoryResource_Size()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getSize();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getSize <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Size</em>' attribute.
	 * @see #getSize()
	 * @generated
	 */
	void setSize(int value);

	/**
	 * Returns the value of the '<em><b>Memory</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Physical Memory backing this MemoryResource.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Memory</em>' reference.
	 * @see #setMemory(Memory)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getMemoryResource_Memory()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Memory getMemory();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource#getMemory <em>Memory</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Memory</em>' reference.
	 * @see #getMemory()
	 * @generated
	 */
	void setMemory(Memory value);

} // MemoryResource
