/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import eu.qimpress.samm.annotation.Annotation;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>File System Performance Profile</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The FileSystemPerformanceProfile entity represents performance of a specific file system on a storage resource. The performance of file operations depends on the performance of the underlying hardware as well as the performance of the file system code. This annotation allows attaching file system-specific performance information to a particular storage resource. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile#getStorageResource <em>Storage Resource</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile#getFileSystem <em>File System</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getFileSystemPerformanceProfile()
 * @model
 * @generated
 */
public interface FileSystemPerformanceProfile extends Annotation {
	/**
	 * Returns the value of the '<em><b>Storage Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Storage resource associated with a particular file system performance profile.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Storage Resource</em>' reference.
	 * @see #setStorageResource(StorageResource)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getFileSystemPerformanceProfile_StorageResource()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	StorageResource getStorageResource();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile#getStorageResource <em>Storage Resource</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Storage Resource</em>' reference.
	 * @see #getStorageResource()
	 * @generated
	 */
	void setStorageResource(StorageResource value);

	/**
	 * Returns the value of the '<em><b>File System</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional file system type used to manage the disk space.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>File System</em>' attribute.
	 * @see #setFileSystem(String)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getFileSystemPerformanceProfile_FileSystem()
	 * @model ordered="false"
	 * @generated
	 */
	String getFileSystem();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile#getFileSystem <em>File System</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>File System</em>' attribute.
	 * @see #getFileSystem()
	 * @generated
	 */
	void setFileSystem(String value);

} // FileSystemPerformanceProfile
