/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Execution Resource</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The ExecutionResource entity represents an execution resource with the granularity of hardware-supported thread. In modern processors, this typically corresponds to a single processor core. Each execution resource is backed by a specific processor core. Since a single processor core may be shared by multiple execution resources, each ExecutionResource must specify the fraction of processor time available to it.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getCoreId <em>Core Id</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getFraction <em>Fraction</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getProcessor <em>Processor</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getExecutionResource()
 * @model
 * @generated
 */
public interface ExecutionResource extends EObject {
	/**
	 * Returns the value of the '<em><b>Core Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Identifier of the core backing the associated execution resource.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Core Id</em>' attribute.
	 * @see #setCoreId(int)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getExecutionResource_CoreId()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getCoreId();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getCoreId <em>Core Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Core Id</em>' attribute.
	 * @see #getCoreId()
	 * @generated
	 */
	void setCoreId(int value);

	/**
	 * Returns the value of the '<em><b>Fraction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Fraction of execution time of the associated processor core alloted to this resource.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Fraction</em>' attribute.
	 * @see #setFraction(double)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getExecutionResource_Fraction()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	double getFraction();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getFraction <em>Fraction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Fraction</em>' attribute.
	 * @see #getFraction()
	 * @generated
	 */
	void setFraction(double value);

	/**
	 * Returns the value of the '<em><b>Processor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Physical Processor backing this ExecutionResource.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Processor</em>' reference.
	 * @see #setProcessor(Processor)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getExecutionResource_Processor()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Processor getProcessor();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource#getProcessor <em>Processor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Processor</em>' reference.
	 * @see #getProcessor()
	 * @generated
	 */
	void setProcessor(Processor value);

} // ExecutionResource
