/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment;

import org.eclipse.emf.common.util.EList;

import eu.qimpress.samm.core.NamedEntity;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Container</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The Container entity represents an execution environment utilizing the hardware installed on a Node. Logical resources provided by a Container are backed by physical resources provided by hardware installed on a Node. A Container represents an allocation unit for Services. Each Service is run in one Container, while a single Container may host zero or more Services.
 * 
 * There may be multiple Containers on a single Node and each Container must provide at least one ExecutionResource which corresponds to a fraction of execution time of at least one processor core. It also has to have at least one MemoryResource representing e.g., main memory, to accommodate the Services running within the Container. Concerning other resources, a Container may also provide StorageResources for persistent storage, NetworkResources to provide limited communication bandwidth, and PassiveResources that need not be backed by hardware.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Container#getSchedulingPolicy <em>Scheduling Policy</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Container#getDescription <em>Description</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Container#getStorageResources <em>Storage Resources</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Container#getMemoryResources <em>Memory Resources</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Container#getExecutionResources <em>Execution Resources</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.targetenvironment.Container#getNetworkResources <em>Network Resources</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getContainer()
 * @model
 * @generated
 */
public interface Container extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Optional human-readable description of the container.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getContainer_Description()
	 * @model ordered="false"
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.Container#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Storage Resources</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.StorageResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Storage resources provided by a Container.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Storage Resources</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getContainer_StorageResources()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<StorageResource> getStorageResources();

	/**
	 * Returns the value of the '<em><b>Memory Resources</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A collection of memory resources provided by a Container. There must be at least one such resource, i.e., a Container must have certain amount of memory available for executing tasks assigned to it.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Memory Resources</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getContainer_MemoryResources()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<MemoryResource> getMemoryResources();

	/**
	 * Returns the value of the '<em><b>Execution Resources</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Execution resources provided by a Container.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Execution Resources</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getContainer_ExecutionResources()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<ExecutionResource> getExecutionResources();

	/**
	 * Returns the value of the '<em><b>Scheduling Policy</b></em>' attribute.
	 * The literals are from the enumeration {@link eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Scheduling Policy</em>' attribute.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind
	 * @see #setSchedulingPolicy(SchedulingPolicyKind)
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getContainer_SchedulingPolicy()
	 * @model ordered="false"
	 * @generated
	 */
	SchedulingPolicyKind getSchedulingPolicy();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.targetenvironment.Container#getSchedulingPolicy <em>Scheduling Policy</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Scheduling Policy</em>' attribute.
	 * @see eu.qimpress.samm.deployment.targetenvironment.SchedulingPolicyKind
	 * @see #getSchedulingPolicy()
	 * @generated
	 */
	void setSchedulingPolicy(SchedulingPolicyKind value);

	/**
	 * Returns the value of the '<em><b>Network Resources</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Network resources provided by a Container.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Network Resources</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage#getContainer_NetworkResources()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<NetworkResource> getNetworkResources();

} // Container
