/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import eu.qimpress.identifier.Identifier;
import eu.qimpress.samm.core.Entity;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.deployment.hardware.*;
import eu.qimpress.samm.deployment.hardware.Cache;
import eu.qimpress.samm.deployment.hardware.HardwareDescriptor;
import eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.MemoryDescriptor;
import eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor;
import eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor;
import eu.qimpress.samm.deployment.hardware.TLB;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage
 * @generated
 */
public class HardwareSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static HardwarePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HardwareSwitch() {
		if (modelPackage == null) {
			modelPackage = HardwarePackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR: {
				NetworkElementDescriptor networkElementDescriptor = (NetworkElementDescriptor)theEObject;
				T result = caseNetworkElementDescriptor(networkElementDescriptor);
				if (result == null) result = caseHardwareDescriptor(networkElementDescriptor);
				if (result == null) result = caseNamedEntity(networkElementDescriptor);
				if (result == null) result = caseEntity(networkElementDescriptor);
				if (result == null) result = caseIdentifier(networkElementDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.HARDWARE_DESCRIPTOR: {
				HardwareDescriptor hardwareDescriptor = (HardwareDescriptor)theEObject;
				T result = caseHardwareDescriptor(hardwareDescriptor);
				if (result == null) result = caseNamedEntity(hardwareDescriptor);
				if (result == null) result = caseEntity(hardwareDescriptor);
				if (result == null) result = caseIdentifier(hardwareDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.TLB: {
				TLB tlb = (TLB)theEObject;
				T result = caseTLB(tlb);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.PROCESSOR_CORE: {
				ProcessorCore processorCore = (ProcessorCore)theEObject;
				T result = caseProcessorCore(processorCore);
				if (result == null) result = caseNamedEntity(processorCore);
				if (result == null) result = caseEntity(processorCore);
				if (result == null) result = caseIdentifier(processorCore);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.CACHE: {
				Cache cache = (Cache)theEObject;
				T result = caseCache(cache);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.PROCESSOR_DESCRIPTOR: {
				ProcessorDescriptor processorDescriptor = (ProcessorDescriptor)theEObject;
				T result = caseProcessorDescriptor(processorDescriptor);
				if (result == null) result = caseHardwareDescriptor(processorDescriptor);
				if (result == null) result = caseNamedEntity(processorDescriptor);
				if (result == null) result = caseEntity(processorDescriptor);
				if (result == null) result = caseIdentifier(processorDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR: {
				StorageDeviceDescriptor storageDeviceDescriptor = (StorageDeviceDescriptor)theEObject;
				T result = caseStorageDeviceDescriptor(storageDeviceDescriptor);
				if (result == null) result = caseHardwareDescriptor(storageDeviceDescriptor);
				if (result == null) result = caseNamedEntity(storageDeviceDescriptor);
				if (result == null) result = caseEntity(storageDeviceDescriptor);
				if (result == null) result = caseIdentifier(storageDeviceDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.MEMORY_DESCRIPTOR: {
				MemoryDescriptor memoryDescriptor = (MemoryDescriptor)theEObject;
				T result = caseMemoryDescriptor(memoryDescriptor);
				if (result == null) result = caseHardwareDescriptor(memoryDescriptor);
				if (result == null) result = caseNamedEntity(memoryDescriptor);
				if (result == null) result = caseEntity(memoryDescriptor);
				if (result == null) result = caseIdentifier(memoryDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.HARDWARE_DESCRIPTOR_REPOSITORY: {
				HardwareDescriptorRepository hardwareDescriptorRepository = (HardwareDescriptorRepository)theEObject;
				T result = caseHardwareDescriptorRepository(hardwareDescriptorRepository);
				if (result == null) result = caseNamedEntity(hardwareDescriptorRepository);
				if (result == null) result = caseEntity(hardwareDescriptorRepository);
				if (result == null) result = caseIdentifier(hardwareDescriptorRepository);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR: {
				NetworkInterfaceDescriptor networkInterfaceDescriptor = (NetworkInterfaceDescriptor)theEObject;
				T result = caseNetworkInterfaceDescriptor(networkInterfaceDescriptor);
				if (result == null) result = caseHardwareDescriptor(networkInterfaceDescriptor);
				if (result == null) result = caseNamedEntity(networkInterfaceDescriptor);
				if (result == null) result = caseEntity(networkInterfaceDescriptor);
				if (result == null) result = caseIdentifier(networkInterfaceDescriptor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Network Element Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Network Element Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNetworkElementDescriptor(NetworkElementDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHardwareDescriptor(HardwareDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TLB</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TLB</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTLB(TLB object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Processor Core</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Processor Core</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessorCore(ProcessorCore object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cache</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cache</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCache(Cache object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Processor Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Processor Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessorDescriptor(ProcessorDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Storage Device Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Storage Device Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStorageDeviceDescriptor(StorageDeviceDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Memory Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Memory Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMemoryDescriptor(MemoryDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Descriptor Repository</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Descriptor Repository</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHardwareDescriptorRepository(HardwareDescriptorRepository object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Network Interface Descriptor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Network Interface Descriptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNetworkInterfaceDescriptor(NetworkInterfaceDescriptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntity(Entity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedEntity(NamedEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //HardwareSwitch
