/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Storage Device Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl#getWriteSpeed <em>Write Speed</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl#getReadSpeed <em>Read Speed</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl#getRequestLatency <em>Request Latency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl#getCacheSize <em>Cache Size</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class StorageDeviceDescriptorImpl extends HardwareDescriptorImpl implements StorageDeviceDescriptor {
	/**
	 * The default value of the '{@link #getWriteSpeed() <em>Write Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWriteSpeed()
	 * @generated
	 * @ordered
	 */
	protected static final int WRITE_SPEED_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getWriteSpeed() <em>Write Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWriteSpeed()
	 * @generated
	 * @ordered
	 */
	protected int writeSpeed = WRITE_SPEED_EDEFAULT;

	/**
	 * The default value of the '{@link #getReadSpeed() <em>Read Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReadSpeed()
	 * @generated
	 * @ordered
	 */
	protected static final int READ_SPEED_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getReadSpeed() <em>Read Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReadSpeed()
	 * @generated
	 * @ordered
	 */
	protected int readSpeed = READ_SPEED_EDEFAULT;

	/**
	 * The default value of the '{@link #getRequestLatency() <em>Request Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequestLatency()
	 * @generated
	 * @ordered
	 */
	protected static final double REQUEST_LATENCY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getRequestLatency() <em>Request Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRequestLatency()
	 * @generated
	 * @ordered
	 */
	protected double requestLatency = REQUEST_LATENCY_EDEFAULT;

	/**
	 * The default value of the '{@link #getCacheSize() <em>Cache Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheSize()
	 * @generated
	 * @ordered
	 */
	protected static final int CACHE_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCacheSize() <em>Cache Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheSize()
	 * @generated
	 * @ordered
	 */
	protected int cacheSize = CACHE_SIZE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StorageDeviceDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HardwarePackage.Literals.STORAGE_DEVICE_DESCRIPTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getWriteSpeed() {
		return writeSpeed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWriteSpeed(int newWriteSpeed) {
		int oldWriteSpeed = writeSpeed;
		writeSpeed = newWriteSpeed;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__WRITE_SPEED, oldWriteSpeed, writeSpeed));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getReadSpeed() {
		return readSpeed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReadSpeed(int newReadSpeed) {
		int oldReadSpeed = readSpeed;
		readSpeed = newReadSpeed;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__READ_SPEED, oldReadSpeed, readSpeed));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getRequestLatency() {
		return requestLatency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRequestLatency(double newRequestLatency) {
		double oldRequestLatency = requestLatency;
		requestLatency = newRequestLatency;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__REQUEST_LATENCY, oldRequestLatency, requestLatency));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCacheSize() {
		return cacheSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCacheSize(int newCacheSize) {
		int oldCacheSize = cacheSize;
		cacheSize = newCacheSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__CACHE_SIZE, oldCacheSize, cacheSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__WRITE_SPEED:
				return getWriteSpeed();
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__READ_SPEED:
				return getReadSpeed();
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__REQUEST_LATENCY:
				return getRequestLatency();
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__CACHE_SIZE:
				return getCacheSize();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__WRITE_SPEED:
				setWriteSpeed((Integer)newValue);
				return;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__READ_SPEED:
				setReadSpeed((Integer)newValue);
				return;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__REQUEST_LATENCY:
				setRequestLatency((Double)newValue);
				return;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__CACHE_SIZE:
				setCacheSize((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__WRITE_SPEED:
				setWriteSpeed(WRITE_SPEED_EDEFAULT);
				return;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__READ_SPEED:
				setReadSpeed(READ_SPEED_EDEFAULT);
				return;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__REQUEST_LATENCY:
				setRequestLatency(REQUEST_LATENCY_EDEFAULT);
				return;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__CACHE_SIZE:
				setCacheSize(CACHE_SIZE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__WRITE_SPEED:
				return writeSpeed != WRITE_SPEED_EDEFAULT;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__READ_SPEED:
				return readSpeed != READ_SPEED_EDEFAULT;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__REQUEST_LATENCY:
				return requestLatency != REQUEST_LATENCY_EDEFAULT;
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR__CACHE_SIZE:
				return cacheSize != CACHE_SIZE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (writeSpeed: ");
		result.append(writeSpeed);
		result.append(", readSpeed: ");
		result.append(readSpeed);
		result.append(", requestLatency: ");
		result.append(requestLatency);
		result.append(", cacheSize: ");
		result.append(cacheSize);
		result.append(')');
		return result.toString();
	}

} //StorageDeviceDescriptorImpl
