/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.qimpress.samm.deployment.hardware.Cache;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.samm.deployment.hardware.TLB;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Processor Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorDescriptorImpl#getCaches <em>Caches</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorDescriptorImpl#getTlbs <em>Tlbs</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorDescriptorImpl#getCores <em>Cores</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProcessorDescriptorImpl extends HardwareDescriptorImpl implements ProcessorDescriptor {
	/**
	 * The cached value of the '{@link #getCaches() <em>Caches</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCaches()
	 * @generated
	 * @ordered
	 */
	protected EList<Cache> caches;

	/**
	 * The cached value of the '{@link #getTlbs() <em>Tlbs</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTlbs()
	 * @generated
	 * @ordered
	 */
	protected EList<TLB> tlbs;

	/**
	 * The cached value of the '{@link #getCores() <em>Cores</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCores()
	 * @generated
	 * @ordered
	 */
	protected EList<ProcessorCore> cores;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessorDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HardwarePackage.Literals.PROCESSOR_DESCRIPTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Cache> getCaches() {
		if (caches == null) {
			caches = new EObjectContainmentEList<Cache>(Cache.class, this, HardwarePackage.PROCESSOR_DESCRIPTOR__CACHES);
		}
		return caches;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TLB> getTlbs() {
		if (tlbs == null) {
			tlbs = new EObjectContainmentEList<TLB>(TLB.class, this, HardwarePackage.PROCESSOR_DESCRIPTOR__TLBS);
		}
		return tlbs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ProcessorCore> getCores() {
		if (cores == null) {
			cores = new EObjectContainmentWithInverseEList<ProcessorCore>(ProcessorCore.class, this, HardwarePackage.PROCESSOR_DESCRIPTOR__CORES, HardwarePackage.PROCESSOR_CORE__DESCRIPTOR);
		}
		return cores;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CORES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getCores()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CACHES:
				return ((InternalEList<?>)getCaches()).basicRemove(otherEnd, msgs);
			case HardwarePackage.PROCESSOR_DESCRIPTOR__TLBS:
				return ((InternalEList<?>)getTlbs()).basicRemove(otherEnd, msgs);
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CORES:
				return ((InternalEList<?>)getCores()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CACHES:
				return getCaches();
			case HardwarePackage.PROCESSOR_DESCRIPTOR__TLBS:
				return getTlbs();
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CORES:
				return getCores();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CACHES:
				getCaches().clear();
				getCaches().addAll((Collection<? extends Cache>)newValue);
				return;
			case HardwarePackage.PROCESSOR_DESCRIPTOR__TLBS:
				getTlbs().clear();
				getTlbs().addAll((Collection<? extends TLB>)newValue);
				return;
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CORES:
				getCores().clear();
				getCores().addAll((Collection<? extends ProcessorCore>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CACHES:
				getCaches().clear();
				return;
			case HardwarePackage.PROCESSOR_DESCRIPTOR__TLBS:
				getTlbs().clear();
				return;
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CORES:
				getCores().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CACHES:
				return caches != null && !caches.isEmpty();
			case HardwarePackage.PROCESSOR_DESCRIPTOR__TLBS:
				return tlbs != null && !tlbs.isEmpty();
			case HardwarePackage.PROCESSOR_DESCRIPTOR__CORES:
				return cores != null && !cores.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //ProcessorDescriptorImpl
