/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import eu.qimpress.samm.core.impl.NamedEntityImpl;
import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.qimpress.samm.deployment.hardware.Cache;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Processor Core</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorCoreImpl#getCoreID <em>Core ID</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorCoreImpl#getCaches <em>Caches</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorCoreImpl#getDescriptor <em>Descriptor</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ProcessorCoreImpl extends NamedEntityImpl implements ProcessorCore {
	/**
	 * The default value of the '{@link #getCoreID() <em>Core ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCoreID()
	 * @generated
	 * @ordered
	 */
	protected static final int CORE_ID_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCaches() <em>Caches</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCaches()
	 * @generated
	 * @ordered
	 */
	protected EList<Cache> caches;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessorCoreImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HardwarePackage.Literals.PROCESSOR_CORE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public int getCoreID() {
		// The ID is the position in the list of cores of
		// the containing ProcessorDescriptor element
		if (eContainer instanceof ProcessorDescriptor) {
			try {
			return ((ProcessorDescriptor)eContainer).getCores().indexOf(this);
			} catch (NullPointerException e) {
			}
		}
		// ID could not have been detected.
		return -1;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCoreID(int newCoreID) {
		// TODO: implement this method to set the 'Core ID' attribute
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetCoreID() {
		// TODO: implement this method to unset the 'Core ID' attribute
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	public boolean isSetCoreID() {
		return true;
		//throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Cache> getCaches() {
		if (caches == null) {
			caches = new EObjectWithInverseResolvingEList.ManyInverse<Cache>(Cache.class, this, HardwarePackage.PROCESSOR_CORE__CACHES, HardwarePackage.CACHE__CORES);
		}
		return caches;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessorDescriptor getDescriptor() {
		if (eContainerFeatureID() != HardwarePackage.PROCESSOR_CORE__DESCRIPTOR) return null;
		return (ProcessorDescriptor)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDescriptor(ProcessorDescriptor newDescriptor, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newDescriptor, HardwarePackage.PROCESSOR_CORE__DESCRIPTOR, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescriptor(ProcessorDescriptor newDescriptor) {
		if (newDescriptor != eInternalContainer() || (eContainerFeatureID() != HardwarePackage.PROCESSOR_CORE__DESCRIPTOR && newDescriptor != null)) {
			if (EcoreUtil.isAncestor(this, newDescriptor))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newDescriptor != null)
				msgs = ((InternalEObject)newDescriptor).eInverseAdd(this, HardwarePackage.PROCESSOR_DESCRIPTOR__CORES, ProcessorDescriptor.class, msgs);
			msgs = basicSetDescriptor(newDescriptor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.PROCESSOR_CORE__DESCRIPTOR, newDescriptor, newDescriptor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_CORE__CACHES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getCaches()).basicAdd(otherEnd, msgs);
			case HardwarePackage.PROCESSOR_CORE__DESCRIPTOR:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetDescriptor((ProcessorDescriptor)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_CORE__CACHES:
				return ((InternalEList<?>)getCaches()).basicRemove(otherEnd, msgs);
			case HardwarePackage.PROCESSOR_CORE__DESCRIPTOR:
				return basicSetDescriptor(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case HardwarePackage.PROCESSOR_CORE__DESCRIPTOR:
				return eInternalContainer().eInverseRemove(this, HardwarePackage.PROCESSOR_DESCRIPTOR__CORES, ProcessorDescriptor.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_CORE__CORE_ID:
				return getCoreID();
			case HardwarePackage.PROCESSOR_CORE__CACHES:
				return getCaches();
			case HardwarePackage.PROCESSOR_CORE__DESCRIPTOR:
				return getDescriptor();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_CORE__CORE_ID:
				setCoreID((Integer)newValue);
				return;
			case HardwarePackage.PROCESSOR_CORE__CACHES:
				getCaches().clear();
				getCaches().addAll((Collection<? extends Cache>)newValue);
				return;
			case HardwarePackage.PROCESSOR_CORE__DESCRIPTOR:
				setDescriptor((ProcessorDescriptor)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_CORE__CORE_ID:
				unsetCoreID();
				return;
			case HardwarePackage.PROCESSOR_CORE__CACHES:
				getCaches().clear();
				return;
			case HardwarePackage.PROCESSOR_CORE__DESCRIPTOR:
				setDescriptor((ProcessorDescriptor)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HardwarePackage.PROCESSOR_CORE__CORE_ID:
				return isSetCoreID();
			case HardwarePackage.PROCESSOR_CORE__CACHES:
				return caches != null && !caches.isEmpty();
			case HardwarePackage.PROCESSOR_CORE__DESCRIPTOR:
				return getDescriptor() != null;
		}
		return super.eIsSet(featureID);
	}

} //ProcessorCoreImpl
