/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Network Interface Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.NetworkInterfaceDescriptorImpl#getLinkLatency <em>Link Latency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.NetworkInterfaceDescriptorImpl#getLinkSpeed <em>Link Speed</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NetworkInterfaceDescriptorImpl extends HardwareDescriptorImpl implements NetworkInterfaceDescriptor {
	/**
	 * The default value of the '{@link #getLinkLatency() <em>Link Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinkLatency()
	 * @generated
	 * @ordered
	 */
	protected static final double LINK_LATENCY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getLinkLatency() <em>Link Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinkLatency()
	 * @generated
	 * @ordered
	 */
	protected double linkLatency = LINK_LATENCY_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinkSpeed() <em>Link Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinkSpeed()
	 * @generated
	 * @ordered
	 */
	protected static final int LINK_SPEED_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinkSpeed() <em>Link Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinkSpeed()
	 * @generated
	 * @ordered
	 */
	protected int linkSpeed = LINK_SPEED_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkInterfaceDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HardwarePackage.Literals.NETWORK_INTERFACE_DESCRIPTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getLinkLatency() {
		return linkLatency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLinkLatency(double newLinkLatency) {
		double oldLinkLatency = linkLatency;
		linkLatency = newLinkLatency;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_LATENCY, oldLinkLatency, linkLatency));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLinkSpeed() {
		return linkSpeed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLinkSpeed(int newLinkSpeed) {
		int oldLinkSpeed = linkSpeed;
		linkSpeed = newLinkSpeed;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_SPEED, oldLinkSpeed, linkSpeed));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_LATENCY:
				return getLinkLatency();
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_SPEED:
				return getLinkSpeed();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_LATENCY:
				setLinkLatency((Double)newValue);
				return;
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_SPEED:
				setLinkSpeed((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_LATENCY:
				setLinkLatency(LINK_LATENCY_EDEFAULT);
				return;
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_SPEED:
				setLinkSpeed(LINK_SPEED_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_LATENCY:
				return linkLatency != LINK_LATENCY_EDEFAULT;
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR__LINK_SPEED:
				return linkSpeed != LINK_SPEED_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (linkLatency: ");
		result.append(linkLatency);
		result.append(", linkSpeed: ");
		result.append(linkSpeed);
		result.append(')');
		return result.toString();
	}

} //NetworkInterfaceDescriptorImpl
