/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Network Element Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.NetworkElementDescriptorImpl#getAggregateBandwidth <em>Aggregate Bandwidth</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.NetworkElementDescriptorImpl#getForwardingLatency <em>Forwarding Latency</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NetworkElementDescriptorImpl extends HardwareDescriptorImpl implements NetworkElementDescriptor {
	/**
	 * The default value of the '{@link #getAggregateBandwidth() <em>Aggregate Bandwidth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregateBandwidth()
	 * @generated
	 * @ordered
	 */
	protected static final int AGGREGATE_BANDWIDTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAggregateBandwidth() <em>Aggregate Bandwidth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregateBandwidth()
	 * @generated
	 * @ordered
	 */
	protected int aggregateBandwidth = AGGREGATE_BANDWIDTH_EDEFAULT;

	/**
	 * The default value of the '{@link #getForwardingLatency() <em>Forwarding Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getForwardingLatency()
	 * @generated
	 * @ordered
	 */
	protected static final double FORWARDING_LATENCY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getForwardingLatency() <em>Forwarding Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getForwardingLatency()
	 * @generated
	 * @ordered
	 */
	protected double forwardingLatency = FORWARDING_LATENCY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkElementDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HardwarePackage.Literals.NETWORK_ELEMENT_DESCRIPTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getAggregateBandwidth() {
		return aggregateBandwidth;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAggregateBandwidth(int newAggregateBandwidth) {
		int oldAggregateBandwidth = aggregateBandwidth;
		aggregateBandwidth = newAggregateBandwidth;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__AGGREGATE_BANDWIDTH, oldAggregateBandwidth, aggregateBandwidth));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getForwardingLatency() {
		return forwardingLatency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setForwardingLatency(double newForwardingLatency) {
		double oldForwardingLatency = forwardingLatency;
		forwardingLatency = newForwardingLatency;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__FORWARDING_LATENCY, oldForwardingLatency, forwardingLatency));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__AGGREGATE_BANDWIDTH:
				return getAggregateBandwidth();
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__FORWARDING_LATENCY:
				return getForwardingLatency();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__AGGREGATE_BANDWIDTH:
				setAggregateBandwidth((Integer)newValue);
				return;
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__FORWARDING_LATENCY:
				setForwardingLatency((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__AGGREGATE_BANDWIDTH:
				setAggregateBandwidth(AGGREGATE_BANDWIDTH_EDEFAULT);
				return;
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__FORWARDING_LATENCY:
				setForwardingLatency(FORWARDING_LATENCY_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__AGGREGATE_BANDWIDTH:
				return aggregateBandwidth != AGGREGATE_BANDWIDTH_EDEFAULT;
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR__FORWARDING_LATENCY:
				return forwardingLatency != FORWARDING_LATENCY_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (aggregateBandwidth: ");
		result.append(aggregateBandwidth);
		result.append(", forwardingLatency: ");
		result.append(forwardingLatency);
		result.append(')');
		return result.toString();
	}

} //NetworkElementDescriptorImpl
