/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.MemoryDescriptor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Memory Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl#getBandwidth <em>Bandwidth</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl#getFsbFrequency <em>Fsb Frequency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl#getAccessLatency <em>Access Latency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl#getBurstLength <em>Burst Length</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MemoryDescriptorImpl extends HardwareDescriptorImpl implements MemoryDescriptor {
	/**
	 * The default value of the '{@link #getBandwidth() <em>Bandwidth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBandwidth()
	 * @generated
	 * @ordered
	 */
	protected static final int BANDWIDTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getBandwidth() <em>Bandwidth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBandwidth()
	 * @generated
	 * @ordered
	 */
	protected int bandwidth = BANDWIDTH_EDEFAULT;

	/**
	 * The default value of the '{@link #getFsbFrequency() <em>Fsb Frequency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFsbFrequency()
	 * @generated
	 * @ordered
	 */
	protected static final int FSB_FREQUENCY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getFsbFrequency() <em>Fsb Frequency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFsbFrequency()
	 * @generated
	 * @ordered
	 */
	protected int fsbFrequency = FSB_FREQUENCY_EDEFAULT;

	/**
	 * The default value of the '{@link #getAccessLatency() <em>Access Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessLatency()
	 * @generated
	 * @ordered
	 */
	protected static final int ACCESS_LATENCY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAccessLatency() <em>Access Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessLatency()
	 * @generated
	 * @ordered
	 */
	protected int accessLatency = ACCESS_LATENCY_EDEFAULT;

	/**
	 * The default value of the '{@link #getBurstLength() <em>Burst Length</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBurstLength()
	 * @generated
	 * @ordered
	 */
	protected static final int BURST_LENGTH_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getBurstLength() <em>Burst Length</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBurstLength()
	 * @generated
	 * @ordered
	 */
	protected int burstLength = BURST_LENGTH_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HardwarePackage.Literals.MEMORY_DESCRIPTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getBandwidth() {
		return bandwidth;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBandwidth(int newBandwidth) {
		int oldBandwidth = bandwidth;
		bandwidth = newBandwidth;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.MEMORY_DESCRIPTOR__BANDWIDTH, oldBandwidth, bandwidth));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getFsbFrequency() {
		return fsbFrequency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFsbFrequency(int newFsbFrequency) {
		int oldFsbFrequency = fsbFrequency;
		fsbFrequency = newFsbFrequency;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.MEMORY_DESCRIPTOR__FSB_FREQUENCY, oldFsbFrequency, fsbFrequency));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getAccessLatency() {
		return accessLatency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessLatency(int newAccessLatency) {
		int oldAccessLatency = accessLatency;
		accessLatency = newAccessLatency;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.MEMORY_DESCRIPTOR__ACCESS_LATENCY, oldAccessLatency, accessLatency));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getBurstLength() {
		return burstLength;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBurstLength(int newBurstLength) {
		int oldBurstLength = burstLength;
		burstLength = newBurstLength;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.MEMORY_DESCRIPTOR__BURST_LENGTH, oldBurstLength, burstLength));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HardwarePackage.MEMORY_DESCRIPTOR__BANDWIDTH:
				return getBandwidth();
			case HardwarePackage.MEMORY_DESCRIPTOR__FSB_FREQUENCY:
				return getFsbFrequency();
			case HardwarePackage.MEMORY_DESCRIPTOR__ACCESS_LATENCY:
				return getAccessLatency();
			case HardwarePackage.MEMORY_DESCRIPTOR__BURST_LENGTH:
				return getBurstLength();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HardwarePackage.MEMORY_DESCRIPTOR__BANDWIDTH:
				setBandwidth((Integer)newValue);
				return;
			case HardwarePackage.MEMORY_DESCRIPTOR__FSB_FREQUENCY:
				setFsbFrequency((Integer)newValue);
				return;
			case HardwarePackage.MEMORY_DESCRIPTOR__ACCESS_LATENCY:
				setAccessLatency((Integer)newValue);
				return;
			case HardwarePackage.MEMORY_DESCRIPTOR__BURST_LENGTH:
				setBurstLength((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HardwarePackage.MEMORY_DESCRIPTOR__BANDWIDTH:
				setBandwidth(BANDWIDTH_EDEFAULT);
				return;
			case HardwarePackage.MEMORY_DESCRIPTOR__FSB_FREQUENCY:
				setFsbFrequency(FSB_FREQUENCY_EDEFAULT);
				return;
			case HardwarePackage.MEMORY_DESCRIPTOR__ACCESS_LATENCY:
				setAccessLatency(ACCESS_LATENCY_EDEFAULT);
				return;
			case HardwarePackage.MEMORY_DESCRIPTOR__BURST_LENGTH:
				setBurstLength(BURST_LENGTH_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HardwarePackage.MEMORY_DESCRIPTOR__BANDWIDTH:
				return bandwidth != BANDWIDTH_EDEFAULT;
			case HardwarePackage.MEMORY_DESCRIPTOR__FSB_FREQUENCY:
				return fsbFrequency != FSB_FREQUENCY_EDEFAULT;
			case HardwarePackage.MEMORY_DESCRIPTOR__ACCESS_LATENCY:
				return accessLatency != ACCESS_LATENCY_EDEFAULT;
			case HardwarePackage.MEMORY_DESCRIPTOR__BURST_LENGTH:
				return burstLength != BURST_LENGTH_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (bandwidth: ");
		result.append(bandwidth);
		result.append(", fsbFrequency: ");
		result.append(fsbFrequency);
		result.append(", accessLatency: ");
		result.append(accessLatency);
		result.append(", burstLength: ");
		result.append(burstLength);
		result.append(')');
		return result.toString();
	}

} //MemoryDescriptorImpl
