/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import de.uka.ipd.sdq.stoex.StoexPackage;
import eu.qimpress.identifier.IdentifierPackage;
import eu.qimpress.samm.annotation.AnnotationPackage;
import eu.qimpress.samm.annotation.impl.AnnotationPackageImpl;
import eu.qimpress.samm.behaviour.BehaviourPackage;
import eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl;
import eu.qimpress.samm.core.CorePackage;
import eu.qimpress.samm.core.impl.CorePackageImpl;
import eu.qimpress.samm.datatypes.DatatypesPackage;
import eu.qimpress.samm.datatypes.impl.DatatypesPackageImpl;
import eu.qimpress.samm.deployment.allocation.AllocationPackage;
import eu.qimpress.samm.deployment.allocation.impl.AllocationPackageImpl;
import eu.qimpress.samm.deployment.hardware.Cache;
import eu.qimpress.samm.deployment.hardware.CacheKind;
import eu.qimpress.samm.deployment.hardware.HardwareDescriptor;
import eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository;
import eu.qimpress.samm.deployment.hardware.HardwareFactory;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.MemoryDescriptor;
import eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor;
import eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;
import eu.qimpress.samm.deployment.targetenvironment.impl.TargetenvironmentPackageImpl;
import eu.qimpress.samm.qosannotation.QosannotationPackage;
import eu.qimpress.samm.qosannotation.impl.QosannotationPackageImpl;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.staticstructure.impl.StaticstructurePackageImpl;
import eu.qimpress.samm.usagemodel.UsagemodelPackage;
import eu.qimpress.samm.usagemodel.impl.UsagemodelPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class HardwarePackageImpl extends EPackageImpl implements HardwarePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass networkElementDescriptorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hardwareDescriptorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass tlbEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processorCoreEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass cacheEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processorDescriptorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass storageDeviceDescriptorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass memoryDescriptorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass hardwareDescriptorRepositoryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass networkInterfaceDescriptorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum cacheKindEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private HardwarePackageImpl() {
		super(eNS_URI, HardwareFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link HardwarePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static HardwarePackage init() {
		if (isInited) return (HardwarePackage)EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI);

		// Obtain or create and register package
		HardwarePackageImpl theHardwarePackage = (HardwarePackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof HardwarePackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new HardwarePackageImpl());

		isInited = true;

		// Initialize simple dependencies
		IdentifierPackage.eINSTANCE.eClass();
		StoexPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		StaticstructurePackageImpl theStaticstructurePackage = (StaticstructurePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(StaticstructurePackage.eNS_URI) instanceof StaticstructurePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(StaticstructurePackage.eNS_URI) : StaticstructurePackage.eINSTANCE);
		CorePackageImpl theCorePackage = (CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) instanceof CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) : CorePackage.eINSTANCE);
		DatatypesPackageImpl theDatatypesPackage = (DatatypesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(DatatypesPackage.eNS_URI) instanceof DatatypesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(DatatypesPackage.eNS_URI) : DatatypesPackage.eINSTANCE);
		BehaviourPackageImpl theBehaviourPackage = (BehaviourPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(BehaviourPackage.eNS_URI) instanceof BehaviourPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(BehaviourPackage.eNS_URI) : BehaviourPackage.eINSTANCE);
		TargetenvironmentPackageImpl theTargetenvironmentPackage = (TargetenvironmentPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(TargetenvironmentPackage.eNS_URI) instanceof TargetenvironmentPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(TargetenvironmentPackage.eNS_URI) : TargetenvironmentPackage.eINSTANCE);
		AllocationPackageImpl theAllocationPackage = (AllocationPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AllocationPackage.eNS_URI) instanceof AllocationPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AllocationPackage.eNS_URI) : AllocationPackage.eINSTANCE);
		AnnotationPackageImpl theAnnotationPackage = (AnnotationPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AnnotationPackage.eNS_URI) instanceof AnnotationPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AnnotationPackage.eNS_URI) : AnnotationPackage.eINSTANCE);
		UsagemodelPackageImpl theUsagemodelPackage = (UsagemodelPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(UsagemodelPackage.eNS_URI) instanceof UsagemodelPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(UsagemodelPackage.eNS_URI) : UsagemodelPackage.eINSTANCE);
		QosannotationPackageImpl theQosannotationPackage = (QosannotationPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(QosannotationPackage.eNS_URI) instanceof QosannotationPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(QosannotationPackage.eNS_URI) : QosannotationPackage.eINSTANCE);

		// Create package meta-data objects
		theHardwarePackage.createPackageContents();
		theStaticstructurePackage.createPackageContents();
		theCorePackage.createPackageContents();
		theDatatypesPackage.createPackageContents();
		theBehaviourPackage.createPackageContents();
		theTargetenvironmentPackage.createPackageContents();
		theAllocationPackage.createPackageContents();
		theAnnotationPackage.createPackageContents();
		theUsagemodelPackage.createPackageContents();
		theQosannotationPackage.createPackageContents();

		// Initialize created meta-data
		theHardwarePackage.initializePackageContents();
		theStaticstructurePackage.initializePackageContents();
		theCorePackage.initializePackageContents();
		theDatatypesPackage.initializePackageContents();
		theBehaviourPackage.initializePackageContents();
		theTargetenvironmentPackage.initializePackageContents();
		theAllocationPackage.initializePackageContents();
		theAnnotationPackage.initializePackageContents();
		theUsagemodelPackage.initializePackageContents();
		theQosannotationPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theHardwarePackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(HardwarePackage.eNS_URI, theHardwarePackage);
		return theHardwarePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNetworkElementDescriptor() {
		return networkElementDescriptorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNetworkElementDescriptor_AggregateBandwidth() {
		return (EAttribute)networkElementDescriptorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNetworkElementDescriptor_ForwardingLatency() {
		return (EAttribute)networkElementDescriptorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHardwareDescriptor() {
		return hardwareDescriptorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTLB() {
		return tlbEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTLB_Kind() {
		return (EAttribute)tlbEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTLB_EntryPageSize() {
		return (EAttribute)tlbEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTLB_Associativity() {
		return (EAttribute)tlbEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTLB_EntriesCount() {
		return (EAttribute)tlbEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessorCore() {
		return processorCoreEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProcessorCore_CoreID() {
		return (EAttribute)processorCoreEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessorCore_Caches() {
		return (EReference)processorCoreEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessorCore_Descriptor() {
		return (EReference)processorCoreEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCache() {
		return cacheEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCache_Level() {
		return (EAttribute)cacheEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCache_Kind() {
		return (EAttribute)cacheEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCache_Size() {
		return (EAttribute)cacheEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCache_Associativity() {
		return (EAttribute)cacheEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCache_CacheLineSize() {
		return (EAttribute)cacheEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getCache_AccessLatency() {
		return (EAttribute)cacheEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCache_Cores() {
		return (EReference)cacheEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProcessorDescriptor() {
		return processorDescriptorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessorDescriptor_Caches() {
		return (EReference)processorDescriptorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessorDescriptor_Tlbs() {
		return (EReference)processorDescriptorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProcessorDescriptor_Cores() {
		return (EReference)processorDescriptorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStorageDeviceDescriptor() {
		return storageDeviceDescriptorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStorageDeviceDescriptor_WriteSpeed() {
		return (EAttribute)storageDeviceDescriptorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStorageDeviceDescriptor_ReadSpeed() {
		return (EAttribute)storageDeviceDescriptorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStorageDeviceDescriptor_RequestLatency() {
		return (EAttribute)storageDeviceDescriptorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStorageDeviceDescriptor_CacheSize() {
		return (EAttribute)storageDeviceDescriptorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMemoryDescriptor() {
		return memoryDescriptorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMemoryDescriptor_Bandwidth() {
		return (EAttribute)memoryDescriptorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMemoryDescriptor_FsbFrequency() {
		return (EAttribute)memoryDescriptorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMemoryDescriptor_AccessLatency() {
		return (EAttribute)memoryDescriptorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMemoryDescriptor_BurstLength() {
		return (EAttribute)memoryDescriptorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getHardwareDescriptorRepository() {
		return hardwareDescriptorRepositoryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getHardwareDescriptorRepository_Descriptors() {
		return (EReference)hardwareDescriptorRepositoryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNetworkInterfaceDescriptor() {
		return networkInterfaceDescriptorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNetworkInterfaceDescriptor_LinkLatency() {
		return (EAttribute)networkInterfaceDescriptorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNetworkInterfaceDescriptor_LinkSpeed() {
		return (EAttribute)networkInterfaceDescriptorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getCacheKind() {
		return cacheKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HardwareFactory getHardwareFactory() {
		return (HardwareFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		networkElementDescriptorEClass = createEClass(NETWORK_ELEMENT_DESCRIPTOR);
		createEAttribute(networkElementDescriptorEClass, NETWORK_ELEMENT_DESCRIPTOR__AGGREGATE_BANDWIDTH);
		createEAttribute(networkElementDescriptorEClass, NETWORK_ELEMENT_DESCRIPTOR__FORWARDING_LATENCY);

		hardwareDescriptorEClass = createEClass(HARDWARE_DESCRIPTOR);

		tlbEClass = createEClass(TLB);
		createEAttribute(tlbEClass, TLB__KIND);
		createEAttribute(tlbEClass, TLB__ENTRY_PAGE_SIZE);
		createEAttribute(tlbEClass, TLB__ASSOCIATIVITY);
		createEAttribute(tlbEClass, TLB__ENTRIES_COUNT);

		processorCoreEClass = createEClass(PROCESSOR_CORE);
		createEAttribute(processorCoreEClass, PROCESSOR_CORE__CORE_ID);
		createEReference(processorCoreEClass, PROCESSOR_CORE__CACHES);
		createEReference(processorCoreEClass, PROCESSOR_CORE__DESCRIPTOR);

		cacheEClass = createEClass(CACHE);
		createEAttribute(cacheEClass, CACHE__LEVEL);
		createEAttribute(cacheEClass, CACHE__KIND);
		createEAttribute(cacheEClass, CACHE__SIZE);
		createEAttribute(cacheEClass, CACHE__ASSOCIATIVITY);
		createEAttribute(cacheEClass, CACHE__CACHE_LINE_SIZE);
		createEAttribute(cacheEClass, CACHE__ACCESS_LATENCY);
		createEReference(cacheEClass, CACHE__CORES);

		processorDescriptorEClass = createEClass(PROCESSOR_DESCRIPTOR);
		createEReference(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__CACHES);
		createEReference(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__TLBS);
		createEReference(processorDescriptorEClass, PROCESSOR_DESCRIPTOR__CORES);

		storageDeviceDescriptorEClass = createEClass(STORAGE_DEVICE_DESCRIPTOR);
		createEAttribute(storageDeviceDescriptorEClass, STORAGE_DEVICE_DESCRIPTOR__WRITE_SPEED);
		createEAttribute(storageDeviceDescriptorEClass, STORAGE_DEVICE_DESCRIPTOR__READ_SPEED);
		createEAttribute(storageDeviceDescriptorEClass, STORAGE_DEVICE_DESCRIPTOR__REQUEST_LATENCY);
		createEAttribute(storageDeviceDescriptorEClass, STORAGE_DEVICE_DESCRIPTOR__CACHE_SIZE);

		memoryDescriptorEClass = createEClass(MEMORY_DESCRIPTOR);
		createEAttribute(memoryDescriptorEClass, MEMORY_DESCRIPTOR__BANDWIDTH);
		createEAttribute(memoryDescriptorEClass, MEMORY_DESCRIPTOR__FSB_FREQUENCY);
		createEAttribute(memoryDescriptorEClass, MEMORY_DESCRIPTOR__ACCESS_LATENCY);
		createEAttribute(memoryDescriptorEClass, MEMORY_DESCRIPTOR__BURST_LENGTH);

		hardwareDescriptorRepositoryEClass = createEClass(HARDWARE_DESCRIPTOR_REPOSITORY);
		createEReference(hardwareDescriptorRepositoryEClass, HARDWARE_DESCRIPTOR_REPOSITORY__DESCRIPTORS);

		networkInterfaceDescriptorEClass = createEClass(NETWORK_INTERFACE_DESCRIPTOR);
		createEAttribute(networkInterfaceDescriptorEClass, NETWORK_INTERFACE_DESCRIPTOR__LINK_LATENCY);
		createEAttribute(networkInterfaceDescriptorEClass, NETWORK_INTERFACE_DESCRIPTOR__LINK_SPEED);

		// Create enums
		cacheKindEEnum = createEEnum(CACHE_KIND);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		CorePackage theCorePackage = (CorePackage)EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		networkElementDescriptorEClass.getESuperTypes().add(this.getHardwareDescriptor());
		hardwareDescriptorEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		processorCoreEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		processorDescriptorEClass.getESuperTypes().add(this.getHardwareDescriptor());
		storageDeviceDescriptorEClass.getESuperTypes().add(this.getHardwareDescriptor());
		memoryDescriptorEClass.getESuperTypes().add(this.getHardwareDescriptor());
		hardwareDescriptorRepositoryEClass.getESuperTypes().add(theCorePackage.getNamedEntity());
		networkInterfaceDescriptorEClass.getESuperTypes().add(this.getHardwareDescriptor());

		// Initialize classes and features; add operations and parameters
		initEClass(networkElementDescriptorEClass, NetworkElementDescriptor.class, "NetworkElementDescriptor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNetworkElementDescriptor_AggregateBandwidth(), ecorePackage.getEInt(), "aggregateBandwidth", null, 1, 1, NetworkElementDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getNetworkElementDescriptor_ForwardingLatency(), ecorePackage.getEDouble(), "forwardingLatency", null, 1, 1, NetworkElementDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(hardwareDescriptorEClass, HardwareDescriptor.class, "HardwareDescriptor", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(tlbEClass, eu.qimpress.samm.deployment.hardware.TLB.class, "TLB", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTLB_Kind(), this.getCacheKind(), "kind", null, 1, 1, eu.qimpress.samm.deployment.hardware.TLB.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getTLB_EntryPageSize(), ecorePackage.getEInt(), "entryPageSize", null, 1, 1, eu.qimpress.samm.deployment.hardware.TLB.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getTLB_Associativity(), ecorePackage.getEInt(), "associativity", null, 1, 1, eu.qimpress.samm.deployment.hardware.TLB.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getTLB_EntriesCount(), ecorePackage.getEInt(), "entriesCount", null, 1, 1, eu.qimpress.samm.deployment.hardware.TLB.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(processorCoreEClass, ProcessorCore.class, "ProcessorCore", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProcessorCore_CoreID(), ecorePackage.getEInt(), "coreID", null, 1, 1, ProcessorCore.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, IS_DERIVED, !IS_ORDERED);
		initEReference(getProcessorCore_Caches(), this.getCache(), this.getCache_Cores(), "caches", null, 0, -1, ProcessorCore.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getProcessorCore_Descriptor(), this.getProcessorDescriptor(), this.getProcessorDescriptor_Cores(), "descriptor", null, 1, 1, ProcessorCore.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(cacheEClass, Cache.class, "Cache", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCache_Level(), ecorePackage.getEInt(), "level", null, 1, 1, Cache.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getCache_Kind(), this.getCacheKind(), "kind", null, 1, 1, Cache.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getCache_Size(), ecorePackage.getEInt(), "size", null, 1, 1, Cache.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getCache_Associativity(), ecorePackage.getEInt(), "associativity", null, 1, 1, Cache.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getCache_CacheLineSize(), ecorePackage.getEInt(), "cacheLineSize", null, 1, 1, Cache.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getCache_AccessLatency(), ecorePackage.getEInt(), "accessLatency", null, 1, 1, Cache.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getCache_Cores(), this.getProcessorCore(), this.getProcessorCore_Caches(), "cores", null, 1, -1, Cache.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(processorDescriptorEClass, ProcessorDescriptor.class, "ProcessorDescriptor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProcessorDescriptor_Caches(), this.getCache(), null, "caches", null, 0, -1, ProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getProcessorDescriptor_Tlbs(), this.getTLB(), null, "tlbs", null, 0, -1, ProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getProcessorDescriptor_Cores(), this.getProcessorCore(), this.getProcessorCore_Descriptor(), "cores", null, 1, -1, ProcessorDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(storageDeviceDescriptorEClass, StorageDeviceDescriptor.class, "StorageDeviceDescriptor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStorageDeviceDescriptor_WriteSpeed(), ecorePackage.getEInt(), "writeSpeed", null, 1, 1, StorageDeviceDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getStorageDeviceDescriptor_ReadSpeed(), ecorePackage.getEInt(), "readSpeed", null, 1, 1, StorageDeviceDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getStorageDeviceDescriptor_RequestLatency(), ecorePackage.getEDouble(), "requestLatency", null, 1, 1, StorageDeviceDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getStorageDeviceDescriptor_CacheSize(), ecorePackage.getEInt(), "cacheSize", null, 1, 1, StorageDeviceDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(memoryDescriptorEClass, MemoryDescriptor.class, "MemoryDescriptor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMemoryDescriptor_Bandwidth(), ecorePackage.getEInt(), "bandwidth", null, 1, 1, MemoryDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getMemoryDescriptor_FsbFrequency(), ecorePackage.getEInt(), "fsbFrequency", null, 1, 1, MemoryDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getMemoryDescriptor_AccessLatency(), ecorePackage.getEInt(), "accessLatency", null, 1, 1, MemoryDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getMemoryDescriptor_BurstLength(), ecorePackage.getEInt(), "burstLength", null, 1, 1, MemoryDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(hardwareDescriptorRepositoryEClass, HardwareDescriptorRepository.class, "HardwareDescriptorRepository", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getHardwareDescriptorRepository_Descriptors(), this.getHardwareDescriptor(), null, "descriptors", null, 0, -1, HardwareDescriptorRepository.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(networkInterfaceDescriptorEClass, NetworkInterfaceDescriptor.class, "NetworkInterfaceDescriptor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNetworkInterfaceDescriptor_LinkLatency(), ecorePackage.getEDouble(), "linkLatency", null, 1, 1, NetworkInterfaceDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEAttribute(getNetworkInterfaceDescriptor_LinkSpeed(), ecorePackage.getEInt(), "linkSpeed", null, 1, 1, NetworkInterfaceDescriptor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(cacheKindEEnum, CacheKind.class, "CacheKind");
		addEEnumLiteral(cacheKindEEnum, CacheKind.INSTRUCTION);
		addEEnumLiteral(cacheKindEEnum, CacheKind.DATA);
		addEEnumLiteral(cacheKindEEnum, CacheKind.UNIFIED);

		// Create resource
		createResource(eNS_URI);
	}

} //HardwarePackageImpl
