/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import eu.qimpress.samm.deployment.hardware.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import eu.qimpress.samm.deployment.hardware.Cache;
import eu.qimpress.samm.deployment.hardware.CacheKind;
import eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository;
import eu.qimpress.samm.deployment.hardware.HardwareFactory;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.MemoryDescriptor;
import eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor;
import eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;
import eu.qimpress.samm.deployment.hardware.ProcessorDescriptor;
import eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor;
import eu.qimpress.samm.deployment.hardware.TLB;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class HardwareFactoryImpl extends EFactoryImpl implements HardwareFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static HardwareFactory init() {
		try {
			HardwareFactory theHardwareFactory = (HardwareFactory)EPackage.Registry.INSTANCE.getEFactory("http://q-impress.eu/samm/deployment/hardware"); 
			if (theHardwareFactory != null) {
				return theHardwareFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new HardwareFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HardwareFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case HardwarePackage.NETWORK_ELEMENT_DESCRIPTOR: return createNetworkElementDescriptor();
			case HardwarePackage.TLB: return createTLB();
			case HardwarePackage.PROCESSOR_CORE: return createProcessorCore();
			case HardwarePackage.CACHE: return createCache();
			case HardwarePackage.PROCESSOR_DESCRIPTOR: return createProcessorDescriptor();
			case HardwarePackage.STORAGE_DEVICE_DESCRIPTOR: return createStorageDeviceDescriptor();
			case HardwarePackage.MEMORY_DESCRIPTOR: return createMemoryDescriptor();
			case HardwarePackage.HARDWARE_DESCRIPTOR_REPOSITORY: return createHardwareDescriptorRepository();
			case HardwarePackage.NETWORK_INTERFACE_DESCRIPTOR: return createNetworkInterfaceDescriptor();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case HardwarePackage.CACHE_KIND:
				return createCacheKindFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case HardwarePackage.CACHE_KIND:
				return convertCacheKindToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NetworkElementDescriptor createNetworkElementDescriptor() {
		NetworkElementDescriptorImpl networkElementDescriptor = new NetworkElementDescriptorImpl();
		return networkElementDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TLB createTLB() {
		TLBImpl tlb = new TLBImpl();
		return tlb;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessorCore createProcessorCore() {
		ProcessorCoreImpl processorCore = new ProcessorCoreImpl();
		return processorCore;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Cache createCache() {
		CacheImpl cache = new CacheImpl();
		return cache;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProcessorDescriptor createProcessorDescriptor() {
		ProcessorDescriptorImpl processorDescriptor = new ProcessorDescriptorImpl();
		return processorDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StorageDeviceDescriptor createStorageDeviceDescriptor() {
		StorageDeviceDescriptorImpl storageDeviceDescriptor = new StorageDeviceDescriptorImpl();
		return storageDeviceDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MemoryDescriptor createMemoryDescriptor() {
		MemoryDescriptorImpl memoryDescriptor = new MemoryDescriptorImpl();
		return memoryDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HardwareDescriptorRepository createHardwareDescriptorRepository() {
		HardwareDescriptorRepositoryImpl hardwareDescriptorRepository = new HardwareDescriptorRepositoryImpl();
		return hardwareDescriptorRepository;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NetworkInterfaceDescriptor createNetworkInterfaceDescriptor() {
		NetworkInterfaceDescriptorImpl networkInterfaceDescriptor = new NetworkInterfaceDescriptorImpl();
		return networkInterfaceDescriptor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CacheKind createCacheKindFromString(EDataType eDataType, String initialValue) {
		CacheKind result = CacheKind.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCacheKindToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HardwarePackage getHardwarePackage() {
		return (HardwarePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static HardwarePackage getPackage() {
		return HardwarePackage.eINSTANCE;
	}

} //HardwareFactoryImpl
