/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.qimpress.samm.deployment.hardware.Cache;
import eu.qimpress.samm.deployment.hardware.CacheKind;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.hardware.ProcessorCore;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Cache</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl#getLevel <em>Level</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl#getKind <em>Kind</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl#getSize <em>Size</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl#getAssociativity <em>Associativity</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl#getCacheLineSize <em>Cache Line Size</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl#getAccessLatency <em>Access Latency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl#getCores <em>Cores</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CacheImpl extends EObjectImpl implements Cache {
	/**
	 * The default value of the '{@link #getLevel() <em>Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLevel()
	 * @generated
	 * @ordered
	 */
	protected static final int LEVEL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLevel() <em>Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLevel()
	 * @generated
	 * @ordered
	 */
	protected int level = LEVEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getKind() <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKind()
	 * @generated
	 * @ordered
	 */
	protected static final CacheKind KIND_EDEFAULT = CacheKind.INSTRUCTION;

	/**
	 * The cached value of the '{@link #getKind() <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKind()
	 * @generated
	 * @ordered
	 */
	protected CacheKind kind = KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected static final int SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected int size = SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAssociativity() <em>Associativity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssociativity()
	 * @generated
	 * @ordered
	 */
	protected static final int ASSOCIATIVITY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAssociativity() <em>Associativity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAssociativity()
	 * @generated
	 * @ordered
	 */
	protected int associativity = ASSOCIATIVITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getCacheLineSize() <em>Cache Line Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheLineSize()
	 * @generated
	 * @ordered
	 */
	protected static final int CACHE_LINE_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCacheLineSize() <em>Cache Line Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCacheLineSize()
	 * @generated
	 * @ordered
	 */
	protected int cacheLineSize = CACHE_LINE_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAccessLatency() <em>Access Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessLatency()
	 * @generated
	 * @ordered
	 */
	protected static final int ACCESS_LATENCY_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAccessLatency() <em>Access Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessLatency()
	 * @generated
	 * @ordered
	 */
	protected int accessLatency = ACCESS_LATENCY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCores() <em>Cores</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCores()
	 * @generated
	 * @ordered
	 */
	protected EList<ProcessorCore> cores;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CacheImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return HardwarePackage.Literals.CACHE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLevel() {
		return level;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLevel(int newLevel) {
		int oldLevel = level;
		level = newLevel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.CACHE__LEVEL, oldLevel, level));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CacheKind getKind() {
		return kind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setKind(CacheKind newKind) {
		CacheKind oldKind = kind;
		kind = newKind == null ? KIND_EDEFAULT : newKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.CACHE__KIND, oldKind, kind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getSize() {
		return size;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSize(int newSize) {
		int oldSize = size;
		size = newSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.CACHE__SIZE, oldSize, size));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getAssociativity() {
		return associativity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAssociativity(int newAssociativity) {
		int oldAssociativity = associativity;
		associativity = newAssociativity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.CACHE__ASSOCIATIVITY, oldAssociativity, associativity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCacheLineSize() {
		return cacheLineSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCacheLineSize(int newCacheLineSize) {
		int oldCacheLineSize = cacheLineSize;
		cacheLineSize = newCacheLineSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.CACHE__CACHE_LINE_SIZE, oldCacheLineSize, cacheLineSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getAccessLatency() {
		return accessLatency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessLatency(int newAccessLatency) {
		int oldAccessLatency = accessLatency;
		accessLatency = newAccessLatency;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HardwarePackage.CACHE__ACCESS_LATENCY, oldAccessLatency, accessLatency));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ProcessorCore> getCores() {
		if (cores == null) {
			cores = new EObjectWithInverseResolvingEList.ManyInverse<ProcessorCore>(ProcessorCore.class, this, HardwarePackage.CACHE__CORES, HardwarePackage.PROCESSOR_CORE__CACHES);
		}
		return cores;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HardwarePackage.CACHE__CORES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getCores()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case HardwarePackage.CACHE__CORES:
				return ((InternalEList<?>)getCores()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case HardwarePackage.CACHE__LEVEL:
				return getLevel();
			case HardwarePackage.CACHE__KIND:
				return getKind();
			case HardwarePackage.CACHE__SIZE:
				return getSize();
			case HardwarePackage.CACHE__ASSOCIATIVITY:
				return getAssociativity();
			case HardwarePackage.CACHE__CACHE_LINE_SIZE:
				return getCacheLineSize();
			case HardwarePackage.CACHE__ACCESS_LATENCY:
				return getAccessLatency();
			case HardwarePackage.CACHE__CORES:
				return getCores();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case HardwarePackage.CACHE__LEVEL:
				setLevel((Integer)newValue);
				return;
			case HardwarePackage.CACHE__KIND:
				setKind((CacheKind)newValue);
				return;
			case HardwarePackage.CACHE__SIZE:
				setSize((Integer)newValue);
				return;
			case HardwarePackage.CACHE__ASSOCIATIVITY:
				setAssociativity((Integer)newValue);
				return;
			case HardwarePackage.CACHE__CACHE_LINE_SIZE:
				setCacheLineSize((Integer)newValue);
				return;
			case HardwarePackage.CACHE__ACCESS_LATENCY:
				setAccessLatency((Integer)newValue);
				return;
			case HardwarePackage.CACHE__CORES:
				getCores().clear();
				getCores().addAll((Collection<? extends ProcessorCore>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case HardwarePackage.CACHE__LEVEL:
				setLevel(LEVEL_EDEFAULT);
				return;
			case HardwarePackage.CACHE__KIND:
				setKind(KIND_EDEFAULT);
				return;
			case HardwarePackage.CACHE__SIZE:
				setSize(SIZE_EDEFAULT);
				return;
			case HardwarePackage.CACHE__ASSOCIATIVITY:
				setAssociativity(ASSOCIATIVITY_EDEFAULT);
				return;
			case HardwarePackage.CACHE__CACHE_LINE_SIZE:
				setCacheLineSize(CACHE_LINE_SIZE_EDEFAULT);
				return;
			case HardwarePackage.CACHE__ACCESS_LATENCY:
				setAccessLatency(ACCESS_LATENCY_EDEFAULT);
				return;
			case HardwarePackage.CACHE__CORES:
				getCores().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case HardwarePackage.CACHE__LEVEL:
				return level != LEVEL_EDEFAULT;
			case HardwarePackage.CACHE__KIND:
				return kind != KIND_EDEFAULT;
			case HardwarePackage.CACHE__SIZE:
				return size != SIZE_EDEFAULT;
			case HardwarePackage.CACHE__ASSOCIATIVITY:
				return associativity != ASSOCIATIVITY_EDEFAULT;
			case HardwarePackage.CACHE__CACHE_LINE_SIZE:
				return cacheLineSize != CACHE_LINE_SIZE_EDEFAULT;
			case HardwarePackage.CACHE__ACCESS_LATENCY:
				return accessLatency != ACCESS_LATENCY_EDEFAULT;
			case HardwarePackage.CACHE__CORES:
				return cores != null && !cores.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (level: ");
		result.append(level);
		result.append(", kind: ");
		result.append(kind);
		result.append(", size: ");
		result.append(size);
		result.append(", associativity: ");
		result.append(associativity);
		result.append(", cacheLineSize: ");
		result.append(cacheLineSize);
		result.append(", accessLatency: ");
		result.append(accessLatency);
		result.append(')');
		return result.toString();
	}

} //CacheImpl
