/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TLB</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The TLB entity represents a Translation Lookaside Buffer which is used by the processor to speed up the translation of virtual addresses to physical.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.TLB#getKind <em>Kind</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.TLB#getEntryPageSize <em>Entry Page Size</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.TLB#getAssociativity <em>Associativity</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.TLB#getEntriesCount <em>Entries Count</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getTLB()
 * @model
 * @generated
 */
public interface TLB extends EObject {
	/**
	 * Returns the value of the '<em><b>Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link eu.qimpress.samm.deployment.hardware.CacheKind}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The kind of data the TLB is used for.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Kind</em>' attribute.
	 * @see eu.qimpress.samm.deployment.hardware.CacheKind
	 * @see #setKind(CacheKind)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getTLB_Kind()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	CacheKind getKind();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.TLB#getKind <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Kind</em>' attribute.
	 * @see eu.qimpress.samm.deployment.hardware.CacheKind
	 * @see #getKind()
	 * @generated
	 */
	void setKind(CacheKind value);

	/**
	 * Returns the value of the '<em><b>Entry Page Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The page size of a TLB entry. This is the value the operating system is expected to use for majority of purposes. 
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Entry Page Size</em>' attribute.
	 * @see #setEntryPageSize(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getTLB_EntryPageSize()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getEntryPageSize();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.TLB#getEntryPageSize <em>Entry Page Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Entry Page Size</em>' attribute.
	 * @see #getEntryPageSize()
	 * @generated
	 */
	void setEntryPageSize(int value);

	/**
	 * Returns the value of the '<em><b>Associativity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Associativity of the Translation Lookaside Buffer entries.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Associativity</em>' attribute.
	 * @see #setAssociativity(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getTLB_Associativity()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getAssociativity();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.TLB#getAssociativity <em>Associativity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Associativity</em>' attribute.
	 * @see #getAssociativity()
	 * @generated
	 */
	void setAssociativity(int value);

	/**
	 * Returns the value of the '<em><b>Entries Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The number of entries in this Translation Lookaside Buffer.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Entries Count</em>' attribute.
	 * @see #setEntriesCount(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getTLB_EntriesCount()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getEntriesCount();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.TLB#getEntriesCount <em>Entries Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Entries Count</em>' attribute.
	 * @see #getEntriesCount()
	 * @generated
	 */
	void setEntriesCount(int value);

} // TLB
