/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Storage Device Descriptor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The StorageDeviceDescriptor entity captures the properties of a physical disk or other storage devices. In case of network-based storage, the speeds and latencies should account for the properties of the (dedicated) transport fabric.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getWriteSpeed <em>Write Speed</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getReadSpeed <em>Read Speed</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getRequestLatency <em>Request Latency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getCacheSize <em>Cache Size</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getStorageDeviceDescriptor()
 * @model
 * @generated
 */
public interface StorageDeviceDescriptor extends HardwareDescriptor {
	/**
	 * Returns the value of the '<em><b>Write Speed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Average write speed, in bytes per second. Even though most contemporary disks support write caching, but this is a dangerous feature (unless the cache is battery backed) and is typically turned off.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Write Speed</em>' attribute.
	 * @see #setWriteSpeed(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getStorageDeviceDescriptor_WriteSpeed()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getWriteSpeed();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getWriteSpeed <em>Write Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Write Speed</em>' attribute.
	 * @see #getWriteSpeed()
	 * @generated
	 */
	void setWriteSpeed(int value);

	/**
	 * Returns the value of the '<em><b>Read Speed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Average read speed, in bytes per second. For single disk and random requests, this is in tens of megabytes per second. For cached requests, this may correspond to the link speed of the interface, but I assume that averages are sufficient.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Read Speed</em>' attribute.
	 * @see #setReadSpeed(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getStorageDeviceDescriptor_ReadSpeed()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getReadSpeed();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getReadSpeed <em>Read Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Read Speed</em>' attribute.
	 * @see #getReadSpeed()
	 * @generated
	 */
	void setReadSpeed(int value);

	/**
	 * Returns the value of the '<em><b>Request Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The average latency before the disk starts to serve a particular request, in seconds. The service time, however, is determined by the latency and the time it takes to transfer the data of the request.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Request Latency</em>' attribute.
	 * @see #setRequestLatency(double)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getStorageDeviceDescriptor_RequestLatency()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	double getRequestLatency();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getRequestLatency <em>Request Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Request Latency</em>' attribute.
	 * @see #getRequestLatency()
	 * @generated
	 */
	void setRequestLatency(double value);

	/**
	 * Returns the value of the '<em><b>Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Size of the disk cache, in bytes. Disk caches exhibit low hit-after-read or hit-after-write ratio, but high hit ratio of yet unread data that have been fetched into the cache by the disk read-ahead mechanism (during sequential read).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cache Size</em>' attribute.
	 * @see #setCacheSize(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getStorageDeviceDescriptor_CacheSize()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getCacheSize();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getCacheSize <em>Cache Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cache Size</em>' attribute.
	 * @see #getCacheSize()
	 * @generated
	 */
	void setCacheSize(int value);

} // StorageDeviceDescriptor
