/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Processor Descriptor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The ProcessorDescriptor entity describes the properties of a physical processor. This includes the execution cores, caches and cache hierarchy, and sharing of caches among execution cores. It does not, however, represent a physical instance of a processor installed on a Node in target environment. Note that clock frequency is not part of this description, rather it is an attribute of Processor instance installed on a node.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getCaches <em>Caches</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getTlbs <em>Tlbs</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getCores <em>Cores</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getProcessorDescriptor()
 * @model
 * @generated
 */
public interface ProcessorDescriptor extends HardwareDescriptor {
	/**
	 * Returns the value of the '<em><b>Caches</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.hardware.Cache}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A collection of memory caches the processor is equipped with. Simpler processor for embedded devices may actually have no cache.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Caches</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getProcessorDescriptor_Caches()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<Cache> getCaches();

	/**
	 * Returns the value of the '<em><b>Tlbs</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.hardware.TLB}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Translation Lookaside Buffers the processor is equipped with. Simple processors for embedded devices without virtual memory support will typically have no TLBs.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Tlbs</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getProcessorDescriptor_Tlbs()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<TLB> getTlbs();

	/**
	 * Returns the value of the '<em><b>Cores</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.hardware.ProcessorCore}.
	 * It is bidirectional and its opposite is '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lists processor cores of a particular processor. Each processor must have at least one processor core.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cores</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getProcessorDescriptor_Cores()
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorCore#getDescriptor
	 * @model opposite="descriptor" containment="true" required="true" ordered="false"
	 * @generated
	 */
	EList<ProcessorCore> getCores();

} // ProcessorDescriptor
